/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpFieldType;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public abstract class PhpUndefinedClassInspectionBase
extends PhpInspection {
    public boolean DONT_INSPECT_DOCS = false;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpUndefinedClassInspectionBase.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpDocType(PhpDocType type) {
                if (PhpUndefinedClassInspectionBase.this.isInspectDocs()) {
                    return;
                }
                ASTNode nameNode = type.getNameNode();
                if (nameNode == null) {
                    return;
                }
                String name = type.getName();
                assert (name != null);
                PhpType phpType = type.getGlobalType();
                if (PhpType.isArray((PhpType)phpType) && PsiTreeUtil.findChildOfType((PsiElement)type, PhpDocType.class) != null) {
                    return;
                }
                if (StringUtil.startsWithChar((CharSequence)(name = StringUtil.trimEnd((String)name, (String)"[]")), (char)'$') || PhpUndefinedClassInspectionBase.isPrimitiveType(phpType) || phpType.isAmbiguous() || name.equals("class-string")) {
                    return;
                }
                PsiElement anchor = nameNode.getPsi();
                ResolveResult[] results = ((PsiPolyVariantReference)type.getReference()).multiResolve(false);
                PhpUndefinedClassInspectionBase.this.checkClassResolveResult((PhpReference)type, name, anchor, results, holder, isOnTheFly);
            }

            public void visitPhpClassReference(ClassReference reference) {
                ASTNode nameNode = reference.getNameNode();
                if (nameNode == null) {
                    return;
                }
                String name = reference.getName();
                assert (name != null);
                if (StringUtil.startsWithChar((CharSequence)name, (char)'$')) {
                    return;
                }
                PsiElement parent = reference.getParent();
                Project project = reference.getProject();
                if (parent instanceof PhpTypeDeclaration && PhpUndefinedClassInspectionBase.isSuitableTypeDeclarationForPosition(project, (PhpTypeDeclaration)parent, name) || parent instanceof NewExpression && "readonly".equalsIgnoreCase(name) || (PhpType.isPrimitiveType((String)name) || PhpType.isResourceOrNumberType((String)name)) && (parent instanceof PhpTypeDeclaration && PhpUndefinedClassInspectionBase.primitiveTypesMightBeInTypeDeclaration((PhpTypeDeclaration)parent, name) || PhpPsiUtil.getParentOfClass((PsiElement)reference, true, PhpDocComment.class) != null)) {
                    return;
                }
                PsiElement anchor = nameNode.getPsi();
                if (parent instanceof PhpUse) {
                    String fqn = reference.getFQN();
                    if (!PhpIndex.getInstance((Project)project).getChildNamespacesByParentName(fqn + "\\").isEmpty()) {
                        return;
                    }
                    if (!PhpIndex.getInstance((Project)project).getNamespacesByName(fqn).isEmpty()) {
                        return;
                    }
                }
                ResolveResult[] results = ((PsiPolyVariantReference)reference.getReference()).multiResolve(false);
                PhpUndefinedClassInspectionBase.this.checkClassResolveResult((PhpReference)reference, name, anchor, results, holder, isOnTheFly);
            }
        };
    }

    protected abstract void checkClassResolveResult(PhpReference var1, String var2, PsiElement var3, ResolveResult[] var4, @NotNull ProblemsHolder var5, boolean var6);

    private static boolean isPrimitiveType(PhpType type) {
        return !type.isEmpty() && type.getTypes().stream().map(PhpType::unpluralize).allMatch(ts -> PhpType.isPrimitiveType((String)ts) || PhpType.isResourceOrNumberType((String)ts));
    }

    private static boolean primitiveTypesMightBeInTypeDeclaration(PhpTypeDeclaration typeDeclaration, String name) {
        PhpType type = new PhpType().add(name);
        if (PhpType.VOID.equals((Object)type) && PhpLanguageFeature.RETURN_VOID.isSupported(typeDeclaration.getProject())) {
            return true;
        }
        return PhpUndefinedClassInspectionBase.canBeUsedInTypeDeclaration(typeDeclaration, name);
    }

    public static boolean canBeUsedInTypeDeclaration(@NotNull PhpTypeDeclaration typeDeclaration, @NotNull String name) {
        PhpType type;
        if (typeDeclaration == null) {
            PhpUndefinedClassInspectionBase.$$$reportNull$$$0(1);
        }
        if (name == null) {
            PhpUndefinedClassInspectionBase.$$$reportNull$$$0(2);
        }
        if (PhpType.TRUE.equals((Object)(type = new PhpType().add(name)))) {
            return PhpLanguageLevel.current((Project)typeDeclaration.getProject()).isAtLeast(PhpLanguageLevel.PHP820);
        }
        if (!PhpType.FALSE.equals((Object)type) && !PhpType.NULL.equals((Object)type)) {
            return false;
        }
        return typeDeclaration.getClassReferences().size() > 1 || PhpLanguageFeature.UNION_TYPES.isSupported(typeDeclaration.getProject());
    }

    public static boolean isSuitableTypeDeclarationForPosition(Project project, @NotNull PhpTypeDeclaration position, String typeDecl) {
        if (position == null) {
            PhpUndefinedClassInspectionBase.$$$reportNull$$$0(3);
        }
        if (position instanceof PhpFieldType) {
            return PhpUndefinedClassInspectionBase.isFieldTypeHint(project, typeDecl);
        }
        if (position instanceof PhpReturnType) {
            return PhpLangUtil.isReturnTypeHint(typeDecl, project) && (!"static".equalsIgnoreCase(typeDecl) || PhpPsiUtil.getParentOfClass((PsiElement)position, PhpClass.class) != null);
        }
        return PhpLangUtil.isParameterTypeHint(typeDecl, project);
    }

    public boolean isInspectDocs() {
        return this.DONT_INSPECT_DOCS;
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"DONT_INSPECT_DOCS", (String)PhpBundle.message("inspection.undefined.class.ignore.phpdoc", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PhpUndefinedClassInspectionBase.$$$reportNull$$$0(4);
        }
        return optPane;
    }

    private static boolean isFieldTypeHint(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            PhpUndefinedClassInspectionBase.$$$reportNull$$$0(5);
        }
        if (name == null) {
            PhpUndefinedClassInspectionBase.$$$reportNull$$$0(6);
        }
        return !PhpType.isCallableType((String)PhpLangUtil.toFQN(name)) && PhpLangUtil.isParameterTypeHint(name, project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDeclaration";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedClassInspectionBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedClassInspectionBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canBeUsedInTypeDeclaration";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableTypeDeclarationForPosition";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isFieldTypeHint";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

