/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandQuickFix;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpCallbackFunctionUtil;
import com.jetbrains.php.lang.PhpCallbackReferenceBase;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddFieldDeclarationQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddMethodDeclarationQuickFix;
import com.jetbrains.php.lang.intentions.PhpDeclareFieldIntention;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.PhpNameSuggestionUtil;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUndefinedCallbackInspection
extends PhpInspection {
    public static final PhpAddMethodFromCallbackQuickFix METHOD_FIX = new PhpAddMethodFromCallbackQuickFix();
    public static final PhpAddFunctionFromCallbackQuickFix FUNCTION_FIX = new PhpAddFunctionFromCallbackQuickFix();
    public static final PhpAddFieldFromCallbackQuickFix FIELD_FIX = new PhpAddFieldFromCallbackQuickFix();
    public boolean DONT_REPORT_EXISTS_CALLBACKS = true;
    public boolean DONT_REPORT_AMBIGUITY = true;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpUndefinedCallbackInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference reference) {
                this.checkForCallback(reference);
            }

            public void visitPhpMethodReference(MethodReference reference) {
                this.checkForCallback((FunctionReference)reference);
            }

            private void checkForCallback(@NotNull FunctionReference reference) {
                String functionName;
                if (reference == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (StringUtil.isEmpty((String)(functionName = reference.getName())) || PhpUndefinedCallbackInspection.this.DONT_REPORT_EXISTS_CALLBACKS && PhpCallbackFunctionUtil.isExistsCallbackFunction(functionName)) {
                    return;
                }
                PsiElement[] arguments = reference.getParameters();
                if (arguments.length == 0) {
                    return;
                }
                if (PhpCallbackFunctionUtil.isStandardFunctionCallbackFunction(functionName)) {
                    this.resolveFunctionCallback(arguments[0]);
                } else if (PhpCallbackFunctionUtil.isMethodCallbackFunction(reference, 1)) {
                    if (arguments.length == 1) {
                        return;
                    }
                    this.resolveMemberCallback(arguments[0], arguments[1], true);
                } else if (PhpCallbackFunctionUtil.isFieldCallbackFunction(reference, 1)) {
                    if (arguments.length == 1) {
                        return;
                    }
                    this.resolveMemberCallback(arguments[0], arguments[1], false);
                } else if (PhpCallbackFunctionUtil.isClassCallbackFunction(reference, 0)) {
                    if (PhpUndefinedCallbackInspection.hasUnresolvedCallbackReference(arguments[0])) {
                        this.registerClassNotFound(arguments[0]);
                    }
                } else {
                    boolean canHaveCallbackArguments = false;
                    for (PsiElement argument : arguments) {
                        if (!(argument instanceof StringLiteralExpression) && !(argument instanceof ArrayCreationExpression)) continue;
                        canHaveCallbackArguments = true;
                        break;
                    }
                    if (!canHaveCallbackArguments) {
                        return;
                    }
                    PsiElement resolve2 = reference.resolve();
                    if (resolve2 instanceof Function) {
                        Parameter[] parameters = ((Function)resolve2).getParameters();
                        int length = Math.min(parameters.length, arguments.length);
                        for (int i = 0; i < length; ++i) {
                            PsiElement argument = arguments[i];
                            if (!PhpUndefinedCallbackInspection.isCallableParameter(parameters[i], argument, PhpUndefinedCallbackInspection.this.DONT_REPORT_AMBIGUITY)) continue;
                            this.resolveFunctionCallback(argument);
                        }
                    }
                }
            }

            private void resolveFunctionCallback(@NotNull PsiElement argument) {
                String text;
                PhpCallbackFunctionUtil.PhpCallbackInfoHolder callback;
                if (argument == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((callback = PhpCallbackFunctionUtil.createCallback(argument)) == null || !PhpNameUtil.isValidFunctionName(PhpLangUtil.toShortName(callback.getCallbackText()))) {
                    return;
                }
                PsiElement element = callback.getCallbackElement();
                if (callback instanceof PhpCallbackFunctionUtil.PhpMemberCallbackInfoHolder) {
                    this.resolveMemberCallback(((PhpCallbackFunctionUtil.PhpMemberCallbackInfoHolder)callback).getClassElement(), element, true);
                } else if (PhpUndefinedCallbackInspection.hasUnresolvedCallbackReference(element) && StringUtil.isNotEmpty((String)(text = PhpCodeInsightUtil.toString(element, false)))) {
                    LocalQuickFix[] localQuickFixArray;
                    if (FUNCTION_FIX.isApplicable(element)) {
                        PhpAddFunctionFromCallbackQuickFix[] phpAddFunctionFromCallbackQuickFixArray = new PhpAddFunctionFromCallbackQuickFix[1];
                        localQuickFixArray = phpAddFunctionFromCallbackQuickFixArray;
                        phpAddFunctionFromCallbackQuickFixArray[0] = FUNCTION_FIX;
                    } else {
                        localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                    }
                    LocalQuickFix[] fixes = localQuickFixArray;
                    holder.registerProblem(element, PhpBundle.message("inspection.undefined.callback.function", text), fixes);
                }
            }

            private void resolveMemberCallback(@NotNull PsiElement classRef, @NotNull PsiElement memberRef, boolean isMethodReference) {
                if (classRef == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (memberRef == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (PhpUndefinedCallbackInspection.hasUnresolvedCallbackReference(memberRef)) {
                    String text = PhpCodeInsightUtil.toString(memberRef, false);
                    if (StringUtil.isEmpty((String)text)) {
                        return;
                    }
                    String classFqn = PhpUndefinedCallbackInspection.checkClassReference(classRef);
                    if (StringUtil.isEmpty((String)classFqn)) {
                        if (classRef instanceof StringLiteralExpression) {
                            this.registerClassNotFound(classRef);
                        }
                        return;
                    }
                    if (isMethodReference) {
                        LocalQuickFix[] localQuickFixArray;
                        String message;
                        String string = message = isOnTheFly ? PhpBundle.message("inspection.undefined.callback.method", text, classFqn) : PhpBundle.message("method.ref.not.found", new Object[0]);
                        if (METHOD_FIX.isApplicable(memberRef)) {
                            PhpAddMethodFromCallbackQuickFix[] phpAddMethodFromCallbackQuickFixArray = new PhpAddMethodFromCallbackQuickFix[1];
                            localQuickFixArray = phpAddMethodFromCallbackQuickFixArray;
                            phpAddMethodFromCallbackQuickFixArray[0] = METHOD_FIX;
                        } else {
                            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                        }
                        LocalQuickFix[] fixes = localQuickFixArray;
                        holder.registerProblem(memberRef, message, fixes);
                    } else {
                        @Nls String message = isOnTheFly ? PhpBundle.message("inspection.undefined.callback.field", text, classFqn) : PhpBundle.message("field.ref.not.found", new Object[0]);
                        holder.registerProblem(memberRef, message, 1.getFixes(memberRef));
                    }
                } else if (PhpUndefinedCallbackInspection.hasUnresolvedCallbackReference(classRef)) {
                    this.registerClassNotFound(classRef);
                }
            }

            private static LocalQuickFix[] getFixes(@NotNull PsiElement memberRef) {
                if (memberRef == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (FIELD_FIX.isApplicable(memberRef)) {
                    return new PhpAddFieldFromCallbackQuickFix[]{FIELD_FIX};
                }
                return LocalQuickFix.EMPTY_ARRAY;
            }

            private void registerClassNotFound(@NotNull PsiElement element) {
                String text;
                if (element == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (StringUtil.isNotEmpty((String)(text = PhpCodeInsightUtil.toString(element, false)))) {
                    holder.registerProblem(element, PhpBundle.message("inspection.undefined.callback.class", text), new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "argument";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "classRef";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "memberRef";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedCallbackInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkForCallback";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "resolveFunctionCallback";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "resolveMemberCallback";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getFixes";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerClassNotFound";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    public static String checkClassReference(@NotNull PsiElement classRef) {
        if (classRef == null) {
            PhpUndefinedCallbackInspection.$$$reportNull$$$0(1);
        }
        if (classRef instanceof StringLiteralExpression) {
            PsiReference[] references = classRef.getReferences();
            if (references.length == 1 && references[0] instanceof PhpCallbackReferenceBase) {
                ResolveResult[] results = ((PhpCallbackReferenceBase)references[0]).multiResolve(false);
                if (results.length == 0) {
                    return null;
                }
                PsiElement element = results[0].getElement();
                return element instanceof PhpClass ? ((PhpClass)element).getFQN() : null;
            }
        } else {
            PhpType type = PhpCallbackFunctionUtil.getClassReferenceType(classRef);
            if (type != null) {
                return type.filterPrimitives().filterOut("\\class-string"::startsWith).filterOut(PhpType::isResourceOrNumberType).toStringResolved();
            }
        }
        return null;
    }

    public static boolean hasUnresolvedCallbackReference(@NotNull PsiElement element) {
        PsiReference[] references;
        if (element == null) {
            PhpUndefinedCallbackInspection.$$$reportNull$$$0(2);
        }
        if (element instanceof StringLiteralExpression && (references = element.getReferences()).length == 1 && references[0] instanceof PhpCallbackReferenceBase) {
            return ((PhpCallbackReferenceBase)references[0]).multiResolve(false).length == 0;
        }
        return false;
    }

    public static boolean isCallableParameter(@NotNull Parameter parameter, @NotNull PsiElement argument, boolean dontReportAmbiguity) {
        if (parameter == null) {
            PhpUndefinedCallbackInspection.$$$reportNull$$$0(3);
        }
        if (argument == null) {
            PhpUndefinedCallbackInspection.$$$reportNull$$$0(4);
        }
        if (argument instanceof StringLiteralExpression || argument instanceof ArrayCreationExpression) {
            PhpType type = parameter.getGlobalType();
            if (dontReportAmbiguity) {
                Set types = type.getTypes();
                return types.size() == 1 && PhpType.isCallableType((String)((String)types.iterator().next()));
            }
            return PhpCallbackFunctionUtil.isCallable(type);
        }
        return false;
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"DONT_REPORT_EXISTS_CALLBACKS", (String)PhpBundle.message("inspection.undefined.callback.dont.report.exist.checkbox", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"DONT_REPORT_AMBIGUITY", (String)PhpBundle.message("inspection.undefined.callback.dont.report.ambiguity.checkbox", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PhpUndefinedCallbackInspection.$$$reportNull$$$0(5);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classRef";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedCallbackInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedCallbackInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkClassReference";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasUnresolvedCallbackReference";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCallableParameter";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    public static class PhpAddMethodFromCallbackQuickFix
    extends PhpAddMethodDeclarationQuickFix {
        @Override
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.create.method.from.callback.name", new Object[0]);
            if (string == null) {
                PhpAddMethodFromCallbackQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            PhpCallbackReferenceBase.PhpClassMemberCallbackReference ref;
            if (project == null) {
                PhpAddMethodFromCallbackQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpAddMethodFromCallbackQuickFix.$$$reportNull$$$0(2);
            }
            if ((ref = PhpAddMethodFromCallbackQuickFix.getOnlyReference(element = descriptor.getPsiElement())) == null) {
                return;
            }
            PhpClass klass = (PhpClass)ContainerUtil.getFirstItem(ref.resolveClassReference());
            if (klass == null) {
                return;
            }
            Method templateMethod = this.createMethodFromTemplate(element, ref, klass);
            if (FileModificationService.getInstance().prepareFileForWrite(klass.getContainingFile())) {
                WriteAction.run(() -> {
                    PsiElement inserted = PhpCodeEditUtil.insertClassMember(klass, (PsiElement)templateMethod);
                    PsiElement method = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)((Method)inserted));
                    PhpAddFieldDeclarationQuickFix.runTemplate(method, PhpAddMethodFromCallbackQuickFix.createMethodTemplate(method), (TemplateEditingListener)new TemplateEditingAdapter(this){

                        public void templateFinished(@NotNull Template template1, boolean brokenOff) {
                            if (template1 == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (!brokenOff) {
                                PhpCodeEditUtil.setupMethodBody(project);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template1", "com/jetbrains/php/lang/inspections/PhpUndefinedCallbackInspection$PhpAddMethodFromCallbackQuickFix$1", "templateFinished"));
                        }
                    });
                });
            }
        }

        @Override
        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            PhpCallbackReferenceBase.PhpClassMemberCallbackReference ref;
            if (project == null) {
                PhpAddMethodFromCallbackQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                PhpAddMethodFromCallbackQuickFix.$$$reportNull$$$0(4);
            }
            if ((ref = PhpAddMethodFromCallbackQuickFix.getOnlyReference(element = descriptor.getPsiElement())) == null) {
                IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
                if (intentionPreviewInfo == null) {
                    PhpAddMethodFromCallbackQuickFix.$$$reportNull$$$0(5);
                }
                return intentionPreviewInfo;
            }
            PhpClass klass = (PhpClass)ContainerUtil.getFirstItem(ref.resolveClassReference());
            Method templateMethod = this.createMethodFromTemplate(element, ref, klass);
            return new IntentionPreviewInfo.CustomDiff((FileType)PhpFileType.INSTANCE, klass.getContainingFile().getName(), "", templateMethod.getText());
        }

        @NotNull
        private Method createMethodFromTemplate(PsiElement element, PhpCallbackReferenceBase.PhpClassMemberCallbackReference ref, PhpClass klass) {
            String parameters = this.createParameters(element);
            String methodName = ref.getClassMemberName();
            Method method = PhpAddMethodFromCallbackQuickFix.createMethodFromTemplate(element, parameters, methodName, ref.isStaticRef(), klass);
            if (method == null) {
                PhpAddMethodFromCallbackQuickFix.$$$reportNull$$$0(6);
            }
            return method;
        }

        @Override
        public boolean isApplicable(@NotNull PsiElement element) {
            PhpCallbackReferenceBase.PhpClassMemberCallbackReference ref;
            if (element == null) {
                PhpAddMethodFromCallbackQuickFix.$$$reportNull$$$0(7);
            }
            if ((ref = PhpAddMethodFromCallbackQuickFix.getOnlyReference(element)) == null) {
                return false;
            }
            String methodName = ref.getClassMemberName();
            if (StringUtil.isEmpty((String)methodName)) {
                return false;
            }
            if (ref.resolveClassReference().size() != 1) {
                return false;
            }
            return super.isApplicable(element);
        }

        @Nullable
        public static PhpCallbackReferenceBase.PhpClassMemberCallbackReference getOnlyReference(@NotNull PsiElement element) {
            PsiReference[] references;
            if (element == null) {
                PhpAddMethodFromCallbackQuickFix.$$$reportNull$$$0(8);
            }
            if ((references = element.getReferences()).length != 1 || !(references[0] instanceof PhpCallbackReferenceBase.PhpClassMemberCallbackReference)) {
                return null;
            }
            return (PhpCallbackReferenceBase.PhpClassMemberCallbackReference)references[0];
        }

        @NotNull
        protected String createParameters(@NotNull PsiElement element) {
            PhpPsiElement nextParameter;
            if (element == null) {
                PhpAddMethodFromCallbackQuickFix.$$$reportNull$$$0(9);
            }
            Object argument = PhpPsiUtil.getParentByCondition(element, false, PhpCallbackFunctionUtil.FUNCTION_ARGUMENT);
            StringBuilder builder2 = new StringBuilder("(");
            if (argument instanceof PhpPsiElement && (nextParameter = ((PhpPsiElement)argument).getNextPsiSibling()) != null && nextParameter.getParent() == argument.getParent() && nextParameter instanceof ArrayCreationExpression) {
                PsiElement[] item = nextParameter.getChildren();
                int length = item.length;
                for (int i = 0; i < length; ++i) {
                    if (i > 0) {
                        builder2.append(",");
                    }
                    PsiElement value = item[i];
                    PsiElement content = PhpCallbackFunctionUtil.getArrayValueContent(value);
                    builder2.append("$");
                    builder2.append(PhpNameSuggestionUtil.parameterNameByElement(content));
                    builder2.append(i);
                }
            }
            builder2.append(")");
            String string = builder2.toString();
            if (string == null) {
                PhpAddMethodFromCallbackQuickFix.$$$reportNull$$$0(10);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 7, 8, 9 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedCallbackInspection$PhpAddMethodFromCallbackQuickFix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedCallbackInspection$PhpAddMethodFromCallbackQuickFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createMethodFromTemplate";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createParameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplicable";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getOnlyReference";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createParameters";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 7, 8, 9 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class PhpAddFunctionFromCallbackQuickFix
    extends PhpAddMethodFromCallbackQuickFix {
        @Override
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.create.function.from.callback.family.name", new Object[0]);
            if (string == null) {
                PhpAddFunctionFromCallbackQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getName() {
            String string = PhpBundle.message("quickfix.create.function.from.callback.name", new Object[0]);
            if (string == null) {
                PhpAddFunctionFromCallbackQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            String fqn;
            if (project == null) {
                PhpAddFunctionFromCallbackQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                PhpAddFunctionFromCallbackQuickFix.$$$reportNull$$$0(3);
            }
            if (StringUtil.isEmpty((String)(fqn = PhpCallbackFunctionUtil.getCallbackString(element = descriptor.getPsiElement())))) {
                return;
            }
            String name = PhpLangUtil.toShortName(fqn);
            Function function = PhpPsiElementFactory.createFunction(project, "function " + name + this.createParameters(element) + "{}");
            PsiElement anchor = PhpAddFunctionFromCallbackQuickFix.getElementScope(element);
            if (anchor != null) {
                anchor.getParent().addAfter((PsiElement)function, anchor);
            }
        }

        @Override
        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpAddFunctionFromCallbackQuickFix.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                PhpAddFunctionFromCallbackQuickFix.$$$reportNull$$$0(5);
            }
            IntentionPreviewInfo intentionPreviewInfo = super.generatePreviewBase(project, descriptor);
            if (intentionPreviewInfo == null) {
                PhpAddFunctionFromCallbackQuickFix.$$$reportNull$$$0(6);
            }
            return intentionPreviewInfo;
        }

        @Override
        public boolean startInWriteAction() {
            return true;
        }

        @Override
        public boolean isApplicable(@NotNull PsiElement element) {
            String fqn;
            if (element == null) {
                PhpAddFunctionFromCallbackQuickFix.$$$reportNull$$$0(7);
            }
            if (StringUtil.isEmpty((String)(fqn = PhpCallbackFunctionUtil.getCallbackString(element)))) {
                return false;
            }
            String namespace = PhpLangUtil.getParentQualifiedName(fqn);
            return PhpAddFunctionFromCallbackQuickFix.isCalledFromTheSameNamespace(element, namespace);
        }

        private static boolean isCalledFromTheSameNamespace(@NotNull PsiElement element, @NotNull String namespace) {
            PhpNamespace parentNamespace;
            if (element == null) {
                PhpAddFunctionFromCallbackQuickFix.$$$reportNull$$$0(8);
            }
            if (namespace == null) {
                PhpAddFunctionFromCallbackQuickFix.$$$reportNull$$$0(9);
            }
            if ((parentNamespace = PhpPsiUtil.getParentOfClass(element, true, PhpNamespace.class)) == null) {
                return StringUtil.isEmpty((String)namespace) || StringUtil.equals((CharSequence)namespace, (CharSequence)"\\");
            }
            String originalNamespace = parentNamespace.getNamespaceName();
            return PhpLangUtil.equalsClassNames(originalNamespace, namespace);
        }

        @Nullable
        private static PsiElement getElementScope(@NotNull PsiElement element) {
            PhpClass parentClass;
            if (element == null) {
                PhpAddFunctionFromCallbackQuickFix.$$$reportNull$$$0(10);
            }
            if ((parentClass = PhpPsiUtil.getParentOfClass(element, true, PhpClass.class)) != null) {
                return parentClass;
            }
            Function parentFunction = PhpPsiUtil.getParentOfClass(element, true, Function.class);
            if (parentFunction != null) {
                return parentFunction;
            }
            ControlStatement controlStatement = PhpPsiUtil.getParentOfClass(element, true, ControlStatement.class);
            return controlStatement == null ? PhpPsiUtil.getParentOfClass(element, true, Statement.class) : controlStatement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5, 7, 8, 9, 10 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedCallbackInspection$PhpAddFunctionFromCallbackQuickFix";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 7: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedCallbackInspection$PhpAddFunctionFromCallbackQuickFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplicable";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "isCalledFromTheSameNamespace";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementScope";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5, 7, 8, 9, 10 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class PhpAddFieldFromCallbackQuickFix
    extends ModCommandQuickFix {
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.create.field.from.callback.name", new Object[0]);
            if (string == null) {
                PhpAddFieldFromCallbackQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public ModCommand perform(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            PhpCallbackReferenceBase.PhpClassMemberCallbackReference ref;
            if (project == null) {
                PhpAddFieldFromCallbackQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpAddFieldFromCallbackQuickFix.$$$reportNull$$$0(2);
            }
            if ((ref = PhpAddMethodFromCallbackQuickFix.getOnlyReference(element = descriptor.getPsiElement())) == null) {
                ModCommand modCommand = ModCommand.nop();
                if (modCommand == null) {
                    PhpAddFieldFromCallbackQuickFix.$$$reportNull$$$0(3);
                }
                return modCommand;
            }
            PhpClass klass = ref.resolveClassReference().iterator().next();
            String fieldName = ref.getClassMemberName();
            if (fieldName == null) {
                ModCommand modCommand = ModCommand.nop();
                if (modCommand == null) {
                    PhpAddFieldFromCallbackQuickFix.$$$reportNull$$$0(4);
                }
                return modCommand;
            }
            if (!ModuleUtilCore.projectContainsFile((Project)project, (VirtualFile)klass.getContainingFile().getVirtualFile(), (boolean)false)) {
                ModCommand modCommand = ModCommand.error((String)PhpBundle.message("the.original.class.0.does.not.belong.to.the.project.and.cannot.be.modified", klass.getName()));
                if (modCommand == null) {
                    PhpAddFieldFromCallbackQuickFix.$$$reportNull$$$0(5);
                }
                return modCommand;
            }
            PhpCodeStyleSettings settings = (PhpCodeStyleSettings)CodeStyle.getSettings((Project)project).getCustomSettings(PhpCodeStyleSettings.class);
            ModCommand modCommand = ModCommand.psiUpdate((PsiElement)klass, (writableClass, updater) -> {
                PhpModifier modifier = PhpModifier.instance((PhpModifier.Access)settings.FIELDS_DEFAULT_VISIBILITY, (PhpModifier.Abstractness)PhpModifier.Abstractness.IMPLEMENTED, (PhpModifier.State)(ref.isStaticRef() ? PhpModifier.State.STATIC : PhpModifier.State.DYNAMIC));
                PhpPsiElement field = PhpPsiElementFactory.createClassField(project, modifier, false, fieldName, null, PhpRefactoringUtil.createFieldTypeDeclaration(project, null, (PsiElement)writableClass));
                PsiElement insertedFields = PhpCodeEditUtil.insertClassMemberWithPhpDoc(writableClass, (PsiElement)field, null);
                PhpDeclareFieldIntention.createFieldTemplate(updater, (PhpPsiElement)insertedFields);
            });
            if (modCommand == null) {
                PhpAddFieldFromCallbackQuickFix.$$$reportNull$$$0(6);
            }
            return modCommand;
        }

        public boolean isApplicable(@NotNull PsiElement element) {
            PhpCallbackReferenceBase.PhpClassMemberCallbackReference ref;
            if (element == null) {
                PhpAddFieldFromCallbackQuickFix.$$$reportNull$$$0(7);
            }
            if ((ref = PhpAddMethodFromCallbackQuickFix.getOnlyReference(element)) == null) {
                return false;
            }
            String fieldName = ref.getClassMemberName();
            if (StringUtil.isEmpty((String)fieldName)) {
                return false;
            }
            Collection<PhpClass> classes = ref.resolveClassReference();
            return classes.size() == 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 7 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedCallbackInspection$PhpAddFieldFromCallbackQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedCallbackInspection$PhpAddFieldFromCallbackQuickFix";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "perform";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplicable";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 7 -> new IllegalArgumentException(string);
            };
        }
    }
}

