/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.config.PhpAnalysisConfiguration;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.inspections.exception.PhpExceptionAnalysisService;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpThrownExceptionsAnalyzer {
    private PhpThrownExceptionsAnalyzer() {
    }

    @NotNull
    public static Collection<String> filterNonThrowable(@NotNull Set<String> exceptions, @NotNull Project project) {
        if (exceptions == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(0);
        }
        if (project == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(1);
        }
        SmartList types = new SmartList();
        PhpIndex index = PhpIndex.getInstance((Project)project);
        for (String type : exceptions) {
            if (!PhpThrownExceptionsAnalyzer.isException(type, index)) continue;
            types.add(type);
        }
        SmartList smartList = types;
        if (smartList == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(2);
        }
        return smartList;
    }

    @NotNull
    public static Collection<String> filterNonThrowable(@NotNull PhpType exceptions, @NotNull Project project) {
        if (exceptions == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(3);
        }
        if (project == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(4);
        }
        return PhpThrownExceptionsAnalyzer.filterNonThrowable(exceptions.global(project).getTypes(), project);
    }

    public static boolean isException(@NotNull String fqn, @NotNull PhpIndex index) {
        if (fqn == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(5);
        }
        if (index == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(6);
        }
        return !PhpType.isNull((String)fqn) && !PhpType.isPrimitiveType((String)fqn) && !PhpType.isResourceOrNumberType((String)fqn) && (fqn.endsWith("Exception") && !index.getAnyByFQN(fqn).isEmpty() || PhpType.findSuper((String)"\\Throwable", (String)fqn, (PhpIndex)index));
    }

    @NotNull
    public static Set<PhpType> getExceptionClasses(@NotNull PhpScopeHolder scopeHolder) {
        if (scopeHolder == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(7);
        }
        return PhpThrownExceptionsAnalyzer.getExceptionClasses(scopeHolder, null);
    }

    @NotNull
    public static Set<PhpType> getExceptionClasses(@NotNull PhpScopeHolder scopeHolder, @Nullable TextRange thrownRange) {
        if (scopeHolder == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(8);
        }
        Set set = ContainerUtil.map2Set(PhpThrownExceptionsAnalyzer.getExceptionClasses(scopeHolder, thrownRange, thrownRange, true, false), PhpExceptionAnalysisService.PhpThrownExceptionItem::getException);
        if (set == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(9);
        }
        return set;
    }

    @NotNull
    public static Set<PhpType> getExceptionClasses(@NotNull PhpScopeHolder scopeHolder, @Nullable TextRange thrownRange, boolean ignoreExceptions) {
        if (scopeHolder == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(10);
        }
        Set set = ContainerUtil.map2Set(PhpThrownExceptionsAnalyzer.getExceptionClasses(scopeHolder, thrownRange, thrownRange, ignoreExceptions, false), PhpExceptionAnalysisService.PhpThrownExceptionItem::getException);
        if (set == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(11);
        }
        return set;
    }

    @NotNull
    public static Set<PhpExceptionAnalysisService.PhpThrownExceptionItem> getExceptionClasses(@NotNull PhpScopeHolder scopeHolder, @Nullable TextRange thrownRange, @Nullable TextRange coughRange, boolean ignoreExceptions, boolean strictThrownRangeComparison) {
        if (scopeHolder == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(12);
        }
        return PhpThrownExceptionsAnalyzer.getExceptionClasses(scopeHolder, thrownRange, coughRange, ignoreExceptions, strictThrownRangeComparison, true);
    }

    @NotNull
    public static Set<PhpExceptionAnalysisService.PhpThrownExceptionItem> getExceptionClasses(@NotNull PhpScopeHolder scopeHolder, @Nullable TextRange thrownRange, @Nullable TextRange coughRange, boolean ignoreExceptions, boolean strictThrownRangeComparison, boolean excludeThrownInConstructorWithConstantParameters) {
        if (scopeHolder == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(13);
        }
        Set<PhpExceptionAnalysisService.PhpThrownExceptionItem> thrownExceptions = PhpExceptionAnalysisService.getThrownExceptions(scopeHolder, thrownRange, coughRange, strictThrownRangeComparison);
        if (excludeThrownInConstructorWithConstantParameters && PhpExceptionAnalysisService.getSkipConstantParams((PsiElement)scopeHolder)) {
            thrownExceptions = thrownExceptions.stream().filter(item -> !item.isThrownInConstructorWithConstantParameters()).collect(Collectors.toSet());
        }
        return PhpThrownExceptionsAnalyzer.getExceptionClasses(scopeHolder, ignoreExceptions, thrownExceptions);
    }

    @NotNull
    public static Set<PhpExceptionAnalysisService.PhpThrownExceptionItem> getExceptionClasses(@NotNull PhpScopeHolder scopeHolder, boolean ignoreExceptions, Set<PhpExceptionAnalysisService.PhpThrownExceptionItem> thrownExceptions) {
        if (scopeHolder == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(14);
        }
        HashSet<PhpExceptionAnalysisService.PhpThrownExceptionItem> results = new HashSet<PhpExceptionAnalysisService.PhpThrownExceptionItem>();
        Project project = scopeHolder.getProject();
        Set<String> uncheckedExceptions = PhpAnalysisConfiguration.getInstance(project).getUncheckedExceptions();
        PhpIndex index = PhpIndex.getInstance((Project)project);
        for (PhpExceptionAnalysisService.PhpThrownExceptionItem thrownException : thrownExceptions) {
            PhpExceptionAnalysisService.PhpThrownExceptionItem exception;
            for (String exception2 : PhpThrownExceptionsAnalyzer.filterNonThrowable(thrownException.getException(), project)) {
                if (ignoreExceptions && !uncheckedExceptions.stream().noneMatch(uncheckedException -> PhpType.findSuper((String)uncheckedException, (String)exception2, (PhpIndex)index))) continue;
                results.add(new PhpExceptionAnalysisService.PhpThrownExceptionItem(exception2, thrownException.getThrownRange()));
            }
            if (results.size() <= 1 || (exception = (PhpExceptionAnalysisService.PhpThrownExceptionItem)((Object)ContainerUtil.find(results, e -> e.getException().equals((Object)PhpType.EXCEPTION)))) == null) continue;
            results.remove((Object)exception);
        }
        HashSet<PhpExceptionAnalysisService.PhpThrownExceptionItem> hashSet = results;
        if (hashSet == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(15);
        }
        return hashSet;
    }

    public static Set<String> getDistinctExceptionNames(@NotNull PhpScopeHolder function, @NotNull Project project) {
        if (function == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(16);
        }
        if (project == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(17);
        }
        TreeSet<String> exceptionNames = new TreeSet<String>();
        for (PhpType rawType : PhpThrownExceptionsAnalyzer.getExceptionClasses(function)) {
            for (String typeName : rawType.getTypesSorted()) {
                PhpPsiElement nsScope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)function);
                String exceptionName = PhpDocUtil.getTypePresentation(project, new PhpType().add(typeName), nsScope);
                exceptionNames.add(exceptionName);
            }
        }
        return exceptionNames;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 9, 11, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 1: 
            case 4: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 9: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpThrownExceptionsAnalyzer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpThrownExceptionsAnalyzer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "filterNonThrowable";
                break;
            }
            case 9: 
            case 11: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "filterNonThrowable";
                break;
            }
            case 2: 
            case 9: 
            case 11: 
            case 15: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isException";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getExceptionClasses";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDistinctExceptionNames";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 9, 11, 15 -> new IllegalStateException(string);
        };
    }
}

