/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.google.common.collect.FluentIterable;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpCallableFunction;
import com.jetbrains.php.lang.psi.elements.PhpCallableMethod;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import java.util.Arrays;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpReplaceFirstClassCallableQuickFix
extends PsiUpdateModCommandQuickFix {
    static final LocalQuickFix INSTANCE = new PhpReplaceFirstClassCallableQuickFix();

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("intention.family.name.replace.with.closure.fromCallable", new Object[0]);
        if (string == null) {
            PhpReplaceFirstClassCallableQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement ellipsis, @NotNull ModPsiUpdater updater) {
        PhpCallableFunction callableFunction;
        if (project == null) {
            PhpReplaceFirstClassCallableQuickFix.$$$reportNull$$$0(1);
        }
        if (ellipsis == null) {
            PhpReplaceFirstClassCallableQuickFix.$$$reportNull$$$0(2);
        }
        if (updater == null) {
            PhpReplaceFirstClassCallableQuickFix.$$$reportNull$$$0(3);
        }
        if ((callableFunction = (PhpCallableFunction)ObjectUtils.tryCast((Object)ellipsis.getParent(), PhpCallableFunction.class)) == null) {
            return;
        }
        String callable = PhpReplaceFirstClassCallableQuickFix.extractCallable(callableFunction);
        if (callable == null) {
            return;
        }
        FunctionReference replacement = PhpPsiElementFactory.createPhpPsiFromText(project, FunctionReference.class, String.format("Closure::fromCallable(%s);", callable));
        callableFunction.replace((PsiElement)replacement);
    }

    @Nullable
    private static String extractCallable(@NotNull PhpCallableFunction callableFunction) {
        PsiElement firstChild;
        if (callableFunction == null) {
            PhpReplaceFirstClassCallableQuickFix.$$$reportNull$$$0(4);
        }
        if ((firstChild = callableFunction.getFirstChild()) instanceof ArrayCreationExpression) {
            return PhpReplaceFirstClassCallableQuickFix.extractCallableFromArrayCreation((ArrayCreationExpression)firstChild);
        }
        if (callableFunction instanceof PhpCallableMethod) {
            return PhpReplaceFirstClassCallableQuickFix.extractCallableFromMethod((PhpCallableMethod)callableFunction);
        }
        return PhpReplaceFirstClassCallableQuickFix.extractCallableFromFunction(callableFunction);
    }

    @Nullable
    private static String extractCallableFromMethod(@NotNull PhpCallableMethod callableMethod) {
        Object secondArg;
        PhpExpression classRef;
        if (callableMethod == null) {
            PhpReplaceFirstClassCallableQuickFix.$$$reportNull$$$0(5);
        }
        if ((classRef = callableMethod.getClassReference()) == null) {
            return null;
        }
        Object firstArg = classRef.getText();
        if (classRef instanceof ClassReference && callableMethod.isStatic()) {
            firstArg = (String)firstArg + "::class";
        }
        if (StringUtil.isEmpty((String)callableMethod.getName())) {
            Optional<PsiElement> expression = Arrays.stream(callableMethod.getChildren()).skip(1L).filter(c -> c instanceof PhpExpression).findFirst();
            if (expression.isEmpty()) {
                return null;
            }
            secondArg = expression.get().getText();
        } else {
            secondArg = "'" + callableMethod.getName() + "'";
        }
        return String.format("[%s, %s]", firstArg, secondArg);
    }

    @Nullable
    private static String extractCallableFromFunction(@NotNull PhpCallableFunction callableFunction) {
        if (callableFunction == null) {
            PhpReplaceFirstClassCallableQuickFix.$$$reportNull$$$0(6);
        }
        if (StringUtil.isNotEmpty((String)callableFunction.getName())) {
            return "'" + callableFunction.getName() + "'";
        }
        PsiElement firstChild = callableFunction.getFirstChild();
        if (firstChild instanceof ParenthesizedExpression) {
            firstChild = PhpPsiUtil.unparenthesize(firstChild);
        }
        if (firstChild instanceof PhpTypedElement) {
            return firstChild.getText();
        }
        return null;
    }

    @Nullable
    private static String extractCallableFromArrayCreation(@NotNull ArrayCreationExpression arrayCreationExpression) {
        FluentIterable elements;
        if (arrayCreationExpression == null) {
            PhpReplaceFirstClassCallableQuickFix.$$$reportNull$$$0(7);
        }
        if ((elements = ArrayCreationExpressionImpl.children(arrayCreationExpression).limit(3)).size() != 2) {
            return null;
        }
        return arrayCreationExpression.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpReplaceFirstClassCallableQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ellipsis";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callableFunction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callableMethod";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayCreationExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpReplaceFirstClassCallableQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extractCallable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractCallableFromMethod";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "extractCallableFromFunction";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "extractCallableFromArrayCreation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

