/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpImplicitOctalLiteralUsageInspection
extends PhpInspection {
    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP810;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpImplicitOctalLiteralUsageInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpExpression(PhpExpression expression) {
                PsiElement firstChild = expression.getFirstChild();
                if (PhpPsiUtil.isOfType(firstChild, PhpTokenTypes.OCTAL_INTEGER) && !StringUtil.startsWithIgnoreCase((String)firstChild.getText(), (String)"0o")) {
                    holder.registerProblem((PsiElement)expression, PhpBundle.message("inspection.family.name.replace.implicit.octal.literal.with.explicit.one", new Object[0]), new LocalQuickFix[]{PhpReplaceImplicitOctalLiteralWithExplicitOne.INSTANCE});
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpImplicitOctalLiteralUsageInspection", "buildVisitor"));
    }

    private static class PhpReplaceImplicitOctalLiteralWithExplicitOne
    extends PsiUpdateModCommandQuickFix {
        public static final PhpReplaceImplicitOctalLiteralWithExplicitOne INSTANCE = new PhpReplaceImplicitOctalLiteralWithExplicitOne();

        private PhpReplaceImplicitOctalLiteralWithExplicitOne() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("inspection.family.name.replace.implicit.octal.literal.with.explicit.one", new Object[0]);
            if (string == null) {
                PhpReplaceImplicitOctalLiteralWithExplicitOne.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpReplaceImplicitOctalLiteralWithExplicitOne.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplaceImplicitOctalLiteralWithExplicitOne.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceImplicitOctalLiteralWithExplicitOne.$$$reportNull$$$0(3);
            }
            if (!(element instanceof PhpExpression)) {
                return;
            }
            PhpExpression implicitOctalLiteral = (PhpExpression)element;
            PhpExpression explicitOctalLiteral = PhpPsiElementFactory.createFromText(project, PhpExpression.class, "0o" + implicitOctalLiteral.getText().substring(1));
            if (explicitOctalLiteral == null) {
                return;
            }
            implicitOctalLiteral.replace((PsiElement)explicitOctalLiteral);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpImplicitOctalLiteralUsageInspection$PhpReplaceImplicitOctalLiteralWithExplicitOne";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpImplicitOctalLiteralUsageInspection$PhpReplaceImplicitOctalLiteralWithExplicitOne";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

