/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.inspections.PhpHookedPropertyCantBeAccessedByRefInspectionKt;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeSmell.PhpParameterByRefIsNotUsedAsReferenceInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPropertyHook;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/jetbrains/php/lang/inspections/PhpHookedPropertyCantBeAccessedByRefInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isAllowedToAccessFieldByReference", "property", "Lcom/jetbrains/php/lang/psi/elements/Field;", "intellij.php.impl"})
@SourceDebugExtension(value={"SMAP\nPhpHookedPropertyCantBeAccessedByRefInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpHookedPropertyCantBeAccessedByRefInspection.kt\ncom/jetbrains/php/lang/inspections/PhpHookedPropertyCantBeAccessedByRefInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n1761#2,3:128\n1740#2,3:131\n1761#2,3:134\n*S KotlinDebug\n*F\n+ 1 PhpHookedPropertyCantBeAccessedByRefInspection.kt\ncom/jetbrains/php/lang/inspections/PhpHookedPropertyCantBeAccessedByRefInspection\n*L\n91#1:128,3\n92#1:131,3\n93#1:134,3\n*E\n"})
public final class PhpHookedPropertyCantBeAccessedByRefInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new PhpElementVisitor(holder, this){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ PhpHookedPropertyCantBeAccessedByRefInspection this$0;
            {
                this.$holder = $holder;
                this.this$0 = $receiver;
            }

            public void visitPhpField(Field field) {
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                this.checkField(field);
            }

            public void visitPhpParameter(Parameter parameter) {
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                if (!(parameter instanceof Field)) {
                    return;
                }
                this.checkField((Field)parameter);
            }

            private final void checkField(Field field) {
                if (field.isVirtualProperty()) {
                    return;
                }
                PhpPropertyHook phpPropertyHook = PhpHookedPropertyCantBeAccessedByRefInspectionKt.getGetHook(field);
                if (phpPropertyHook == null) {
                    return;
                }
                PhpPropertyHook getHook = phpPropertyHook;
                if (!getHook.isReturningByReference() || PhpHookedPropertyCantBeAccessedByRefInspectionKt.getSetHook(field) == null) {
                    return;
                }
                PsiElement psiElement = getHook.getFirstChild();
                if (psiElement == null) {
                    return;
                }
                PsiElement bitAndOp = psiElement;
                this.$holder.problem(bitAndOp, PhpBundle.message("inspection.php.get.hook.of.backed.property.with.set.hook.may.not.return.by.reference", new Object[0])).fix((ModCommandAction)new PhpDeleteElementQuickFix(bitAndOp)).register();
            }

            /*
             * WARNING - void declaration
             */
            public void visitPhpFieldReference(FieldReference fieldReference) {
                boolean bl;
                ProblemHighlightType severity;
                String message;
                block7: {
                    void $this$all$iv;
                    Intrinsics.checkNotNullParameter((Object)fieldReference, (String)"fieldReference");
                    PhpAccessFieldByVariableInstruction phpAccessFieldByVariableInstruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)fieldReference, PhpAccessFieldByVariableInstruction.class);
                    if (phpAccessFieldByVariableInstruction == null) {
                        return;
                    }
                    PhpAccessFieldByVariableInstruction instruction = phpAccessFieldByVariableInstruction;
                    PhpAccessInstruction.Access access = instruction.getAccess();
                    Intrinsics.checkNotNullExpressionValue((Object)access, (String)"getAccess(...)");
                    PhpAccessInstruction.Access access2 = access;
                    if (!((access2.isReadRef() || instruction.getAccess().isWriteRef() || Intrinsics.areEqual((Object)PhpAccessInstruction.Access.READ_REF_ACCESS, (Object)instruction.getAccess()) || PhpParameterByRefIsNotUsedAsReferenceInspection.isReturnedFromReturnByRefFunction((PsiElement)fieldReference) || PhpHookedPropertyCantBeAccessedByRefInspectionKt.isArrayWriteAccess(fieldReference)) && PhpPsiUtil.getParentByCondition((PsiElement)fieldReference, (Condition<? super PsiElement>)PhpPropertyHook.INSTANCEOF, (Condition<? super PsiElement>)Field.INSTANCEOF) == null)) {
                        return;
                    }
                    Collection properties = fieldReference.multiResolveStrict(Field.class);
                    message = null;
                    String string = PhpBundle.message("inspection.php.indirect.modification.on.property.potential", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    message = string;
                    severity = null;
                    severity = ProblemHighlightType.WEAK_WARNING;
                    Intrinsics.checkNotNull((Object)properties);
                    Iterable $this$forEach$iv = properties;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Field it = (Field)element$iv;
                        boolean bl2 = false;
                        if (it.isAbstract()) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)PhpBundle.message("inspection.php.indirect.modification.on.property.is.not.allowed", new Object[0]), (String)"message(...)");
                        severity = ProblemHighlightType.ERROR;
                    }
                    $this$forEach$iv = properties;
                    PhpHookedPropertyCantBeAccessedByRefInspection phpHookedPropertyCantBeAccessedByRefInspection = this.this$0;
                    boolean $i$f$all = false;
                    if (((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $this$all$iv) {
                            Field it = (Field)element$iv;
                            boolean bl3 = false;
                            Intrinsics.checkNotNull((Object)it);
                            if (PhpHookedPropertyCantBeAccessedByRefInspection.access$isAllowedToAccessFieldByReference(phpHookedPropertyCantBeAccessedByRefInspection, it)) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    return;
                }
                this.$holder.problem((PsiElement)fieldReference, message).highlight(severity).register();
            }
        };
    }

    private final boolean isAllowedToAccessFieldByReference(Field property) {
        PhpPropertyHook setHook;
        PhpPropertyHook getHook;
        block23: {
            String it;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block22: {
                boolean bl;
                block20: {
                    boolean bl2;
                    block19: {
                        getHook = PhpHookedPropertyCantBeAccessedByRefInspectionKt.getGetHook(property);
                        setHook = PhpHookedPropertyCantBeAccessedByRefInspectionKt.getSetHook(property);
                        if (getHook == null && setHook == null) {
                            return true;
                        }
                        if (property.isAbstract()) {
                            Ref isAllowedToAccessFieldByReference2 = new Ref((Object)true);
                            PhpClassHierarchyUtils.processOverridingFields((Field)property, (PhpClassHierarchyUtils.TypedHierarchyMemberProcessor)new PhpClassHierarchyUtils.TypedHierarchyMemberProcessor((Ref<Boolean>)isAllowedToAccessFieldByReference2, this){
                                final /* synthetic */ Ref<Boolean> $isAllowedToAccessFieldByReference;
                                final /* synthetic */ PhpHookedPropertyCantBeAccessedByRefInspection this$0;
                                {
                                    this.$isAllowedToAccessFieldByReference = $isAllowedToAccessFieldByReference;
                                    this.this$0 = $receiver;
                                }

                                public final boolean process(Field field, PhpClass superClass, PhpClass baseClass) {
                                    if (field.isAbstract()) {
                                        return true;
                                    }
                                    Intrinsics.checkNotNull((Object)field);
                                    this.$isAllowedToAccessFieldByReference.set((Object)PhpHookedPropertyCantBeAccessedByRefInspection.access$isAllowedToAccessFieldByReference(this.this$0, field));
                                    return true;
                                }
                            });
                            Object object = isAllowedToAccessFieldByReference2.get();
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                            return (Boolean)object;
                        }
                        Set set = property.getDeclaredType().getTypes();
                        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getTypes(...)");
                        $this$any$iv = set;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (String)element$iv;
                                boolean bl3 = false;
                                if (!(!PhpType.isPrimitiveType((String)it))) continue;
                                bl2 = true;
                                break block19;
                            }
                            bl2 = false;
                        }
                    }
                    if (bl2) {
                        return true;
                    }
                    if (property.getDeclaredType().isAmbiguous()) break block22;
                    Set set = property.getDeclaredType().getTypes();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getTypes(...)");
                    Iterable $this$all$iv = set;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it = (String)element$iv;
                            boolean bl4 = false;
                            if (PhpType.isPrimitiveType((String)it)) continue;
                            bl = false;
                            break block20;
                        }
                        bl = true;
                    }
                }
                if (bl) break block23;
            }
            if (getHook != null) {
                boolean bl;
                block21: {
                    Set set = getHook.getGlobalType().getTypes();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getTypes(...)");
                    $this$any$iv = set;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (String)element$iv;
                            boolean bl5 = false;
                            if (!(!PhpType.isPrimitiveType((String)it))) continue;
                            bl = true;
                            break block21;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return true;
                }
            }
        }
        if (getHook != null && setHook != null) {
            if (property.isVirtualProperty()) {
                return getHook.isReturningByReference();
            }
            return false;
        }
        PhpPropertyHook phpPropertyHook = getHook;
        if (phpPropertyHook != null) {
            return phpPropertyHook.isReturningByReference();
        }
        return false;
    }

    public static final /* synthetic */ boolean access$isAllowedToAccessFieldByReference(PhpHookedPropertyCantBeAccessedByRefInspection $this, Field property) {
        return $this.isAllowedToAccessFieldByReference(property);
    }
}

