/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpDeprecatedPassingNonEmptyEscapeToCsvFunctionInspectionKt;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.impl.StringLiteralExpressionImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lcom/jetbrains/php/lang/inspections/PhpDeprecatedPassingNonEmptyEscapeToCsvFunctionInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getMinimumSupportedLanguageLevel", "Lcom/jetbrains/php/config/PhpLanguageLevel;", "intellij.php.impl"})
public final class PhpDeprecatedPassingNonEmptyEscapeToCsvFunctionInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new PhpElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitPhpMethodReference(MethodReference reference) {
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                PhpExpression phpExpression = reference.getClassReference();
                if (phpExpression == null) {
                    return;
                }
                PhpExpression classRef = phpExpression;
                if (!classRef.getGlobalType().getTypes().contains("\\SplFileObject")) {
                    return;
                }
                String name = "SplFileObject." + reference.getName();
                this.doCheckReference(name, (FunctionReference)reference);
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                String string = reference.getName();
                if (string == null) {
                    return;
                }
                String name = string;
                this.doCheckReference(name, reference);
            }

            private final void doCheckReference(String name, FunctionReference reference) {
                Integer n = (Integer)PhpDeprecatedPassingNonEmptyEscapeToCsvFunctionInspectionKt.access$getCSV_FUNCTIONS$p().get(name);
                if (n == null) {
                    return;
                }
                int paramIndex = n;
                PsiElement psiElement = reference.getParameter("escape", paramIndex);
                if (psiElement == null) {
                    return;
                }
                PsiElement param = psiElement;
                if (!(param instanceof StringLiteralExpressionImpl)) {
                    return;
                }
                String string = ((StringLiteralExpressionImpl)param).getContents();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getContents(...)");
                if (((CharSequence)string).length() == 0) {
                    return;
                }
                Collection collection = reference.multiResolveStrict(Function.class);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"multiResolveStrict(...)");
                Function function = (Function)CollectionsKt.firstOrNull((Iterable)collection);
                if (function == null) {
                    return;
                }
                Function function2 = function;
                Map map = PhpDeprecatedPassingNonEmptyEscapeToCsvFunctionInspectionKt.access$getCSV_FUNCTIONS$p();
                String string2 = function2.getFQN();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFQN(...)");
                char[] cArray = new char[]{'\\'};
                if (!map.containsKey(StringsKt.trimStart((String)string2, (char[])cArray))) {
                    return;
                }
                this.$holder.registerProblem(param, PhpBundle.message("inspection.php.passing.non.empty.enclosure.to.csv.function.is.deprecated", new Object[0]), new LocalQuickFix[0]);
            }
        };
    }

    @Override
    @NotNull
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP840;
    }
}

