/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.annotator.PhpDumbAwareAnnotatorVisitor;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDeprecatedCastInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpDeprecatedCastInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpUnaryExpression(UnaryExpression expr) {
                PsiElement operation = expr.getOperation();
                if (PhpPsiUtil.isOfType(operation, PhpTokenTypes.opUNSET_CAST)) {
                    PhpDeprecatedCastInspection.checkCastExpressionDeprecation(holder, operation, PhpLanguageLevel.PHP720, new LocalQuickFix[0]);
                } else if (PhpDeprecatedCastInspection.isRealCast(operation)) {
                    PhpDeprecatedCastInspection.checkCastExpressionDeprecation(holder, operation, PhpLanguageLevel.PHP740, PhpReplaceWithFloatCastQuickFix.INSTANCE);
                }
            }
        };
    }

    private static void checkCastExpressionDeprecation(@NotNull ProblemsHolder holder, @NotNull PsiElement operation, @NotNull PhpLanguageLevel levelStartingFromCastIsDeprecated, LocalQuickFix ... fixes) {
        PhpLanguageLevel currentLanguageLevel;
        if (holder == null) {
            PhpDeprecatedCastInspection.$$$reportNull$$$0(1);
        }
        if (operation == null) {
            PhpDeprecatedCastInspection.$$$reportNull$$$0(2);
        }
        if (levelStartingFromCastIsDeprecated == null) {
            PhpDeprecatedCastInspection.$$$reportNull$$$0(3);
        }
        if (fixes == null) {
            PhpDeprecatedCastInspection.$$$reportNull$$$0(4);
        }
        if ((currentLanguageLevel = PhpProjectConfigurationFacade.getInstance(operation.getProject()).getLanguageLevel()).isAtLeast(levelStartingFromCastIsDeprecated)) {
            holder.registerProblem(operation, PhpBundle.message("inspection.deprecated.cast", operation.getText(), levelStartingFromCastIsDeprecated.getPresentableName()), ProblemHighlightType.LIKE_DEPRECATED, fixes);
        }
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP720;
    }

    @Contract(value="null -> false")
    private static boolean isRealCast(PsiElement operation) {
        if (!PhpPsiUtil.isOfType(operation, PhpTokenTypes.opFLOAT_CAST)) {
            return false;
        }
        TextRange range = PhpDumbAwareAnnotatorVisitor.getCastKeywordRange(operation);
        if (range == null) {
            return false;
        }
        return range.substring(operation.getText()).equalsIgnoreCase("real");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "levelStartingFromCastIsDeprecated";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDeprecatedCastInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCastExpressionDeprecation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpReplaceWithFloatCastQuickFix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        static final LocalQuickFix INSTANCE = new PhpReplaceWithFloatCastQuickFix();

        private PhpReplaceWithFloatCastQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.replace.with.float.cast.quick.fix.family.name", new Object[0]);
            if (string == null) {
                PhpReplaceWithFloatCastQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            UnaryExpression realCast;
            if (project == null) {
                PhpReplaceWithFloatCastQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplaceWithFloatCastQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceWithFloatCastQuickFix.$$$reportNull$$$0(3);
            }
            if ((realCast = (UnaryExpression)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)((Condition)e -> e instanceof UnaryExpression && PhpDeprecatedCastInspection.isRealCast(((UnaryExpression)e).getOperation())), (Condition<? super PsiElement>)Statement.INSTANCEOF)) == null) {
                return;
            }
            PhpPsiElement value = realCast.getValue();
            if (value == null) {
                return;
            }
            realCast.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(project, UnaryExpression.class, "(float)" + value.getText()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpDeprecatedCastInspection$PhpReplaceWithFloatCastQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDeprecatedCastInspection$PhpReplaceWithFloatCastQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

