/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDeprecatedAutoloadDeclarationInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpDeprecatedAutoloadDeclarationInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpFunction(Function function) {
                String message;
                PsiElement nameIdentifier = function.getNameIdentifier();
                if (nameIdentifier == null || !"__autoload".equalsIgnoreCase(function.getName())) {
                    return;
                }
                String string = message = PhpLanguageLevel.current((Project)function.getProject()).isAtLeast(PhpLanguageLevel.PHP800) ? PhpBundle.message("inspection.message.prohibited.autoload.declaration", new Object[0]) : PhpBundle.message("inspection.message.deprecated.autoload.declaration", new Object[0]);
                if (function.getParameters().length == 1) {
                    holder.registerProblem(nameIdentifier, message, new LocalQuickFix[]{PhpReplaceWithSplAutoloadRegisterCallQuickFix.REPLACE_WITH_SPL_AUTOLOAD_CALL_FIX});
                } else {
                    holder.registerProblem(nameIdentifier, message, new LocalQuickFix[0]);
                }
            }
        };
    }

    @Override
    @Nullable
    protected ProblemHighlightType getPhp8CustomSeverity() {
        return ProblemHighlightType.ERROR;
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP720;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpDeprecatedAutoloadDeclarationInspection", "buildVisitor"));
    }

    private static class PhpReplaceWithSplAutoloadRegisterCallQuickFix
    extends PsiUpdateModCommandQuickFix {
        private static final LocalQuickFix REPLACE_WITH_SPL_AUTOLOAD_CALL_FIX = new PhpReplaceWithSplAutoloadRegisterCallQuickFix();

        private PhpReplaceWithSplAutoloadRegisterCallQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.spl.autoload.register.call", new Object[0]);
            if (string == null) {
                PhpReplaceWithSplAutoloadRegisterCallQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            Function function;
            if (project == null) {
                PhpReplaceWithSplAutoloadRegisterCallQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplaceWithSplAutoloadRegisterCallQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceWithSplAutoloadRegisterCallQuickFix.$$$reportNull$$$0(3);
            }
            if ((function = (Function)ObjectUtils.tryCast((Object)element.getParent(), Function.class)) == null) {
                return;
            }
            Parameter parameter = function.getParameter(0);
            if (parameter == null) {
                return;
            }
            Object body = PhpPsiUtil.getChildByCondition((PsiElement)function, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
            if (body == null) {
                return;
            }
            String autoloadCallback = String.format("function (%s) %s", parameter.getText(), body.getText());
            function.replace((PsiElement)PhpPsiElementFactory.createStatement(project, "spl_autoload_register(" + autoloadCallback + ");"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpDeprecatedAutoloadDeclarationInspection$PhpReplaceWithSplAutoloadRegisterCallQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDeprecatedAutoloadDeclarationInspection$PhpReplaceWithSplAutoloadRegisterCallQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

