/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.impl.PhpDefineImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpDefineConstantNameStartsWithLeadingSlashInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpDefineConstantNameStartsWithLeadingSlashInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpConstant(Constant constant) {
                if (constant instanceof PhpDefineImpl) {
                    String content;
                    int leadingSlashLength;
                    PsiElement firstPart;
                    PsiElement element = (PsiElement)ArrayUtil.getFirstElement((Object[])((PhpDefineImpl)constant).getParameters());
                    PsiElement psiElement = firstPart = element != null ? (PsiElement)ContainerUtil.getFirstItem(PhpDefineImpl.collectOperands(element)) : null;
                    if (firstPart instanceof StringLiteralExpression && (leadingSlashLength = PhpDefineConstantNameStartsWithLeadingSlashInspection.getLeadingSlashRangeLength(content = ((StringLiteralExpression)firstPart).getContents())) > 0) {
                        TextRange range = ((StringLiteralExpression)firstPart).getValueRange();
                        holder.registerProblem(firstPart, TextRange.create((int)range.getStartOffset(), (int)(range.getStartOffset() + leadingSlashLength)), PhpBundle.message("inspection.message.leading.slash.in.constant.fqn.will.not.be.trimmed.by.php", new Object[0]), new LocalQuickFix[]{PhpRemoveLeadingSlashQuickFix.INSTANCE});
                    }
                }
            }
        };
    }

    private static int getLeadingSlashRangeLength(String c) {
        int i = 0;
        if (!c.isEmpty() && c.charAt(0) == '\\') {
            ++i;
            if (c.length() > 1 && c.charAt(1) == '\\') {
                ++i;
            }
        }
        return i;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpDefineConstantNameStartsWithLeadingSlashInspection", "buildVisitor"));
    }

    private static class PhpRemoveLeadingSlashQuickFix
    extends PsiUpdateModCommandQuickFix {
        static final LocalQuickFix INSTANCE = new PhpRemoveLeadingSlashQuickFix();

        private PhpRemoveLeadingSlashQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.remove.leading", new Object[0]);
            if (string == null) {
                PhpRemoveLeadingSlashQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpRemoveLeadingSlashQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpRemoveLeadingSlashQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpRemoveLeadingSlashQuickFix.$$$reportNull$$$0(3);
            }
            StringLiteralExpression string = (StringLiteralExpression)element;
            String content = string.getContents();
            string.replace((PsiElement)PhpPsiElementFactory.createStringLiteralExpression(project, content.substring(PhpDefineConstantNameStartsWithLeadingSlashInspection.getLeadingSlashRangeLength(content)), string.isSingleQuote()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpDefineConstantNameStartsWithLeadingSlashInspection$PhpRemoveLeadingSlashQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDefineConstantNameStartsWithLeadingSlashInspection$PhpRemoveLeadingSlashQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

