/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpHookedPropertyCantBeAccessedByRefInspectionKt;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.attributes.PhpImmutablePropertyIsWrittenInspection;
import com.jetbrains.php.lang.inspections.codeSmell.PhpParameterByRefIsNotUsedAsReferenceInspection;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0014\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/php/lang/inspections/PhpCannotModifyPropertyOutsideSetVisibilityScopeInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "indirectModification", "fieldReference", "Lcom/jetbrains/php/lang/psi/elements/FieldReference;", "isNonObjectType", "type", "", "getMinimumSupportedLanguageLevel", "Lcom/jetbrains/php/config/PhpLanguageLevel;", "intellij.php.impl"})
public final class PhpCannotModifyPropertyOutsideSetVisibilityScopeInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new PhpElementVisitor(this, holder){
            final /* synthetic */ PhpCannotModifyPropertyOutsideSetVisibilityScopeInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            /*
             * WARNING - void declaration
             */
            public void visitPhpFieldReference(FieldReference fieldReference) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)fieldReference, (String)"fieldReference");
                PsiElement parent = fieldReference.getParent();
                if (!(fieldReference.isWriteAccess() || parent instanceof PhpUnset || PhpCannotModifyPropertyOutsideSetVisibilityScopeInspection.access$indirectModification(this.this$0, fieldReference))) {
                    return;
                }
                Collection collection = fieldReference.multiResolveStrict(Field.class);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"multiResolveStrict(...)");
                Iterable iterable = collection;
                PhpCannotModifyPropertyOutsideSetVisibilityScopeInspection phpCannotModifyPropertyOutsideSetVisibilityScopeInspection = this.this$0;
                ProblemsHolder problemsHolder = this.$holder;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String string;
                    PhpImmutablePropertyIsWrittenInspection.PropertyWriteScope propertyScope;
                    Field it = (Field)element$iv;
                    boolean bl = false;
                    PhpModifier.Access setAccess = it.getModifier().getSetAccess();
                    if (setAccess == null || setAccess.isPublic() || !PhpImmutablePropertyIsWrittenInspection.writeAccessIsNotAllowed(fieldReference, propertyScope = setAccess.isProtected() ? PhpImmutablePropertyIsWrittenInspection.PropertyWriteScope.PROTECTED : PhpImmutablePropertyIsWrittenInspection.PropertyWriteScope.PRIVATE, it)) continue;
                    if (parent instanceof PhpUnset) {
                        var13_13 = new Object[]{setAccess + "(set)"};
                        string = PhpBundle.message("inspection.cannot.unset.property.outside.of.scope", var13_13);
                    } else if (PhpCannotModifyPropertyOutsideSetVisibilityScopeInspection.access$indirectModification(phpCannotModifyPropertyOutsideSetVisibilityScopeInspection, fieldReference)) {
                        var13_13 = new Object[]{setAccess + "(set)"};
                        string = PhpBundle.message("inspection.cannot.indirectly.modify.property.outside.of.scope", var13_13);
                    } else {
                        var13_13 = new Object[]{setAccess + "(set)"};
                        string = PhpBundle.message("inspection.cannot.modify.property.outside.of.scope", var13_13);
                    }
                    String string2 = string;
                    Intrinsics.checkNotNull((Object)string2);
                    String message = string2;
                    problemsHolder.registerProblem((PsiElement)fieldReference, message, new LocalQuickFix[0]);
                }
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean indirectModification(FieldReference fieldReference) {
        PsiElement parent = fieldReference.getParent();
        if (PhpHookedPropertyCantBeAccessedByRefInspectionKt.isArrayWriteAccess(fieldReference)) return true;
        if (PhpParameterByRefIsNotUsedAsReferenceInspection.isReturnedFromReturnByRefFunction((PsiElement)fieldReference)) return true;
        if (parent instanceof AssignmentExpression && PhpWorkaroundUtil.isAssignByReference((AssignmentExpression)parent)) {
            String string = fieldReference.getGlobalType().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            if (this.isNonObjectType(string)) return true;
        }
        if (!PhpCodeInsightUtil.isPassByRefParameter((PsiElement)fieldReference, true)) return false;
        return true;
    }

    private final boolean isNonObjectType(String type) {
        return PhpType.isNotExtendablePrimitiveType((String)type) || PhpType.isArray((String)type) || PhpType.isPluralType((String)type);
    }

    @Override
    @NotNull
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP840;
    }

    public static final /* synthetic */ boolean access$indirectModification(PhpCannotModifyPropertyOutsideSetVisibilityScopeInspection $this, FieldReference fieldReference) {
        return $this.indirectModification(fieldReference);
    }
}

