/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter.ui.predefinedStyle;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.formatter.PhpPredefinedCodeStyleBase;

public class PearCodeStyle
extends PhpPredefinedCodeStyleBase {
    @NlsSafe
    private static final String PEAR = "PEAR";

    public PearCodeStyle() {
        super(PEAR);
    }

    protected PearCodeStyle(@NlsContexts.ListItem String name) {
        super(name);
    }

    public void apply(CodeStyleSettings settings) {
        super.apply(settings);
        CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions((FileType)PhpFileType.INSTANCE);
        indentOptions.INDENT_SIZE = 4;
        indentOptions.CONTINUATION_INDENT_SIZE = 4;
        indentOptions.USE_TAB_CHARACTER = false;
        indentOptions.TAB_SIZE = 4;
        PhpCodeStyleSettings phpSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
        phpSettings.INDENT_CODE_IN_PHP_TAGS = false;
        phpSettings.ALIGN_PHPDOC_PARAM_NAMES = true;
        phpSettings.ALIGN_PHPDOC_COMMENTS = true;
        phpSettings.PHPDOC_BLANK_LINE_BEFORE_TAGS = true;
        phpSettings.PHPDOC_BLANK_LINES_AROUND_PARAMETERS = true;
        phpSettings.LOWER_CASE_BOOLEAN_CONST = true;
        phpSettings.UPPER_CASE_BOOLEAN_CONST = false;
        phpSettings.LOWER_CASE_NULL_CONST = true;
        phpSettings.UPPER_CASE_NULL_CONST = false;
        phpSettings.IF_LPAREN_ON_NEXT_LINE = false;
        phpSettings.IF_RPAREN_ON_NEXT_LINE = true;
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings(this.getLanguage());
        commonSettings.RIGHT_MARGIN = 80;
        commonSettings.BRACE_STYLE = 1;
        commonSettings.CLASS_BRACE_STYLE = 2;
        commonSettings.METHOD_BRACE_STYLE = 2;
        commonSettings.DO_NOT_INDENT_TOP_LEVEL_CLASS_MEMBERS = false;
        commonSettings.ELSE_ON_NEW_LINE = false;
        commonSettings.WHILE_ON_NEW_LINE = false;
        commonSettings.CATCH_ON_NEW_LINE = false;
        commonSettings.INDENT_CASE_FROM_SWITCH = false;
        commonSettings.ALIGN_MULTILINE_CHAINED_METHODS = false;
        commonSettings.ALIGN_MULTILINE_PARAMETERS = false;
        commonSettings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS = false;
        commonSettings.ALIGN_MULTILINE_FOR = false;
        commonSettings.ALIGN_MULTILINE_BINARY_OPERATION = false;
        commonSettings.ALIGN_MULTILINE_ASSIGNMENT = false;
        commonSettings.ALIGN_MULTILINE_TERNARY_OPERATION = false;
        commonSettings.ALIGN_MULTILINE_THROWS_LIST = false;
        commonSettings.ALIGN_THROWS_KEYWORD = false;
        commonSettings.ALIGN_MULTILINE_EXTENDS_LIST = false;
        commonSettings.ALIGN_MULTILINE_METHOD_BRACKETS = false;
        commonSettings.ALIGN_MULTILINE_PARENTHESIZED_EXPRESSION = false;
        commonSettings.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION = false;
        commonSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS = true;
        commonSettings.SPACE_AROUND_LOGICAL_OPERATORS = true;
        commonSettings.SPACE_AROUND_EQUALITY_OPERATORS = true;
        commonSettings.SPACE_AROUND_RELATIONAL_OPERATORS = true;
        commonSettings.SPACE_AROUND_BITWISE_OPERATORS = true;
        commonSettings.SPACE_AROUND_ADDITIVE_OPERATORS = true;
        commonSettings.SPACE_AROUND_MULTIPLICATIVE_OPERATORS = true;
        commonSettings.SPACE_AROUND_SHIFT_OPERATORS = true;
        commonSettings.SPACE_AROUND_UNARY_OPERATOR = false;
        commonSettings.SPACE_AFTER_COMMA = true;
        commonSettings.SPACE_AFTER_COMMA_IN_TYPE_ARGUMENTS = true;
        commonSettings.SPACE_BEFORE_COMMA = false;
        commonSettings.SPACE_AFTER_SEMICOLON = true;
        commonSettings.SPACE_BEFORE_SEMICOLON = false;
        commonSettings.SPACE_WITHIN_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_METHOD_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_IF_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_WHILE_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_FOR_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_TRY_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_CATCH_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_SWITCH_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_CAST_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_BRACKETS = false;
        commonSettings.SPACE_WITHIN_BRACES = false;
        commonSettings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES = false;
        commonSettings.SPACE_AFTER_TYPE_CAST = false;
        commonSettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES = false;
        commonSettings.SPACE_BEFORE_METHOD_PARENTHESES = false;
        commonSettings.SPACE_BEFORE_IF_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_WHILE_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_FOR_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_TRY_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_CATCH_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_SWITCH_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_CLASS_LBRACE = true;
        commonSettings.SPACE_BEFORE_METHOD_LBRACE = true;
        commonSettings.SPACE_BEFORE_IF_LBRACE = true;
        commonSettings.SPACE_BEFORE_ELSE_LBRACE = true;
        commonSettings.SPACE_BEFORE_WHILE_LBRACE = true;
        commonSettings.SPACE_BEFORE_FOR_LBRACE = true;
        commonSettings.SPACE_BEFORE_DO_LBRACE = true;
        commonSettings.SPACE_BEFORE_SWITCH_LBRACE = true;
        commonSettings.SPACE_BEFORE_TRY_LBRACE = true;
        commonSettings.SPACE_BEFORE_CATCH_LBRACE = true;
        commonSettings.SPACE_BEFORE_FINALLY_LBRACE = true;
        commonSettings.SPACE_BEFORE_ARRAY_INITIALIZER_LBRACE = false;
        commonSettings.SPACE_BEFORE_ELSE_KEYWORD = true;
        commonSettings.SPACE_BEFORE_WHILE_KEYWORD = true;
        commonSettings.SPACE_BEFORE_CATCH_KEYWORD = true;
        commonSettings.SPACE_BEFORE_FINALLY_KEYWORD = true;
        commonSettings.SPACE_BEFORE_QUEST = true;
        commonSettings.SPACE_AFTER_QUEST = true;
        commonSettings.SPACE_BEFORE_COLON = true;
        commonSettings.SPACE_AFTER_COLON = true;
        commonSettings.SPACE_BEFORE_TYPE_PARAMETER_LIST = false;
        commonSettings.CALL_PARAMETERS_WRAP = 1;
        commonSettings.PREFER_PARAMETERS_WRAP = true;
        commonSettings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE = true;
        commonSettings.CALL_PARAMETERS_RPAREN_ON_NEXT_LINE = true;
        commonSettings.METHOD_PARAMETERS_WRAP = 1;
        commonSettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE = true;
        commonSettings.METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE = true;
        commonSettings.EXTENDS_LIST_WRAP = 1;
        commonSettings.THROWS_LIST_WRAP = 1;
        commonSettings.EXTENDS_KEYWORD_WRAP = 0;
        commonSettings.THROWS_KEYWORD_WRAP = 0;
        commonSettings.METHOD_CALL_CHAIN_WRAP = 1;
        commonSettings.PARENTHESES_EXPRESSION_LPAREN_WRAP = false;
        commonSettings.PARENTHESES_EXPRESSION_RPAREN_WRAP = false;
        commonSettings.BINARY_OPERATION_WRAP = 1;
        commonSettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE = true;
        commonSettings.TERNARY_OPERATION_WRAP = 1;
        commonSettings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE = true;
        commonSettings.MODIFIER_LIST_WRAP = false;
        commonSettings.FOR_STATEMENT_WRAP = 1;
        commonSettings.FOR_STATEMENT_LPAREN_ON_NEXT_LINE = true;
        commonSettings.FOR_STATEMENT_RPAREN_ON_NEXT_LINE = true;
        commonSettings.ARRAY_INITIALIZER_WRAP = 1;
        commonSettings.ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE = true;
        commonSettings.ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE = true;
        commonSettings.ASSIGNMENT_WRAP = 1;
        commonSettings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE = true;
        commonSettings.WRAP_COMMENTS = true;
        commonSettings.WRAP_LONG_LINES = false;
        commonSettings.IF_BRACE_FORCE = 3;
        commonSettings.WHILE_BRACE_FORCE = 3;
        commonSettings.FOR_BRACE_FORCE = 3;
        commonSettings.DOWHILE_BRACE_FORCE = 3;
    }
}

