/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation.phpdoc;

import com.intellij.lang.Language;
import com.intellij.lang.documentation.QuickDocHighlightingHelper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.text.CharSequenceSubSequence;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.text.StringsKt;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDocCodeUtil {
    private static final String HTML_CODE_START = "<code>";
    private static final String HTML_CODE_END = "</code>";
    private static final String HTML_PRE_START = "<pre>";
    private static final String HTML_PRE_END = "</pre>";
    private static final String FENCED_CODE_BLOCK = "```";
    private static final String INLINE_CODE_BLOCK = "``";

    private static boolean codeStarted(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        String text = element.getText();
        if (text.equals(INLINE_CODE_BLOCK) || text.equals(FENCED_CODE_BLOCK)) {
            return true;
        }
        if (!PhpPsiUtil.isOfType(element, PhpDocTokenTypes.DOC_HTML_TAG)) {
            return false;
        }
        return text.equals(HTML_CODE_START) || text.equals(HTML_PRE_START);
    }

    private static boolean codeEnded(@Nullable PsiElement element) {
        if (element == null || element instanceof PhpDocTag) {
            return true;
        }
        String text = element.getText();
        if (text.equals(INLINE_CODE_BLOCK) || text.equals(FENCED_CODE_BLOCK)) {
            return true;
        }
        if (!PhpPsiUtil.isOfType(element, PhpDocTokenTypes.DOC_HTML_TAG)) {
            return false;
        }
        return text.equals(HTML_CODE_END) || text.equals(HTML_PRE_END);
    }

    @Nullable
    public static PsiElement getNextSiblingAfterCodeSection(@NotNull PsiElement element, @NotNull StringBuilder buffer) {
        if (element == null) {
            PhpDocCodeUtil.$$$reportNull$$$0(0);
        }
        if (buffer == null) {
            PhpDocCodeUtil.$$$reportNull$$$0(1);
        }
        if (!PhpDocCodeUtil.codeStarted(element)) {
            return element;
        }
        StringBuilder codeBuffer = new StringBuilder();
        Project project = element.getProject();
        element = element.getNextSibling();
        while (!PhpDocCodeUtil.codeEnded(element)) {
            if (!PhpPsiUtil.isOfType(element, PhpDocTokenTypes.DOC_LEADING_ASTERISK)) {
                codeBuffer.append(element.getText());
            }
            element = element.getNextSibling();
        }
        String code = codeBuffer.toString();
        PhpDocCodeUtil.appendCodeSnippet(code, buffer, project, false);
        return element != null ? element.getNextSibling() : null;
    }

    public static void appendCodeSnippet(@NotNull String codeSnippet, @NotNull StringBuilder buffer, @NotNull Project project, boolean forceBlock) {
        if (codeSnippet == null) {
            PhpDocCodeUtil.$$$reportNull$$$0(2);
        }
        if (buffer == null) {
            PhpDocCodeUtil.$$$reportNull$$$0(3);
        }
        if (project == null) {
            PhpDocCodeUtil.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmpty((String)codeSnippet)) {
            return;
        }
        boolean isBlock = codeSnippet.startsWith("\n") || forceBlock;
        if (StringUtil.isEmpty((String)(codeSnippet = PhpDocCodeUtil.trimCommonIndent(codeSnippet)))) {
            return;
        }
        if (isBlock) {
            String indentation = PhpDocCodeUtil.getIndentation(buffer);
            buffer.append("\n").append(StringsKt.prependIndent((String)("```php\n" + codeSnippet + "\n```\n"), (String)indentation));
        } else {
            buffer.append(QuickDocHighlightingHelper.getStyledInlineCode((Project)project, (Language)PhpLanguage.INSTANCE, (String)codeSnippet));
        }
    }

    private static String trimCommonIndent(@NotNull String text) {
        List lines;
        int minIndent;
        if (text == null) {
            PhpDocCodeUtil.$$$reportNull$$$0(5);
        }
        if ((minIndent = ((StreamEx)StreamEx.of((Collection)(lines = (List)((StreamEx)StreamEx.of((Object[])text.split("\n")).filter(StringUtil::isNotEmpty)).collect(Collectors.toList()))).map(line -> StringUtil.skipWhitespaceForward((CharSequence)line, (int)0)).sorted()).findFirst().orElse(-1).intValue()) == -1) {
            return text;
        }
        return (String)StreamEx.of((Collection)lines).map(s -> s.substring(minIndent)).collect(Collectors.joining("\n"));
    }

    @NotNull
    public static String getIndentation(@NotNull StringBuilder builder2) {
        if (builder2 == null) {
            PhpDocCodeUtil.$$$reportNull$$$0(6);
        }
        int lastNewLineStart = StringsKt.lastIndexOf((CharSequence)builder2, (char)'\n', (int)(builder2.length() - 1), (boolean)false) + 1;
        String string = StringsKt.takeWhile((CharSequence)new CharSequenceSubSequence((CharSequence)builder2, lastNewLineStart, builder2.length()), ch -> Character.isWhitespace(ch.charValue())).toString();
        if (string == null) {
            PhpDocCodeUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeSnippet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/documentation/phpdoc/PhpDocCodeUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/documentation/phpdoc/PhpDocCodeUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNextSiblingAfterCodeSection";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendCodeSnippet";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "trimCommonIndent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIndentation";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

