/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocElementType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpLanguageLevelInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpEnumCase;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.impl.PhpExpressionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionScalarArgument;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpCodeValidationUtil {
    private static final TokenSet CONSTANT_SCALARS_ONLY = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{PhpElementTypes.NS_REFERENCE, PhpElementTypes.CONSTANT_REF, PhpElementTypes.CLASS_REFERENCE, PhpElementTypes.CLASS_CONSTANT_REFERENCE, PhpElementTypes.NEW_EXPRESSION, PhpElementTypes.NUMBER, PhpElementTypes.STRING, PhpElementTypes.HEREDOC, PhpElementTypes.INFIX_EXPRESSION})});
    public static final TokenSet CONSTANT_SCALAR_EXPRESSIONS = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{PhpElementTypes.STATIC_SCALAR, PhpElementTypes.ARRAY_ACCESS_EXPRESSION, PhpElementTypes.ARRAY_INDEX, PhpElementTypes.ARRAY_CREATION_EXPRESSION, PhpElementTypes.HASH_ARRAY_ELEMENT, PhpElementTypes.ARRAY_KEY, PhpElementTypes.ARRAY_VALUE, PhpElementTypes.PARENTHESIZED_EXPRESSION, PhpElementTypes.TERNARY_EXPRESSION}), CONSTANT_SCALARS_ONLY, PhpElementTypes.BINARY_EXPRESSIONS});
    static final TokenSet PARAMETER_EXPRESSIONS = TokenSet.orSet((TokenSet[])new TokenSet[]{CONSTANT_SCALAR_EXPRESSIONS, TokenSet.create((IElementType[])new IElementType[]{PhpElementTypes.FUNCTION_CALL, PhpElementTypes.PARAMETER_LIST, PhpStubElementTypes.VARIABLE})});

    private PhpCodeValidationUtil() {
    }

    public static boolean isAllowedAsFieldDefaultValue(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpCodeValidationUtil.$$$reportNull$$$0(0);
        }
        final PhpLanguageLevel level = PhpProjectConfigurationFacade.getInstance(expression.getProject()).getLanguageLevel();
        final Ref isAllowed = new Ref((Object)true);
        expression.accept((PsiElementVisitor)new PhpElementVisitor(){

            public void visitPhpConstantReference(ConstantReference reference) {
            }

            public void visitPhpClassConstantReference(ClassConstantReference constantReference) {
            }

            public void visitPhpStringLiteralExpression(StringLiteralExpression expression) {
                if (expression.getChildren().length != 0) {
                    isAllowed.set((Object)false);
                }
            }

            public void visitPhpArrayCreationExpression(ArrayCreationExpression expression) {
                expression.acceptChildren((PsiElementVisitor)this);
            }

            public void visitPhpExpression(PhpExpression expression) {
                if (level.hasFeature(PhpLanguageFeature.CLOSURES_IN_CONSTANT_EXPRESSIONS) && PhpCodeValidationUtil.isStaticClosureAssignment((PsiElement)expression)) {
                    isAllowed.set((Object)true);
                    return;
                }
                IElementType expressionType = expression.getNode().getElementType();
                if (!PhpElementTypes.NUMBER.equals(expressionType)) {
                    super.visitPhpExpression(expression);
                }
            }

            public void visitPhpNewExpression(NewExpression expression) {
                isAllowed.set((Object)false);
            }

            public void visitPhpUnaryExpression(UnaryExpression expr) {
                IElementType firstPsiChildType;
                PhpPsiElement firstPsiChild;
                IElementType operationType;
                if (level.hasFeature(PhpLanguageFeature.CONSTANT_SCALAR_EXPRESSIONS)) {
                    return;
                }
                PsiElement operation = expr.getOperation();
                if (operation != null && (PhpTokenTypes.opMINUS.equals(operationType = operation.getNode().getElementType()) || PhpTokenTypes.opPLUS.equals(operationType)) && (firstPsiChild = expr.getFirstPsiChild()) != null && PhpElementTypes.NUMBER.equals(firstPsiChildType = firstPsiChild.getNode().getElementType())) {
                    return;
                }
                isAllowed.set((Object)false);
            }

            public void visitPhpElement(PhpPsiElement element) {
                IElementType elementType = element.getNode().getElementType();
                if (PhpElementTypes.HASH_ARRAY_ELEMENT.equals(elementType) || PhpElementTypes.ARRAY_KEY.equals(elementType) || PhpElementTypes.ARRAY_VALUE.equals(elementType) || level.hasFeature(PhpLanguageFeature.CONSTANT_SCALAR_EXPRESSIONS) && (PhpElementTypes.ARRAY_INDEX.equals(elementType) || PhpElementTypes.ARRAY_ACCESS_EXPRESSION.equals(elementType) || PhpElementTypes.BINARY_EXPRESSIONS.contains(elementType) || PhpElementTypes.UNARY_EXPRESSIONS.contains(elementType) || PhpElementTypes.TERNARY_EXPRESSION == elementType || PhpElementTypes.PARENTHESIZED_EXPRESSION == elementType)) {
                    element.acceptChildren((PsiElementVisitor)this);
                } else if (!(element instanceof PhpDocComment)) {
                    isAllowed.set((Object)false);
                }
            }

            public void visitPhpFieldReference(FieldReference fieldReference) {
                if (!PhpCodeValidationUtil.isEnumFieldReference((PsiElement)fieldReference)) {
                    super.visitPhpFieldReference(fieldReference);
                }
            }
        });
        return (Boolean)isAllowed.get();
    }

    public static boolean isAllowedAsConstantValue(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpCodeValidationUtil.$$$reportNull$$$0(1);
        }
        if (PhpCodeValidationUtil.isSupportedConstClosureExpressionDefaultValue(expression, true, true)) {
            return true;
        }
        if (PhpPsiUtil.isOfType(expression, PhpElementTypes.HASH_ARRAY_ELEMENT)) {
            return false;
        }
        PhpLanguageLevel level = PhpProjectConfigurationFacade.getInstance(expression.getProject()).getLanguageLevel();
        if (level.hasFeature(PhpLanguageFeature.CLOSURES_IN_CONSTANT_EXPRESSIONS) && (PhpCodeValidationUtil.isStaticClosureAssignment(expression) || PhpCodeValidationUtil.isConstClosureAttributeArgument(expression))) {
            return true;
        }
        TokenSet check = level.hasFeature(PhpLanguageFeature.CONSTANT_SCALAR_EXPRESSIONS) ? CONSTANT_SCALAR_EXPRESSIONS : CONSTANT_SCALARS_ONLY;
        return PhpCodeValidationUtil.checkStaticAllowedExpression(expression, check);
    }

    public static boolean isStaticClosureAssignment(PsiElement element) {
        return PhpCodeValidationUtil.isStaticFunctionHostExpression(element) && PhpPsiUtil.findPrevSiblingOfAnyType(element, PhpTokenTypes.opASGN) != null;
    }

    public static boolean isConstClosureAttributeArgument(PsiElement element) {
        PhpExpectedFunctionScalarArgument arg;
        PhpType type;
        PhpExpectedFunctionArgument phpExpectedFunctionArgument;
        int argIdx;
        PhpAttribute attribute;
        return PhpCodeValidationUtil.isStaticFunctionHostExpression(element) && (attribute = PhpPsiUtil.getParentOfClass(element, PhpAttribute.class)) != null && (argIdx = ArrayUtil.find((Object[])attribute.getParameters(), (Object)element)) >= 0 && (phpExpectedFunctionArgument = ((PhpAttribute.PhpAttributeArgument)attribute.getArguments().get(argIdx)).getArgument()) instanceof PhpExpectedFunctionScalarArgument && ((type = PhpType.from((String[])new String[]{(arg = (PhpExpectedFunctionScalarArgument)phpExpectedFunctionArgument).getType()}).global(element.getProject())).equals((Object)PhpType.CLOSURE) || type.equals((Object)PhpType.CALLABLE));
    }

    private static boolean isStaticFunctionHostExpression(PsiElement element) {
        Function function;
        PhpExpression expression;
        PsiElement psiElement;
        return element instanceof PhpExpression && (psiElement = (expression = (PhpExpression)element).getFirstChild()) instanceof Function && PhpPsiUtil.getChildOfType((PsiElement)(function = (Function)psiElement), PhpTokenTypes.kwSTATIC) != null;
    }

    public static boolean isSupportedConstClosureExpressionDefaultValue(@Nullable PsiElement defaultValue, boolean enforceLanguageLevel, boolean enforceStatic) {
        Function fct;
        PhpPsiElement phpPsiElement;
        PhpExpressionImpl exp;
        Parameter parameter = PhpPsiUtil.getParentOfClass(defaultValue, Parameter.class);
        return !(defaultValue == null || parameter == null || parameter.isVariadic() || parameter.getDefaultValue() != defaultValue || enforceLanguageLevel && !PhpLanguageFeature.CLOSURES_IN_CONSTANT_EXPRESSIONS.isSupported(defaultValue.getProject()) || !(defaultValue instanceof PhpExpressionImpl) || (exp = (PhpExpressionImpl)defaultValue).getIElementType() != PhpElementTypes.CLOSURE || !((phpPsiElement = exp.getFirstPsiChild()) instanceof Function) || !(fct = (Function)phpPsiElement).isClosure() || enforceStatic && fct.getFirstChild().getNode().getElementType() != PhpTokenTypes.kwSTATIC);
    }

    public static boolean checkStaticAllowedExpression(@NotNull PsiElement expression, final TokenSet allowed) {
        if (expression == null) {
            PhpCodeValidationUtil.$$$reportNull$$$0(2);
        }
        final Ref isAllowed = new Ref((Object)true);
        expression.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                ClassReference classReference;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                IElementType type = element.getNode().getElementType();
                if (!(element instanceof PhpDocComment || type instanceof PhpDocElementType || !(element instanceof PhpPsiElement) || element instanceof PhpDocTag || element instanceof ParameterList || PhpLanguageLevelInspection.isMagicConstant((PhpPsiElement)element) || allowed.contains(type) || PhpCodeValidationUtil.isEnumFieldReference(element))) {
                    isAllowed.set((Object)false);
                    this.stopWalking();
                } else if (element instanceof NewExpression && (classReference = ((NewExpression)element).getClassReference()) != null && !PhpPsiUtil.isOfType(classReference.getNameNode(), PhpTokenTypes.IDENTIFIER)) {
                    isAllowed.set((Object)false);
                    this.stopWalking();
                }
                if ((element instanceof NewExpression || element instanceof PhpAttribute) && ContainerUtil.exists((Object[])((ParameterListOwner)element).getParameters(), p -> PhpPsiUtil.isArgumentUnpacking(p) || !PhpCodeValidationUtil.checkStaticAllowedExpression(p, allowed))) {
                    isAllowed.set((Object)false);
                    this.stopWalking();
                }
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/lang/PhpCodeValidationUtil$2", "visitElement"));
            }
        });
        return (Boolean)isAllowed.get();
    }

    public static boolean isEnumFieldReference(@NotNull PsiElement element) {
        if (element == null) {
            PhpCodeValidationUtil.$$$reportNull$$$0(3);
        }
        return element instanceof FieldReference && ((FieldReference)element).getReferenceType().isDynamic() && PhpCodeValidationUtil.isEnumReference(((FieldReference)element).getClassReference());
    }

    private static boolean isEnumReference(@Nullable PhpExpression reference) {
        PhpExpression classReference;
        if (reference instanceof ClassConstantReference && (classReference = ((ClassConstantReference)reference).getClassReference()) instanceof ClassReference) {
            return !((ClassConstantReference)reference).multiResolveStrict(PhpEnumCase.class).isEmpty();
        }
        return false;
    }

    public static boolean isAllowedAsStaticValue(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpCodeValidationUtil.$$$reportNull$$$0(4);
        }
        return PhpCodeValidationUtil.checkStaticAllowedExpression(expression, CONSTANT_SCALAR_EXPRESSIONS);
    }

    public static boolean isAllowedAsParameterValue(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpCodeValidationUtil.$$$reportNull$$$0(5);
        }
        if (!(expression instanceof PhpExpression) || !PhpRefactoringUtil.isExtractableExpression((PhpExpression)expression)) {
            return false;
        }
        return PhpCodeValidationUtil.checkStaticAllowedExpression(expression, PARAMETER_EXPRESSIONS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/PhpCodeValidationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAllowedAsFieldDefaultValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAllowedAsConstantValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkStaticAllowedExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnumFieldReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isAllowedAsStaticValue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isAllowedAsParameterValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

