/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.hierarchy.call;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.jetbrains.php.hierarchy.PhpHierarchyUtils;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class PhpCallHierarchyNodeDescriptor
extends HierarchyNodeDescriptor
implements Navigatable {
    private int myUsageCount = 1;
    private final List<PsiReference> myReferences = new ArrayList<PsiReference>();
    private final boolean myNavigateToReference;

    public PhpCallHierarchyNodeDescriptor(Project project, HierarchyNodeDescriptor parentDescriptor, PsiElement element, boolean isBase, boolean navigateToReference) {
        super(project, (NodeDescriptor)parentDescriptor, element, isBase);
        this.myNavigateToReference = navigateToReference;
    }

    public boolean isValid() {
        return this.getEnclosingElement() != null;
    }

    @Nullable
    public static PhpPsiElement getEnclosingElement(PsiElement element) {
        if (element == null) {
            return null;
        }
        PhpNamedElement classOfFunctionParent = (PhpNamedElement)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)Function.INSTANCEOF, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
        if (classOfFunctionParent != null) {
            return classOfFunctionParent;
        }
        return (PhpPsiElement)PhpPsiUtil.getParentOfClass(element, false, PhpFile.class);
    }

    @Nullable
    public final PhpPsiElement getEnclosingElement() {
        return PhpCallHierarchyNodeDescriptor.getEnclosingElement(this.getPsiElement());
    }

    public void navigate(boolean requestFocus) {
        if (!this.myNavigateToReference) {
            PsiElement element = this.getPsiElement();
            if (element instanceof Navigatable && ((Navigatable)element).canNavigate()) {
                ((Navigatable)element).navigate(requestFocus);
            }
            return;
        }
        PsiReference firstReference = this.myReferences.get(0);
        PsiElement element = firstReference.getElement();
        PsiElement callElement = element.getParent();
        if (callElement instanceof Navigatable && ((Navigatable)callElement).canNavigate()) {
            ((Navigatable)callElement).navigate(requestFocus);
        } else {
            PsiFile psiFile = callElement.getContainingFile();
            if (psiFile == null) {
                return;
            }
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            FileEditorManager.getInstance((Project)this.myProject).openFile(virtualFile, requestFocus);
        }
        Editor editor = this.getEditor(callElement);
        if (editor != null) {
            HighlightManager highlightManager = HighlightManager.getInstance((Project)this.myProject);
            ArrayList highlighters = new ArrayList();
            for (PsiReference psiReference : this.myReferences) {
                PsiElement eachElement = psiReference.getElement();
                PsiElement eachMethodCall = eachElement.getParent();
                if (eachMethodCall == null) continue;
                TextRange textRange = eachMethodCall.getTextRange();
                highlightManager.addRangeHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), EditorColors.SEARCH_RESULT_ATTRIBUTES, false, highlighters);
            }
        }
    }

    @Nullable
    private Editor getEditor(PsiElement callElement) {
        if (!callElement.isValid()) {
            return null;
        }
        PsiFile psiFile = callElement.getContainingFile();
        VirtualFile virtualFile = psiFile.getVirtualFile();
        assert (virtualFile != null);
        FileEditor fileEditor = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditor(virtualFile);
        if (fileEditor instanceof TextEditor) {
            Editor editor = ((TextEditor)fileEditor).getEditor();
            return InjectedLanguageUtil.getInjectedEditorForInjectedFile((Editor)editor, (PsiFile)psiFile);
        }
        return null;
    }

    public boolean canNavigate() {
        PsiFile psiFile;
        if (!this.myNavigateToReference) {
            PsiElement element = this.getPsiElement();
            return element instanceof Navigatable && ((Navigatable)element).canNavigate();
        }
        if (this.myReferences.isEmpty()) {
            return false;
        }
        PsiReference firstReference = this.myReferences.get(0);
        PsiElement callElement = firstReference.getElement().getParent();
        if (callElement == null || !callElement.isValid()) {
            return false;
        }
        return callElement instanceof Navigatable && ((Navigatable)callElement).canNavigate() || (psiFile = callElement.getContainingFile()) != null;
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    public final PsiElement getTargetElement() {
        return this.getPsiElement();
    }

    public final boolean update() {
        CompositeAppearance oldText = this.myHighlightedText;
        Icon oldIcon = this.getIcon();
        int flags = 1;
        if (this.isMarkReadOnly()) {
            flags |= 2;
        }
        boolean changes = super.update();
        PsiElement element = this.getPsiElement();
        PhpPsiElement enclosingElement = PhpCallHierarchyNodeDescriptor.getEnclosingElement(element);
        if (enclosingElement == null) {
            return this.invalidElement();
        }
        Icon newIcon = enclosingElement.getIcon(flags);
        this.installIcon(newIcon, changes);
        this.myHighlightedText = new CompositeAppearance();
        TextAttributes mainTextAttributes = null;
        if (this.myColor != null) {
            mainTextAttributes = new TextAttributes(this.myColor, null, null, null, 0);
        }
        if (enclosingElement instanceof Method) {
            Method method = (Method)enclosingElement;
            String methodText = method.getName();
            PhpClass containingClass = method.getContainingClass();
            String methodName = containingClass != null ? containingClass.getName() + "." + methodText : methodText;
            this.myHighlightedText.getEnding().addText(methodName, mainTextAttributes);
        } else if (enclosingElement instanceof Function) {
            Function method = (Function)enclosingElement;
            this.myHighlightedText.getEnding().addText(method.getName(), mainTextAttributes);
        } else if (enclosingElement instanceof PhpClass) {
            this.myHighlightedText.getEnding().addText(((PhpClass)enclosingElement).getName(), mainTextAttributes);
        } else if (enclosingElement instanceof PhpFile) {
            this.myHighlightedText.getEnding().addText(((PhpFile)enclosingElement).getName(), mainTextAttributes);
        }
        if (this.myUsageCount > 1) {
            this.myHighlightedText.getEnding().addText(IdeBundle.message((String)"node.call.hierarchy.N.usages", (Object[])new Object[]{this.myUsageCount}), HierarchyNodeDescriptor.getUsageCountPrefixAttributes());
        }
        String fileName = PhpHierarchyUtils.getFileNameContainingElement(element);
        this.myHighlightedText.getEnding().addText(" (" + fileName + ")", HierarchyNodeDescriptor.getPackageNameAttributes());
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText) || !Comparing.equal((Object)this.getIcon(), (Object)oldIcon)) {
            changes = true;
        }
        return changes;
    }

    public void addReference(PsiReference reference) {
        this.myReferences.add(reference);
    }

    public final void incrementUsageCount() {
        ++this.myUsageCount;
    }
}

