/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.debugger;

import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.PhpStackFrame;
import com.jetbrains.php.debug.xdebug.connection.XdebugConnection;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ContextGetRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ContextGetResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpExceptionBreak;
import com.jetbrains.php.debug.xdebug.dbgp.model.DbgpProperty;
import com.jetbrains.php.debug.xdebug.debugger.XdebugPhpEvaluator;
import com.jetbrains.php.debug.xdebug.debugger.XdebugValue;
import com.jetbrains.php.debug.xdebug.handlers.DbgpResponseHandler;
import com.jetbrains.php.lang.PhpLangUtil;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XdebugStackFrame
extends PhpStackFrame<XdebugConnection> {
    @Nullable
    private final DbgpExceptionBreak myLastException;

    public XdebugStackFrame(@NotNull PhpDebugProcess<XdebugConnection> debugProcess, @NotNull Runnable reloader, @NotNull String remoteFilePath, int lineNumber, @NotNull String functionName, int stackSize, int depth, @Nullable DbgpExceptionBreak exception) {
        if (debugProcess == null) {
            XdebugStackFrame.$$$reportNull$$$0(0);
        }
        if (reloader == null) {
            XdebugStackFrame.$$$reportNull$$$0(1);
        }
        if (remoteFilePath == null) {
            XdebugStackFrame.$$$reportNull$$$0(2);
        }
        if (functionName == null) {
            XdebugStackFrame.$$$reportNull$$$0(3);
        }
        super(debugProcess, reloader, remoteFilePath, lineNumber, functionName, stackSize, depth);
        this.myLastException = exception;
    }

    @Override
    protected void computeVariables(@NotNull XCompositeNode node) {
        if (node == null) {
            XdebugStackFrame.$$$reportNull$$$0(4);
        }
        this.computeStackVariables(node);
    }

    private void computeStackVariables(XCompositeNode node) {
        XdebugConnection connection = (XdebugConnection)this.getDebugProcess().getConnection();
        if (connection == null) {
            node.addChildren(XValueChildrenList.EMPTY, true);
            return;
        }
        if (this.myLastException != null) {
            DbgpProperty property = new DbgpProperty(this.myLastException);
            XValueChildrenList children = new XValueChildrenList();
            PhpDebugProcess<XdebugConnection> process = this.getDebugProcess();
            String encoding = PhpDebugUtil.getDebugOutputEncoding(process.getSession().getProject());
            children.add(property.getShortName(encoding), (XValue)new XdebugValue(process, this.getDepth(), -1, property));
            node.addChildren(children, false);
        }
        connection.loadContextNames(names -> this.loadContext(node, names.entrySet().iterator()));
    }

    private void loadContext(final XCompositeNode node, final Iterator<Map.Entry<Integer, String>> iterator) {
        if (iterator.hasNext()) {
            XdebugConnection connection = (XdebugConnection)this.getDebugProcess().getConnection();
            if (connection == null) {
                node.addChildren(XValueChildrenList.EMPTY, true);
                return;
            }
            final Map.Entry<Integer, String> context = iterator.next();
            if (XdebugStackFrame.isUserDefinedConstantsContext(context.getKey()) && !PhpProjectDebugConfiguration.getInstance(this.getDebugProcess().getSession().getProject()).getState().isShowUserDefinedConstants()) {
                node.addChildren(XValueChildrenList.EMPTY, true);
                return;
            }
            final Version xdebugVersion = connection.getEngineVersion();
            connection.send(new ContextGetRequest(this.getDepth(), context.getKey()), new DbgpResponseHandler<ContextGetResponse>(){

                @Override
                public void onSuccessResponse(@NotNull ContextGetResponse message) {
                    if (message == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    List<DbgpProperty> properties = message.getProperties();
                    if (XdebugStackFrame.isUserDefinedConstantsContext((Integer)context.getKey())) {
                        if (!properties.isEmpty()) {
                            node.addChildren(XValueChildrenList.bottomGroup((XValueGroup)new PhpUserConstantsGroup(properties, (Integer)context.getKey())), false);
                        }
                    } else {
                        node.addChildren(XdebugStackFrame.this.getChildrenValue(properties, (Integer)context.getKey(), xdebugVersion), false);
                    }
                    XdebugStackFrame.this.loadContext(node, iterator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/xdebug/debugger/XdebugStackFrame$1", "onSuccessResponse"));
                }
            });
        } else {
            node.addChildren(XValueChildrenList.EMPTY, true);
        }
    }

    @NotNull
    private XValueChildrenList getChildrenValue(@NotNull List<DbgpProperty> properties, int contextKey, @Nullable Version xdebugVersion) {
        if (properties == null) {
            XdebugStackFrame.$$$reportNull$$$0(5);
        }
        XValueChildrenList children = new XValueChildrenList();
        String encoding = PhpDebugUtil.getDebugOutputEncoding(this.getDebugProcess().getSession().getProject());
        List sortedProperties = ContainerUtil.sorted(properties, Comparator.comparingInt(e -> "$this".equals(e.getShortName(encoding)) || "::".equals(e.getShortName(encoding)) ? 0 : 1));
        for (DbgpProperty property : sortedProperties) {
            if (!property.isInitialized() || !this.isVisible(property)) continue;
            XdebugValue value = new XdebugValue(this.getDebugProcess(), this.getDepth(), contextKey, property);
            if (contextKey == 1 && xdebugVersion != null && xdebugVersion.isOrGreaterThan(Integer.valueOf(3), Integer.valueOf(2)) && !PhpLangUtil.isSuperGlobal(value.getPresentableName())) continue;
            if (!property.isConstant() && !PhpLangUtil.isSuperGlobal(value.getPresentableName())) {
                this.myRuntimeEnvironment.registerVariable(value);
            }
            Object name = property.isReturnValue() ? this.getFunctionName() + "()" : property.getShortName(encoding);
            children.add((String)name, (XValue)value);
        }
        XValueChildrenList xValueChildrenList = children;
        if (xValueChildrenList == null) {
            XdebugStackFrame.$$$reportNull$$$0(6);
        }
        return xValueChildrenList;
    }

    private boolean isVisible(@NotNull DbgpProperty property) {
        String encoding;
        String variableName;
        if (property == null) {
            XdebugStackFrame.$$$reportNull$$$0(7);
        }
        if (PhpLangUtil.isSuperGlobal(variableName = StringUtil.trimStart((String)property.getShortName(encoding = PhpDebugUtil.getDebugOutputEncoding(this.getDebugProcess().getSession().getProject())), (String)"$")) && property.getChildCount() == 0) {
            return !this.isHideEmptySuperGlobals();
        }
        return !XdebugStackFrame.isEvalCache(variableName);
    }

    private static boolean isUserDefinedConstantsContext(int index) {
        return index == 2;
    }

    @Override
    @NotNull
    public XDebuggerEvaluator createEvaluator() {
        XDebugSession session = this.getDebugProcess().getSession();
        return new XdebugPhpEvaluator(session.getProject(), session.getCurrentPosition(), this.getDebugProcess(), this.getDepth());
    }

    private static String getUserDefinedConstantsGroup() {
        return PhpBundle.message("PhpUserDefinedConstantsGroup.name", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reloader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFilePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/debugger/XdebugStackFrame";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/debugger/XdebugStackFrame";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeVariables";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenValue";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    public class PhpUserConstantsGroup
    extends XValueGroup {
        private final List<DbgpProperty> myProperties;
        private final int myContextKey;

        protected PhpUserConstantsGroup(List<DbgpProperty> properties, int contextKey) {
            if (properties == null) {
                PhpUserConstantsGroup.$$$reportNull$$$0(0);
            }
            super(XdebugStackFrame.getUserDefinedConstantsGroup());
            this.myProperties = properties;
            this.myContextKey = contextKey;
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            XdebugConnection connection;
            if (node == null) {
                PhpUserConstantsGroup.$$$reportNull$$$0(1);
            }
            if ((connection = (XdebugConnection)XdebugStackFrame.this.getDebugProcess().getConnection()) == null) {
                node.addChildren(XValueChildrenList.EMPTY, true);
                return;
            }
            node.addChildren(XdebugStackFrame.this.getChildrenValue(this.myProperties, this.myContextKey, connection.getEngineVersion()), true);
        }

        @Nullable
        public Icon getIcon() {
            return PhpIcons.CONSTANT;
        }

        public boolean isRestoreExpansion() {
            return true;
        }

        public List<DbgpProperty> getProperties() {
            return this.myProperties;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/debug/xdebug/debugger/XdebugStackFrame$PhpUserConstantsGroup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeChildren";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

