/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.validation;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessors;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.border.IdeaTitledBorder;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpDeploymentAwareUtil;
import com.jetbrains.php.config.PhpInfoValidationMessage;
import com.jetbrains.php.debug.statistics.PhpDebugValidationLogger;
import com.jetbrains.php.debug.validation.PhpInfoValidator;
import com.jetbrains.php.debug.validation.PhpLocalWebServerValidator;
import com.jetbrains.php.debug.validation.PhpValidationScriptValidator;
import com.jetbrains.php.debug.validation.PhpWebServerValidationCache;
import com.jetbrains.php.debug.validation.PhpWebServerValidator;
import com.jetbrains.php.debug.validation.deploymentAware.PhpRemoteWebServerValidationForm;
import com.jetbrains.php.run.PhpRunUtil;
import com.jetbrains.php.ui.PhpInfoLabelPanel;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpWebServerValidationForm
extends JPanel {
    private static final String DEFAULT_HOST = "http://127.0.0.1/";
    private static final PhpInfoLabelPanel LOCAL_INITIAL_LABEL;
    private static final PhpInfoLabelPanel REMOTE_INITIAL_LABEL;
    private static final PhpInfoLabelPanel PHP_INFO_INITIAL_LABEL;
    private static final PhpInfoLabelPanel VALIDATION_SCRIPT_INITIAL_LABEL;
    private JPanel myMainPanel;
    private JRadioButton myLocalWebServerRadio;
    private JRadioButton myRemoteWebServerRadio;
    private TextFieldWithHistoryWithBrowseButton myPathToValidationScriptDir;
    private TextFieldWithBrowseButton myValidationScriptUrl;
    private JPanel myWarningContainer;
    private JLabel myWebPathLabel;
    private JLabel myDeploymentLabel;
    private JLabel myPathToScriptLabel;
    private JPanel myWebServerPanel;
    private JBRadioButton myPhpInfoWebServerRadio;
    private JLabel myPhpInfoOutputLabel;
    private JBScrollPane myPhpIniPane;
    private JTextArea myPhpInfoTextArea;
    private JRadioButton myValidationScriptRadio;
    private RawCommandLineEditor myCopyCommandEditor;
    private JPanel myDownloadScriptPanel;
    private JPanel myWarningPanel;
    @Nullable
    private PhpRemoteWebServerValidationForm myRemoteWebServerForm;
    private ActionListener myRadioButtonListener;
    private final Project myProject;
    private final List<PhpInfoLabelPanel> myWarningLabels;
    private boolean myDisposed;

    public PhpWebServerValidationForm(@NotNull Project project, @NotNull Disposable parent) {
        if (project == null) {
            PhpWebServerValidationForm.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            PhpWebServerValidationForm.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.myRemoteWebServerForm = null;
        this.$$$setupUI$$$();
        this.myWarningLabels = new ArrayList<PhpInfoLabelPanel>();
        this.myDisposed = false;
        this.myProject = project;
        this.add((Component)this.myMainPanel, "Center");
        this.createWarningPanel();
        this.myRadioButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhpWebServerValidationForm.this.radioSelected();
            }
        };
        this.myLocalWebServerRadio.addActionListener(this.myRadioButtonListener);
        this.myRemoteWebServerRadio.addActionListener(this.myRadioButtonListener);
        this.myPhpInfoWebServerRadio.addActionListener(this.myRadioButtonListener);
        this.myValidationScriptRadio.addActionListener(this.myRadioButtonListener);
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(PhpBundle.message("php.web.server.validation.chose.path.to.script", new Object[0])).withDescription(PhpBundle.message("php.web.server.validation.chose.path.to.script.description", new Object[0]));
        final TextFieldWithHistory textFieldComponent = (TextFieldWithHistory)this.myPathToValidationScriptDir.getChildComponent();
        this.myPathToValidationScriptDir.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener<TextFieldWithHistory>(this, (ComponentWithBrowseButton)this.myPathToValidationScriptDir, project, descriptor, TextComponentAccessors.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT){

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.onFileChosen(chosenFile);
                textFieldComponent.addCurrentTextToHistory();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/jetbrains/php/debug/validation/PhpWebServerValidationForm$2", "onFileChosen"));
            }
        });
        FileChooserFactory.getInstance().installFileCompletion(textFieldComponent.getTextEditor(), descriptor, true, parent);
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir != null) {
            textFieldComponent.setText(FileUtil.toSystemDependentName((String)baseDir.getPath()));
        }
        textFieldComponent.addCurrentTextToHistory();
        Disposer.register((Disposable)parent, (Disposable)this.myPathToValidationScriptDir);
        if (!PhpDeploymentAwareUtil.isDeploymentPluginEnabled()) {
            this.myRemoteWebServerRadio.setVisible(false);
        } else {
            this.myRemoteWebServerForm = new PhpRemoteWebServerValidationForm(this.myProject, this.myWebServerPanel, this.myDeploymentLabel);
        }
        this.myPathToScriptLabel.setLabelFor((Component)this.myPathToValidationScriptDir);
        this.myWebPathLabel.setLabelFor((Component)this.myValidationScriptUrl);
        this.myValidationScriptUrl.setText(DEFAULT_HOST);
        this.myValidationScriptUrl.addActionListener(e -> {
            String text = this.myValidationScriptUrl.getText();
            if (PublishUtils.validateUrl((String)text) == null) {
                BrowserUtil.browse((String)(text + (this.myValidationScriptRadio.isSelected() ? "/phpstorm_index.php" : "")));
            }
        });
        this.myValidationScriptUrl.getButton().setText(WDBundle.message((String)"server.form.browse", (Object[])new Object[0]));
        this.myPhpInfoWebServerRadio.setSelected(true);
        this.myCopyCommandEditor.getEditorField().addExtension(ExtendableTextComponent.Extension.create((Icon)AllIcons.General.InlineCopy, (Icon)AllIcons.General.InlineCopyHover, (String)PhpBundle.message("action.copy.to.clipboard.text", new Object[0]), () -> Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.myCopyCommandEditor.getText()), null)));
        this.reset();
        this.radioSelected();
    }

    public void setLocalUrl(@NotNull String url) {
        if (url == null) {
            PhpWebServerValidationForm.$$$reportNull$$$0(2);
        }
        this.myValidationScriptUrl.setText(url);
        this.myLocalWebServerRadio.setSelected(true);
        this.radioSelected();
    }

    private void createUIComponents() {
        this.myCopyCommandEditor = new RawCommandLineEditor(ParametersListUtil.COLON_LINE_PARSER, ParametersListUtil.COLON_LINE_JOINER);
        this.myCopyCommandEditor.setAlignmentX(0.0f);
        this.myValidationScriptUrl = new TextFieldWithBrowseButton.NoPathCompletion(){

            @NotNull
            protected Icon getDefaultIcon() {
                Icon icon = AllIcons.Toolwindows.WebToolWindow;
                if (icon == null) {
                    3.$$$reportNull$$$0(0);
                }
                return icon;
            }

            @NotNull
            protected Icon getHoveredIcon() {
                Icon icon = AllIcons.Toolwindows.WebToolWindow;
                if (icon == null) {
                    3.$$$reportNull$$$0(1);
                }
                return icon;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/php/debug/validation/PhpWebServerValidationForm$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDefaultIcon";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getHoveredIcon";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private void radioSelected() {
        boolean local = this.myLocalWebServerRadio.isSelected();
        boolean phpInfo = this.myPhpInfoWebServerRadio.isSelected();
        this.myWebPathLabel.setVisible(local);
        this.myValidationScriptUrl.setVisible(local);
        this.myPhpInfoOutputLabel.setVisible(phpInfo);
        this.myPhpIniPane.setVisible(phpInfo);
        this.myPathToScriptLabel.setVisible(!phpInfo);
        this.myPathToValidationScriptDir.setVisible(!phpInfo);
        this.myDownloadScriptPanel.setVisible(false);
        boolean validationScript = this.myValidationScriptRadio.isSelected();
        if (validationScript) {
            this.myPhpInfoOutputLabel.setVisible(false);
            this.myPhpIniPane.setVisible(false);
            this.myPathToScriptLabel.setVisible(false);
            this.myPathToValidationScriptDir.setVisible(false);
            this.myDownloadScriptPanel.setVisible(true);
            this.myValidationScriptUrl.setVisible(true);
            this.myWebPathLabel.setVisible(true);
        }
        boolean remote = this.myRemoteWebServerForm != null && this.myRemoteWebServerRadio.isSelected();
        this.myDeploymentLabel.setVisible(remote);
        if (this.myRemoteWebServerForm != null) {
            this.myRemoteWebServerForm.setVisible(remote);
        }
        this.resetWarnings();
    }

    protected void createWarningPanel() {
        VerticalFlowLayout layout = new VerticalFlowLayout(0);
        this.myWarningPanel = new JPanel((LayoutManager)layout);
        IdeaTitledBorder titledBorder = IdeBorderFactory.createTitledBorder((String)PhpBundle.message("information", new Object[0]), (boolean)false);
        JBEmptyBorder emptyBorder = JBUI.Borders.empty((int)0, (int)5, (int)10, (int)10);
        CompoundBorder border = BorderFactory.createCompoundBorder((Border)titledBorder, (Border)emptyBorder);
        if (this.myRemoteWebServerForm == null || !this.myRemoteWebServerForm.isValid()) {
            this.resetWarnings();
        }
        JBScrollPane comp = new JBScrollPane((Component)this.myWarningPanel);
        comp.setBorder((Border)border);
        this.myWarningContainer.add((Component)comp, "Center");
        this.myWarningContainer.setPreferredSize((Dimension)JBUI.size((int)530, (int)170));
    }

    public void doValidateAction() {
        this.apply();
        List<Object> validate = new ArrayList();
        if (!this.myPhpInfoWebServerRadio.isSelected()) {
            VirtualFile directory = PhpRunUtil.findDirectory(((TextFieldWithHistory)this.myPathToValidationScriptDir.getChildComponent()).getText());
            if (directory == null) {
                this.myWarningLabels.clear();
                PhpInfoValidationMessage message = PhpInfoValidationMessage.failed(PhpBundle.message("php.web.server.validation.invalid.path.to.script", new Object[0]), null, new Runnable[0]);
                this.myWarningLabels.add(PhpInfoLabelPanel.create(message));
                this.updateWarningPanel();
                return;
            }
            PhpWebServerValidator validator = this.createWebServerValidator();
            try {
                validate = validator.validate(directory, this.myWarningContainer);
                validate.sort(Comparator.comparingInt(o -> o.getType().getWeight()));
                this.myWarningLabels.clear();
                for (PhpInfoValidationMessage phpInfoValidationMessage : validate) {
                    this.myWarningLabels.add(PhpInfoLabelPanel.create(phpInfoValidationMessage));
                }
                this.updateWarningPanel();
            }
            catch (ProcessCanceledException processCanceledException) {
                this.resetWarnings();
            }
        } else {
            PhpInfoValidator validator = new PhpInfoValidator(this.myProject);
            validate = validator.validate(this.myPhpInfoTextArea.getText());
            validate.sort(Comparator.comparingInt(o -> o.getType().getWeight()));
            this.myWarningLabels.clear();
            for (PhpInfoValidationMessage phpInfoValidationMessage : validate) {
                this.myWarningLabels.add(PhpInfoLabelPanel.create(phpInfoValidationMessage));
            }
            this.updateWarningPanel();
        }
        PhpDebugValidationLogger.logValidationEvent(this.myValidationScriptRadio.isSelected() ? PhpDebugValidationLogger.ValidationType.SCRIPT : (this.myLocalWebServerRadio.isSelected() ? PhpDebugValidationLogger.ValidationType.LOCAL : (this.myRemoteWebServerRadio.isSelected() ? PhpDebugValidationLogger.ValidationType.REMOTE : PhpDebugValidationLogger.ValidationType.PHPINFO)), ContainerUtil.filter(validate, i -> i.getType().equals((Object)PhpInfoValidationMessage.MessageType.ERROR)).size());
    }

    private PhpWebServerValidator createWebServerValidator() {
        if (this.myLocalWebServerRadio.isSelected() || this.myRemoteWebServerForm == null) {
            return new PhpLocalWebServerValidator(this.myProject, this.myValidationScriptUrl.getText());
        }
        if (this.myValidationScriptRadio.isSelected()) {
            return new PhpValidationScriptValidator(this.myProject, this.myValidationScriptUrl.getText());
        }
        return this.myRemoteWebServerForm.createWebServerValidator(this.myProject, this.myMainPanel);
    }

    private void resetWarnings() {
        this.myWarningLabels.clear();
        if (this.myLocalWebServerRadio.isSelected()) {
            this.myWarningLabels.add(LOCAL_INITIAL_LABEL);
        } else if (this.myRemoteWebServerRadio.isSelected()) {
            this.myWarningLabels.add(REMOTE_INITIAL_LABEL);
        } else if (this.myValidationScriptRadio.isSelected()) {
            this.myWarningLabels.add(VALIDATION_SCRIPT_INITIAL_LABEL);
        } else {
            this.myWarningLabels.add(PHP_INFO_INITIAL_LABEL);
        }
        this.updateWarningPanel();
    }

    private void updateWarningPanel() {
        UIUtil.invokeAndWaitIfNeeded(() -> {
            if (this.myDisposed) {
                return;
            }
            this.myWarningPanel.removeAll();
            for (PhpInfoLabelPanel label : this.myWarningLabels) {
                this.myWarningPanel.add(label);
            }
            this.myWarningPanel.updateUI();
        });
    }

    protected void disposeUI() {
        this.myDisposed = true;
        this.myLocalWebServerRadio.removeActionListener(this.myRadioButtonListener);
        this.myRemoteWebServerRadio.removeActionListener(this.myRadioButtonListener);
        this.myPhpInfoWebServerRadio.removeActionListener(this.myRadioButtonListener);
        this.myValidationScriptRadio.removeActionListener(this.myRadioButtonListener);
        this.myRadioButtonListener = null;
        if (this.myRemoteWebServerForm != null) {
            this.myRemoteWebServerForm.disposeUI();
        }
    }

    private void apply() {
        PhpWebServerValidationCache.State state = PhpWebServerValidationCache.getInstance(this.myProject).getState();
        if (state != null) {
            state.setType(this.myRemoteWebServerRadio.isSelected() ? PhpWebServerValidationCache.PhpWebServerValidationType.REMOTE : PhpWebServerValidationCache.PhpWebServerValidationType.LOCAL);
            state.setPathToValidationScript(StringUtil.notNullize((String)this.myPathToValidationScriptDir.getText()));
            state.setWebPathToValidationScript(StringUtil.notNullize((String)this.myValidationScriptUrl.getText()));
            if (this.myRemoteWebServerForm != null) {
                this.myRemoteWebServerForm.apply(state);
            }
        }
    }

    private void reset() {
        PhpWebServerValidationCache.State state = PhpWebServerValidationCache.getInstance(this.myProject).getState();
        if (state != null) {
            boolean deploymentEnabled;
            String webPath;
            String pathToScript = state.getPathToValidationScript();
            if (pathToScript != null) {
                ((TextFieldWithHistory)this.myPathToValidationScriptDir.getChildComponent()).setText(pathToScript);
            }
            if ((webPath = state.getWebPathToValidationScript()) != null) {
                this.myValidationScriptUrl.setText(webPath);
            }
            if ((deploymentEnabled = PhpDeploymentAwareUtil.isDeploymentPluginEnabled()) && state.getType() == PhpWebServerValidationCache.PhpWebServerValidationType.REMOTE) {
                assert (this.myRemoteWebServerForm != null);
                this.myRemoteWebServerRadio.setSelected(true);
            } else {
                this.myPhpInfoWebServerRadio.setSelected(true);
            }
            if (deploymentEnabled && this.myRemoteWebServerForm != null) {
                this.myRemoteWebServerForm.reset(this.myProject, state);
            }
        }
    }

    static {
        String localDescription = PhpBundle.message("validation.script.will.be.created.locally.and.the.result.will.be.fetched.by.http.request", new Object[0]);
        String local = PhpBundle.message("php.web.server.validation.configure.local", new Object[0]);
        LOCAL_INITIAL_LABEL = PhpInfoLabelPanel.create(PhpInfoValidationMessage.error(local, localDescription, new Runnable[0]));
        HtmlBuilder builder2 = new HtmlBuilder();
        builder2.append(PhpBundle.message("validation.script.will.be.created.locally.and.deployed.to.the.remote.server", new Object[0])).br();
        builder2.append(PhpBundle.message("the.result.of.validation.will.be.fetched.by.http.request", new Object[0])).br();
        String remote = PhpBundle.message("php.web.server.validation.configure.remote", new Object[0]);
        REMOTE_INITIAL_LABEL = PhpInfoLabelPanel.create(PhpInfoValidationMessage.error(remote, builder2.toString(), new Runnable[0]));
        PHP_INFO_INITIAL_LABEL = PhpInfoLabelPanel.create(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.configure.phpinfo", new Object[0]), PhpBundle.message("php.web.server.validation.configure.phpinfo.desc", new Object[0]), new Runnable[0]));
        VALIDATION_SCRIPT_INITIAL_LABEL = PhpInfoLabelPanel.create(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.configure.validation.script", new Object[0]), null, new Runnable[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/debug/validation/PhpWebServerValidationForm";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setLocalUrl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JTextArea jTextArea;
        JBScrollPane jBScrollPane;
        JPanel jPanel2;
        JLabel jLabel;
        JPanel jPanel3;
        JLabel jLabel2;
        JLabel jLabel3;
        JLabel jLabel4;
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton;
        JRadioButton jRadioButton;
        JBRadioButton jBRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel4;
        this.createUIComponents();
        this.myMainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, "North");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myLocalWebServerRadio = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpWebServerValidationForm.class).getString("php.web.server.validation.local.web.server.radio"));
        jPanel6.add((Component)jRadioButton3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        this.myRemoteWebServerRadio = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpWebServerValidationForm.class).getString("php.web.server.validation.remote.web.server.radio"));
        jPanel6.add((Component)jRadioButton2, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        this.myPhpInfoWebServerRadio = jBRadioButton = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpWebServerValidationForm.class).getString("output.phpinfo.title"));
        jPanel6.add((Component)jBRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        this.myValidationScriptRadio = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpWebServerValidationForm.class).getString("php.web/server.validation.validation.script"));
        jPanel6.add((Component)jRadioButton, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(10, 0, 0, 0), -1, 3, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPathToValidationScriptDir = textFieldWithHistoryWithBrowseButton = new TextFieldWithHistoryWithBrowseButton();
        jPanel7.add((Component)textFieldWithHistoryWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myPathToScriptLabel = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpWebServerValidationForm.class).getString("php.web.server.validation.local.path.to.script"));
        jLabel4.setToolTipText(DynamicBundle.getBundle((String)"messages/PhpBundle", PhpWebServerValidationForm.class).getString("php.web.server.validation.local.path.to.script.tooltip"));
        jPanel7.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWebPathLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpWebServerValidationForm.class).getString("php.web.server.validation.url.to.validation.script"));
        jLabel3.setToolTipText(DynamicBundle.getBundle((String)"messages/PhpBundle", PhpWebServerValidationForm.class).getString("php.web.server.validation.url.to.validation.script.tooltip"));
        jPanel7.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDeploymentLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpWebServerValidationForm.class).getString("php.web.server.validation.deployment.server"));
        jLabel2.setToolTipText(DynamicBundle.getBundle((String)"messages/PhpBundle", PhpWebServerValidationForm.class).getString("php.web.server.validation.deployment.server.tooltip"));
        jPanel7.add((Component)jLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWebServerPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel3, new GridConstraints(3, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPhpInfoOutputLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpWebServerValidationForm.class).getString("output.phpinfo"));
        jPanel7.add((Component)jLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDownloadScriptPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpWebServerValidationForm.class).getString("xdebug.validation.download.script.label"));
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        RawCommandLineEditor rawCommandLineEditor = this.myCopyCommandEditor;
        rawCommandLineEditor.setAlignmentX(0.0f);
        rawCommandLineEditor.setText("curl -f -L  -o ./phpstorm_xdebug.zip \"https://packages.jetbrains.team/files/p/ij/xdebug-validation-script/script/phpstorm_xdebug_validator.zip\";unzip ./phpstorm_xdebug.zip -d .;rm -f ./phpstorm_xdebug.zip");
        jPanel2.add((Component)rawCommandLineEditor, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.myValidationScriptUrl;
        jPanel8.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPhpIniPane = jBScrollPane = new JBScrollPane();
        jBScrollPane.setVerticalScrollBarPolicy(22);
        jPanel5.add((Component)jBScrollPane, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myPhpInfoTextArea = jTextArea = new JTextArea();
        jTextArea.setRows(10);
        jBScrollPane.setViewportView(jTextArea);
        this.myWarningContainer = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, "Center");
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, "Center");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

