/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.validation;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.validation.PhpWebServerValidationForm;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpWebServerValidationDialog
extends DialogWrapper {
    private static final String DIMENSION_SERVICE_KEY_BASE = "#com.jetbrains.php.debug.validation.PhpWebServerValidationDialog#";
    private static final String HELP_ID = "reference.settings.php.servers.validate";
    private final PhpWebServerValidationForm myValidationForm;
    private final ValidateAction myValidateAction;

    public PhpWebServerValidationDialog(@NotNull Project project, @Nullable String url) {
        if (project == null) {
            PhpWebServerValidationDialog.$$$reportNull$$$0(0);
        }
        super(project);
        this.setTitle(PhpBundle.message("php.web.server.validation.title", new Object[0]));
        this.myValidateAction = new ValidateAction();
        this.myValidationForm = new PhpWebServerValidationForm(project, this.getDisposable());
        if (StringUtil.isNotEmpty((String)url)) {
            this.myValidationForm.setLocalUrl(url);
        }
        Disposer.register((Disposable)this.getDisposable(), (Disposable)new Disposable(){

            public void dispose() {
                PhpWebServerValidationDialog.this.myValidationForm.disposeUI();
            }
        });
        this.init();
    }

    protected Action @NotNull [] createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.myValidateAction);
        actions.add(this.getCancelAction());
        actions.add(this.getHelpAction());
        if (SystemInfo.isMac) {
            Collections.reverse(actions);
        }
        Action[] actionArray = actions.toArray(new Action[0]);
        if (actionArray == null) {
            PhpWebServerValidationDialog.$$$reportNull$$$0(1);
        }
        return actionArray;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myValidationForm;
    }

    protected void doValidateAction() {
        this.myValidationForm.doValidateAction();
    }

    protected String getDimensionServiceKey() {
        return DIMENSION_SERVICE_KEY_BASE;
    }

    protected String getHelpId() {
        return HELP_ID;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/validation/PhpWebServerValidationDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/validation/PhpWebServerValidationDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private class ValidateAction
    extends AbstractAction {
        ValidateAction() {
            this.putValue("Name", PhpBundle.message("php.web.server.validation.dialog.validate.button", new Object[0]));
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PhpWebServerValidationDialog.this.doValidateAction();
        }
    }
}

