/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.common.smartStepInto;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.stepping.XSmartStepIntoVariant;
import com.jetbrains.php.PhpIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpSmartStepIntoVariant
extends XSmartStepIntoVariant {
    private final int myLineStart;
    private int myLineEnd;
    private final String myPresentationText;

    public PhpSmartStepIntoVariant(int line, @NotNull String presentation) {
        if (presentation == null) {
            PhpSmartStepIntoVariant.$$$reportNull$$$0(0);
        }
        this.myLineStart = line;
        this.myLineEnd = line;
        StringBuilder result = new StringBuilder(presentation.length());
        boolean prevIsWhitespace = true;
        for (int i = 0; i < presentation.length(); ++i) {
            char ch = presentation.charAt(i);
            boolean isWhitespace = Character.isWhitespace(ch);
            if (!isWhitespace) {
                result.append(ch);
            } else if (!prevIsWhitespace) {
                result.append(' ');
            }
            prevIsWhitespace = isWhitespace;
        }
        this.myPresentationText = result.toString();
    }

    public abstract String getVariantName();

    public int getLineStart() {
        return this.myLineStart;
    }

    public int getLineEnd() {
        return this.myLineEnd;
    }

    public void setLineEnd(int lineEnd) {
        this.myLineEnd = lineEnd;
    }

    @Nullable
    public Icon getIcon() {
        return PhpIcons.FUNCTION;
    }

    public String getText() {
        return this.myPresentationText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/jetbrains/php/debug/common/smartStepInto/PhpSmartStepIntoVariant", "<init>"));
    }

    public static class PhpFunctionSmartStepIntoVariant
    extends PhpSmartStepIntoVariant {
        protected String myFunctionName;

        public PhpFunctionSmartStepIntoVariant(int line, @NotNull String functionName, @NotNull String presentation) {
            if (functionName == null) {
                PhpFunctionSmartStepIntoVariant.$$$reportNull$$$0(0);
            }
            if (presentation == null) {
                PhpFunctionSmartStepIntoVariant.$$$reportNull$$$0(1);
            }
            super(line, presentation);
            this.myFunctionName = functionName;
        }

        @NotNull
        public String getFunctionName() {
            String string = this.myFunctionName;
            if (string == null) {
                PhpFunctionSmartStepIntoVariant.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public String getVariantName() {
            return this.getFunctionName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/debug/common/smartStepInto/PhpSmartStepIntoVariant$PhpFunctionSmartStepIntoVariant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/debug/common/smartStepInto/PhpSmartStepIntoVariant$PhpFunctionSmartStepIntoVariant";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFunctionName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static class PhpMethodSmartStepIntoVariant
    extends PhpFunctionSmartStepIntoVariant {
        private static final String SEPARATOR = "->";
        private final String myClassReference;
        private final List<String> myStackTrace;

        public PhpMethodSmartStepIntoVariant(int line, @NotNull String functionName, @NotNull String presentation, @Nullable String classReference, @Nullable List<String> stackTrace) {
            if (functionName == null) {
                PhpMethodSmartStepIntoVariant.$$$reportNull$$$0(0);
            }
            if (presentation == null) {
                PhpMethodSmartStepIntoVariant.$$$reportNull$$$0(1);
            }
            super(line, functionName, presentation);
            this.myClassReference = classReference;
            this.myStackTrace = stackTrace;
        }

        @Nullable
        public String getClassReference() {
            return this.myClassReference;
        }

        @Nullable
        public List<String> getStackTrace() {
            return this.myStackTrace;
        }

        @Override
        public String getVariantName() {
            StringBuilder variantName = new StringBuilder();
            if (this.myClassReference != null) {
                variantName.append(this.myClassReference);
                variantName.append(SEPARATOR);
            }
            if (this.myStackTrace != null) {
                variantName.append(StringUtil.join(this.myStackTrace, (String)SEPARATOR));
                variantName.append(SEPARATOR);
            }
            variantName.append(super.getVariantName());
            return variantName.toString();
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return PhpIcons.METHOD;
        }

        public void setFunctionName(@NotNull String functionName) {
            if (functionName == null) {
                PhpMethodSmartStepIntoVariant.$$$reportNull$$$0(2);
            }
            this.myFunctionName = functionName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/debug/common/smartStepInto/PhpSmartStepIntoVariant$PhpMethodSmartStepIntoVariant";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setFunctionName";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

