/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.common;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMethodBreakpointProperties
extends XBreakpointProperties<PhpMethodBreakpointProperties> {
    private static final String CLASS_FQN_AND_METHOD_SEPARATOR = "::";
    private String myClassName;
    private String myMethodName;
    private String myCachedFqn;

    public PhpMethodBreakpointProperties() {
        this.myCachedFqn = null;
    }

    @NotNull
    private static String removeExtraFromClassName(@Nullable String classFqn) {
        if (classFqn == null) {
            return "";
        }
        String string = StringUtil.trimStart((String)StringUtil.trimEnd((String)classFqn, (String)"\\"), (String)"\\");
        if (string == null) {
            PhpMethodBreakpointProperties.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    private static String removeExtraFromMethodName(@Nullable String methodName) {
        if (methodName == null) {
            return "";
        }
        String string = StringUtil.trimStart((String)StringUtil.trimStart((String)methodName, (String)"\\"), (String)CLASS_FQN_AND_METHOD_SEPARATOR);
        if (string == null) {
            PhpMethodBreakpointProperties.$$$reportNull$$$0(1);
        }
        return string;
    }

    public PhpMethodBreakpointProperties(@Nullable String classFqn, @NotNull String name) {
        if (name == null) {
            PhpMethodBreakpointProperties.$$$reportNull$$$0(2);
        }
        this.myCachedFqn = null;
        this.myClassName = classFqn;
        this.myMethodName = name;
    }

    public String getMethodName() {
        return this.myMethodName;
    }

    public String getClassName() {
        return this.myClassName;
    }

    @NotNull
    public String getFunctionFqn() {
        String methodRightName = PhpMethodBreakpointProperties.removeExtraFromMethodName(this.myMethodName);
        String classRightName = PhpMethodBreakpointProperties.removeExtraFromClassName(this.myClassName);
        if (methodRightName.isEmpty()) {
            return "";
        }
        if (classRightName.isEmpty()) {
            String string = methodRightName;
            if (string == null) {
                PhpMethodBreakpointProperties.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = classRightName + CLASS_FQN_AND_METHOD_SEPARATOR + methodRightName;
        if (string == null) {
            PhpMethodBreakpointProperties.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getStackFrameFunctionFqn() {
        if (this.myCachedFqn == null) {
            this.myCachedFqn = this.getFunctionFqn();
        }
        String string = this.myCachedFqn;
        if (string == null) {
            PhpMethodBreakpointProperties.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void setMethodName(String methodName) {
        this.myMethodName = methodName;
    }

    public void setClassName(String className) {
        this.myClassName = className;
    }

    @Nullable
    public PhpMethodBreakpointProperties getState() {
        return this;
    }

    @NotNull
    @NlsSafe
    public String getDisplayName() {
        if (this.myClassName == null || this.myClassName.isEmpty()) {
            String string = this.myMethodName == null ? "" : this.myMethodName;
            if (string == null) {
                PhpMethodBreakpointProperties.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = this.myClassName + CLASS_FQN_AND_METHOD_SEPARATOR + this.myMethodName;
        if (string == null) {
            PhpMethodBreakpointProperties.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void loadState(@NotNull PhpMethodBreakpointProperties state) {
        if (state == null) {
            PhpMethodBreakpointProperties.$$$reportNull$$$0(8);
        }
        this.myClassName = state.myClassName;
        this.myMethodName = state.myMethodName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/common/PhpMethodBreakpointProperties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "removeExtraFromClassName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "removeExtraFromMethodName";
                break;
            }
            case 2: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/common/PhpMethodBreakpointProperties";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionFqn";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStackFrameFunctionFqn";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 8 -> new IllegalArgumentException(string);
        };
    }
}

