/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.common;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.PhpDebuggerEditorsProvider;
import com.jetbrains.php.debug.common.PhpLineBreakpointTypeBase;
import com.jetbrains.php.debug.common.PhpMethodBreakpointProperties;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class PhpLineMethodBreakpointType
extends PhpLineBreakpointTypeBase<PhpMethodBreakpointProperties> {
    public static final PhpLineMethodBreakpointType INSTANCE = new PhpLineMethodBreakpointType();
    private final Predicate<PsiElement> myAcceptPredicate = element -> PhpLineMethodBreakpointType.isFunctionDeclaration(element) && !PhpLineMethodBreakpointType.isUnsupportedElement(element);
    private final Predicate<PsiElement> myProhibitPredicate = element -> false;

    private static boolean isUnsupportedElement(PsiElement element) {
        Function fn = (Function)element.getParent();
        return PhpLineMethodBreakpointType.isMethodOfAnonymousClass(fn) || PhpLineMethodBreakpointType.isMethodInTrait(fn) || PhpLineMethodBreakpointType.isMethodInInterface(fn);
    }

    @Override
    @Nullable
    public PhpMethodBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        if (file == null) {
            PhpLineMethodBreakpointType.$$$reportNull$$$0(0);
        }
        return (PhpMethodBreakpointProperties)((Object)super.createBreakpointProperties(file, line));
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_method_breakpoint;
        if (icon == null) {
            PhpLineMethodBreakpointType.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_disabled_method_breakpoint;
        if (icon == null) {
            PhpLineMethodBreakpointType.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @NotNull
    public Icon getSuspendNoneIcon() {
        Icon icon = AllIcons.Debugger.Db_no_suspend_method_breakpoint;
        if (icon == null) {
            PhpLineMethodBreakpointType.$$$reportNull$$$0(3);
        }
        return icon;
    }

    @NotNull
    public Icon getMutedEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_muted_method_breakpoint;
        if (icon == null) {
            PhpLineMethodBreakpointType.$$$reportNull$$$0(4);
        }
        return icon;
    }

    @NotNull
    public Icon getMutedDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_muted_disabled_method_breakpoint;
        if (icon == null) {
            PhpLineMethodBreakpointType.$$$reportNull$$$0(5);
        }
        return icon;
    }

    @NotNull
    public Icon getInactiveDependentIcon() {
        Icon icon = AllIcons.Debugger.Db_dep_method_breakpoint;
        if (icon == null) {
            PhpLineMethodBreakpointType.$$$reportNull$$$0(6);
        }
        return icon;
    }

    @Nullable
    public Icon getPendingIcon() {
        return AllIcons.Debugger.Db_method_breakpoint;
    }

    @Nullable
    public PhpMethodBreakpointProperties createProperties() {
        return new PhpMethodBreakpointProperties();
    }

    @NotNull
    public static PhpLineMethodBreakpointType getInstance() {
        PhpLineMethodBreakpointType phpLineMethodBreakpointType = (PhpLineMethodBreakpointType)((Object)XBreakpointType.EXTENSION_POINT_NAME.findExtensionOrFail(PhpLineMethodBreakpointType.class));
        if (phpLineMethodBreakpointType == null) {
            PhpLineMethodBreakpointType.$$$reportNull$$$0(7);
        }
        return phpLineMethodBreakpointType;
    }

    private PhpLineMethodBreakpointType() {
        super("php-line-method", PhpBundle.message("debug.php.method.breakpoint.title", new Object[0]), (XDebuggerEditorsProvider)new PhpDebuggerEditorsProvider());
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        PsiElement targetPhpElement;
        if (file == null) {
            PhpLineMethodBreakpointType.$$$reportNull$$$0(8);
        }
        if (project == null) {
            PhpLineMethodBreakpointType.$$$reportNull$$$0(9);
        }
        return (targetPhpElement = PhpLineMethodBreakpointType.findPhpPsiElementByCondition(file, line, project, this.myAcceptPredicate, this.myProhibitPredicate)) != null;
    }

    public String getShortText(XLineBreakpoint<PhpMethodBreakpointProperties> breakpoint) {
        PhpMethodBreakpointProperties properties = (PhpMethodBreakpointProperties)breakpoint.getProperties();
        return properties.getDisplayName();
    }

    @NotNull
    public List<? extends XLineBreakpointType.XLineBreakpointVariant> computeVariants(@NotNull Project project, @NotNull XSourcePosition position) {
        if (project == null) {
            PhpLineMethodBreakpointType.$$$reportNull$$$0(10);
        }
        if (position == null) {
            PhpLineMethodBreakpointType.$$$reportNull$$$0(11);
        }
        ArrayList<PhpLineMethodBreakpointVariant> variants = new ArrayList<PhpLineMethodBreakpointVariant>();
        variants.add(new PhpLineMethodBreakpointVariant(project, position.getFile(), position.getLine()));
        ArrayList<PhpLineMethodBreakpointVariant> arrayList = variants;
        if (arrayList == null) {
            PhpLineMethodBreakpointType.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    public Promise<List<? extends XLineBreakpointType.XLineBreakpointVariant>> computeVariantsAsync(@NotNull Project project, @NotNull XSourcePosition position) {
        if (project == null) {
            PhpLineMethodBreakpointType.$$$reportNull$$$0(13);
        }
        if (position == null) {
            PhpLineMethodBreakpointType.$$$reportNull$$$0(14);
        }
        Promise promise = Promises.resolvedPromise(this.computeVariants(project, position));
        if (promise == null) {
            PhpLineMethodBreakpointType.$$$reportNull$$$0(15);
        }
        return promise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 12, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/common/PhpLineMethodBreakpointType";
                break;
            }
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/common/PhpLineMethodBreakpointType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuspendNoneIcon";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutedEnabledIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutedDisabledIcon";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInactiveDependentIcon";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "computeVariants";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "computeVariantsAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createBreakpointProperties";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 15: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canPutAt";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computeVariants";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "computeVariantsAsync";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 12, 15 -> new IllegalStateException(string);
        };
    }

    public class PhpLineMethodBreakpointVariant
    extends XLineBreakpointType.XLineBreakpointVariant {
        Project myProject;
        VirtualFile myFile;
        int myLine;

        public PhpLineMethodBreakpointVariant(Project project, VirtualFile file, int line) {
            super((XLineBreakpointType)PhpLineMethodBreakpointType.this);
            this.myProject = project;
            this.myFile = file;
            this.myLine = line;
        }

        @NotNull
        public String getText() {
            String string = PhpBundle.message("debugger.method", new Object[0]);
            if (string == null) {
                PhpLineMethodBreakpointVariant.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        public Icon getIcon() {
            return AllIcons.Debugger.Db_method_breakpoint;
        }

        @Nullable
        public TextRange getHighlightRange() {
            return null;
        }

        @Nullable
        public PhpMethodBreakpointProperties createProperties() {
            PhpClass containingClass;
            PsiElement functionDeclarationElement = PhpLineBreakpointTypeBase.findPhpPsiElementByCondition(this.myFile, this.myLine, this.myProject, PhpLineMethodBreakpointType.this.myAcceptPredicate, PhpLineMethodBreakpointType.this.myProhibitPredicate);
            assert (functionDeclarationElement != null);
            Function functionElement = (Function)functionDeclarationElement.getParent();
            if (functionElement instanceof PhpClassMember && (containingClass = ((PhpClassMember)functionElement).getContainingClass()) != null) {
                return new PhpMethodBreakpointProperties(containingClass.getFQN(), functionElement.getName());
            }
            return new PhpMethodBreakpointProperties("", functionElement.getFQN());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/debug/common/PhpLineMethodBreakpointType$PhpLineMethodBreakpointVariant", "getText"));
        }
    }
}

