/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.common;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.completion.PhpCompletionUtil;
import com.jetbrains.php.debug.PhpDebuggerEditorsProvider;
import com.jetbrains.php.debug.common.PhpExceptionBreakpointProperties;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpExceptionBreakpointType
extends XBreakpointType<XBreakpoint<PhpExceptionBreakpointProperties>, PhpExceptionBreakpointProperties> {
    private final XDebuggerEditorsProvider myEditorsProvider = new PhpDebuggerEditorsProvider();

    private PhpExceptionBreakpointType() {
        super("php-exception", PhpBundle.message("debug.php.exception.breakpoint.title", new Object[0]));
    }

    @Nullable
    public XDebuggerEditorsProvider getEditorsProvider(@NotNull XBreakpoint<PhpExceptionBreakpointProperties> breakpoint, @NotNull Project project) {
        if (breakpoint == null) {
            PhpExceptionBreakpointType.$$$reportNull$$$0(0);
        }
        if (project == null) {
            PhpExceptionBreakpointType.$$$reportNull$$$0(1);
        }
        return this.myEditorsProvider;
    }

    public String getDisplayText(XBreakpoint<PhpExceptionBreakpointProperties> breakpoint) {
        String name = ((PhpExceptionBreakpointProperties)breakpoint.getProperties()).getExceptionName();
        return StringUtil.notNullize((String)name, (String)PhpBundle.message("no.name", new Object[0]));
    }

    @Nullable
    public PhpExceptionBreakpointProperties createProperties() {
        return new PhpExceptionBreakpointProperties();
    }

    public boolean isAddBreakpointButtonVisible() {
        return true;
    }

    public XBreakpoint<PhpExceptionBreakpointProperties> addBreakpoint(Project project, JComponent parentComponent) {
        String name;
        PhpExceptionBreakpointDialog dialog = new PhpExceptionBreakpointDialog(project);
        if (dialog.showAndGet() && StringUtil.isNotEmpty((String)(name = dialog.getExceptionName()))) {
            XDebuggerManager.getInstance((Project)project).getBreakpointManager().addBreakpoint((XBreakpointType)this, (XBreakpointProperties)new PhpExceptionBreakpointProperties(name));
        }
        return null;
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_exception_breakpoint;
        if (icon == null) {
            PhpExceptionBreakpointType.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_disabled_exception_breakpoint;
        if (icon == null) {
            PhpExceptionBreakpointType.$$$reportNull$$$0(3);
        }
        return icon;
    }

    @NotNull
    public Icon getInactiveDependentIcon() {
        Icon icon = AllIcons.Debugger.Db_exception_breakpoint;
        if (icon == null) {
            PhpExceptionBreakpointType.$$$reportNull$$$0(4);
        }
        return icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/common/PhpExceptionBreakpointType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/common/PhpExceptionBreakpointType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledIcon";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInactiveDependentIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEditorsProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    private static class PhpExceptionBreakpointDialog
    extends DialogWrapper {
        private static final String WARNING = "Warning";
        private static final String NOTICE = "Notice";
        private static final String DEPRECATED = "Deprecated";
        private static final String EXCEPTION = "Exception";
        private static final Condition<PhpClass> IS_EXCEPTION = clazz -> {
            Ref isExceptionClassRef = new Ref((Object)false);
            PhpClassHierarchyUtils.processSuperClasses((PhpClass)clazz, (boolean)true, (boolean)true, aClass -> {
                if (PhpLangUtil.equalsClassNames(EXCEPTION, aClass.getNameCS())) {
                    isExceptionClassRef.set((Object)true);
                }
                return (Boolean)isExceptionClassRef.get() == false;
            });
            return (Boolean)isExceptionClassRef.get();
        };
        private final Project myProject;
        private EditorTextField myExceptionNameField;

        protected PhpExceptionBreakpointDialog(@Nullable Project project) {
            super(project, false);
            this.myProject = project;
            this.setTitle(PhpBundle.message("debug.php.exception.breakpoint.dialog.title", new Object[0]));
            this.init();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbConstraints = new GridBagConstraints();
            gbConstraints.insets = JBUI.insets((int)4);
            gbConstraints.anchor = 17;
            gbConstraints.fill = 1;
            gbConstraints.gridwidth = 1;
            gbConstraints.gridheight = 1;
            gbConstraints.weightx = 0.0;
            gbConstraints.weighty = 0.0;
            gbConstraints.gridx = 0;
            gbConstraints.gridy = 1;
            JLabel namePrompt = new JLabel(PhpBundle.message("debug.php.exception.breakpoint.exception.name", new Object[0]));
            panel.add((Component)namePrompt, gbConstraints);
            JPanel subPanel = new JPanel(new BorderLayout());
            this.myExceptionNameField = new EditorTextField("", this.myProject, (FileType)PhpFileType.INSTANCE);
            this.myExceptionNameField.setPreferredWidth(200);
            PhpCompletionUtil.installClassCompletion(this.myExceptionNameField, null, this.getDisposable(), IS_EXCEPTION, WARNING, NOTICE, DEPRECATED);
            JBLabel editKeyLabel = new JBLabel(PhpBundle.message("0.completion.shortcut", "class", PhpUiUtil.getShortcutTextByActionName("CodeCompletion")));
            subPanel.add((Component)this.myExceptionNameField, "Center");
            editKeyLabel.setComponentStyle(UIUtil.ComponentStyle.MINI);
            subPanel.add((Component)editKeyLabel, "South");
            gbConstraints.weightx = 1.0;
            gbConstraints.gridx = 1;
            gbConstraints.gridy = 1;
            panel.add((Component)subPanel, gbConstraints);
            return panel;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myExceptionNameField;
        }

        @Nullable
        public String getExceptionName() {
            return this.myExceptionNameField.getText();
        }
    }
}

