/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.common;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpAbstractBreakpointHandler<Properties extends XBreakpointProperties<Properties>, Breakpoint extends XBreakpoint<Properties>, DebugProcess extends PhpDebugProcess>
extends XBreakpointHandler<Breakpoint> {
    protected final Logger myLog;
    protected final DebugProcess myDebugProcess;
    protected final BidirectionalMap<Breakpoint, String> myRegisteredBreakpoints;
    protected final Set<Breakpoint> myUnregisteredBreakpoints;
    protected final Object myLock;

    protected PhpAbstractBreakpointHandler(@NotNull DebugProcess debugProcess, Class<? extends XBreakpointType<Breakpoint, ?>> breakPointTypeClass, Logger loggerInstance) {
        if (debugProcess == null) {
            PhpAbstractBreakpointHandler.$$$reportNull$$$0(0);
        }
        super(breakPointTypeClass);
        this.myRegisteredBreakpoints = new BidirectionalMap();
        this.myUnregisteredBreakpoints = new HashSet<Breakpoint>();
        this.myLock = new Object();
        this.myDebugProcess = debugProcess;
        this.myLog = loggerInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugProcess getDebugProcess() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myDebugProcess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterBreakpoint(@NotNull Breakpoint breakpoint, boolean temporary) {
        String breakpointId;
        if (breakpoint == null) {
            PhpAbstractBreakpointHandler.$$$reportNull$$$0(1);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myUnregisteredBreakpoints.remove(breakpoint)) {
                return;
            }
            if (!((PhpDebugProcess)this.myDebugProcess).isConnected()) {
                this.myUnregisteredBreakpoints.add(breakpoint);
                return;
            }
        }
        Object object2 = this.myLock;
        synchronized (object2) {
            breakpointId = (String)this.myRegisteredBreakpoints.get(breakpoint);
        }
        if (breakpointId == null) {
            return;
        }
        ((PhpDebugProcess)this.getDebugProcess()).unregisterBreakpoint(breakpointId, new PhpDebugProcess.UnregisterBreakpointCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregistered() {
                Object object = PhpAbstractBreakpointHandler.this.myLock;
                synchronized (object) {
                    PhpAbstractBreakpointHandler.this.myRegisteredBreakpoints.removeValue((Object)breakpointId);
                }
            }

            @Override
            public void errorOccurred(@Nullable String errorMessage) {
                PhpAbstractBreakpointHandler.this.myLog.warn("Can't unregister breakpoint: " + errorMessage);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object object = this.myLock;
        synchronized (object) {
            this.myUnregisteredBreakpoints.addAll(this.myRegisteredBreakpoints.keySet());
            this.myRegisteredBreakpoints.clear();
        }
    }

    public void registerAllUnregisterBreakpoints() {
        ArrayList<Breakpoint> toRegister = new ArrayList<Breakpoint>(this.myUnregisteredBreakpoints);
        for (XBreakpoint breakpoint : toRegister) {
            this.registerBreakpoint(breakpoint);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/debug/common/PhpAbstractBreakpointHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterBreakpoint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

