/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.library;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurable;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.ui.PhpUiUtil;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpEmbeddedStubsNotificationProvider
implements EditorNotificationProvider,
DumbAware {
    private static final String DO_NOT_SHOW_PROPERTY = "php.embedded.stubs.notification.provider.do.not.show.again.property";

    @Nullable
    public @Nullable Function<? super @NotNull FileEditor, ? extends @Nullable JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            PhpEmbeddedStubsNotificationProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            PhpEmbeddedStubsNotificationProvider.$$$reportNull$$$0(1);
        }
        if (PropertiesComponent.getInstance().isTrueValue(DO_NOT_SHOW_PROPERTY)) {
            return null;
        }
        if (!FileTypeRegistry.getInstance().isFileOfType(file, (FileType)PhpFileType.INSTANCE) || !PhpEmbeddedStubsNotificationProvider.isStubsFile(file)) {
            return null;
        }
        return fileEditor -> {
            if (fileEditor instanceof TextEditor) {
                EditorNotificationPanel panel = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Info);
                panel.setText(PhpBundle.message("php.embedded.stubs.notification.provider.notification", new Object[0]));
                panel.createActionLabel(PhpBundle.message("php.embedded.stubs.notification.provider.clone", new Object[0]), () -> BrowserUtil.browse((String)"https://github.com/JetBrains/phpstorm-stubs/"));
                panel.createActionLabel(PhpBundle.message("php.embedded.stubs.notification.provider.provide", new Object[0]), () -> {
                    PhpProjectConfigurable configurable = new PhpProjectConfigurable(project);
                    configurable.openPhpRuntimeTab(true);
                    PhpUiUtil.editConfigurable(project, (Configurable)configurable);
                });
                panel.createActionLabel(PhpBundle.message("php.embedded.stubs.notification.provider.do.not.show.again", new Object[0]), () -> {
                    PropertiesComponent.getInstance().setValue(DO_NOT_SHOW_PROPERTY, "true");
                    EditorNotifications.getInstance((Project)project).updateAllNotifications();
                });
                return panel;
            }
            return null;
        };
    }

    public static boolean isStubsFile(@Nullable VirtualFile file) {
        return file != null && "stubs".equals(PhpEmbeddedStubsNotificationProvider.getStubsRootName(file)) && PhpEmbeddedStubsNotificationProvider.isEmbeddedPhpRuntime(file);
    }

    private static boolean isEmbeddedPhpRuntime(@NotNull VirtualFile file) {
        if (file == null) {
            PhpEmbeddedStubsNotificationProvider.$$$reportNull$$$0(2);
        }
        String path = file.getPath();
        if (ApplicationManager.getApplication().isInternal() && path.contains("/out/classes/production/intellij.php.impl/stubs/")) {
            return true;
        }
        return file.getFileSystem() instanceof JarFileSystem && path.contains("/php.jar!/stubs/");
    }

    @Nullable
    private static String getStubsRootName(@NotNull VirtualFile file) {
        VirtualFile root;
        VirtualFile parent;
        if (file == null) {
            PhpEmbeddedStubsNotificationProvider.$$$reportNull$$$0(3);
        }
        if ((parent = file.getParent()) != null && (root = parent.getParent()) != null) {
            return root.getName();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/config/library/PhpEmbeddedStubsNotificationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectNotificationData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isEmbeddedPhpRuntime";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getStubsRootName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

