/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.interpreters.herd;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.php.config.interpreters.PhpLocalInterpreterComponent;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\r\u001a\u00020\u0007H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/php/config/interpreters/herd/PhpHerdMainLocalInterpreterComponent;", "Lcom/jetbrains/php/config/interpreters/PhpLocalInterpreterComponent;", "project", "Lcom/intellij/openapi/project/Project;", "data", "Lcom/jetbrains/php/config/interpreters/PhpSdkAdditionalData;", "interpreterName", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/php/config/interpreters/PhpSdkAdditionalData;Ljava/lang/String;)V", "resetPhpInfo", "", "updateDebuggerExtension", "phpShortVersion", "getDebuggerRegexAndReplacement", "Lkotlin/Pair;", "Lkotlin/text/Regex;", "intellij.php.impl"})
public final class PhpHerdMainLocalInterpreterComponent
extends PhpLocalInterpreterComponent {
    public PhpHerdMainLocalInterpreterComponent(@NotNull Project project, @NotNull PhpSdkAdditionalData data, @NotNull String interpreterName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)interpreterName, (String)"interpreterName");
        super(project, data, interpreterName);
    }

    @Override
    protected void resetPhpInfo() {
        super.resetPhpInfo();
        ApplicationManager.getApplication().invokeAndWait(() -> PhpHerdMainLocalInterpreterComponent.resetPhpInfo$lambda$0(this));
    }

    private final void updateDebuggerExtension(String phpShortVersion) {
        Pair<Regex, String> pair = this.getDebuggerRegexAndReplacement(phpShortVersion);
        Regex debuggerRegex = (Regex)pair.component1();
        String debuggerReplacement = (String)pair.component2();
        String string = this.myDebuggerExtensionTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.myDebuggerExtensionTextField.setText(debuggerRegex.replace((CharSequence)string, debuggerReplacement));
    }

    private final Pair<Regex, String> getDebuggerRegexAndReplacement(String phpShortVersion) {
        Pair pair;
        if (SystemInfo.isWindows) {
            Regex regex = new Regex("xdebug-\\d\\.\\d");
            String replacement = "xdebug-" + StringsKt.substringBeforeLast$default((String)phpShortVersion, (String)".", null, (int)2, null);
            pair = TuplesKt.to((Object)regex, (Object)replacement);
        } else {
            Regex regex = new Regex("xdebug-\\d{2}");
            String[] stringArray = new String[]{"."};
            String replacement = "xdebug-" + CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast((List)StringsKt.split$default((CharSequence)phpShortVersion, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (int)1), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            pair = TuplesKt.to((Object)regex, (Object)replacement);
        }
        return pair;
    }

    private static final void resetPhpInfo$lambda$0(PhpHerdMainLocalInterpreterComponent this$0) {
        PhpInfo phpInfo = this$0.myLastLoadedInfo;
        if (phpInfo != null) {
            String string = phpInfo.getShortVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getShortVersion(...)");
            this$0.updateDebuggerExtension(string);
        }
    }
}

