/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.interpreters;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.PlatformUtils;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.interpreters.PhpSdkType;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpInterpreterConfigurationActivity
implements StartupActivity {
    public void runActivity(@NotNull Project project) {
        if (project == null) {
            PhpInterpreterConfigurationActivity.$$$reportNull$$$0(0);
        }
        if (PlatformUtils.isFleetBackend()) {
            return;
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        PhpInterpreterConfigurationActivity.findAndConfigureInterpreters(project, true);
    }

    public static PhpInterpreter findAndConfigureInterpreters(@NotNull Project project, boolean updatePhpInfoCache) {
        if (project == null) {
            PhpInterpreterConfigurationActivity.$$$reportNull$$$0(1);
        }
        PhpInterpretersManagerImpl interpretersManager = PhpInterpretersManagerImpl.getInstance(project);
        PhpLanguageLevel level = PhpProjectConfigurationFacade.getInstance(project).getProjectSharedConfiguration().getLanguageLevel();
        if (!interpretersManager.getInterpreters().isEmpty()) {
            return PhpInterpreterConfigurationActivity.chooseConfiguredInterpreter(project, level, updatePhpInfoCache);
        }
        Set<PhpSdkType.PhpInterpreterPath> phpInterpreters = PhpSdkType.findInstalledPhpBinaries();
        if (!phpInterpreters.isEmpty()) {
            for (PhpSdkType.PhpInterpreterPath interpreterPath : phpInterpreters) {
                PhpInterpreter phpInterpreter = interpreterPath.createPhpInterpreter(project);
                interpretersManager.addInterpreter(phpInterpreter);
            }
            return PhpInterpreterConfigurationActivity.chooseConfiguredInterpreter(project, level, updatePhpInfoCache);
        }
        return null;
    }

    public static PhpInterpreter chooseConfiguredInterpreter(@NotNull Project project, @NotNull PhpLanguageLevel level, boolean updateCache) {
        if (project == null) {
            PhpInterpreterConfigurationActivity.$$$reportNull$$$0(2);
        }
        if (level == null) {
            PhpInterpreterConfigurationActivity.$$$reportNull$$$0(3);
        }
        List<PhpInterpreter> interpreters = PhpInterpretersManagerImpl.getInstance(project).getInterpreters();
        for (PhpInterpreter interpreter : interpreters) {
            PhpLanguageLevel parse;
            PhpInterpretersPhpInfoCacheImpl infoCache = PhpInterpretersPhpInfoCacheImpl.getInstance(project);
            PhpInfo info = infoCache.getPhpInfo(interpreter.getName());
            if (info == null && updateCache) {
                ProgressManager.checkCanceled();
                PhpInterpretersPhpInfoCacheImpl.getInstance(project).updateAnGet(project, interpreter.getName(), null);
            }
            if (info == null || (parse = PhpInterpreterConfigurationActivity.parse(info)) == null || !parse.isAtLeast(level)) continue;
            PhpProjectConfigurationFacade.getInstance(project).updateSelectedInterpreterName(null, interpreter.getName());
            return interpreter;
        }
        PhpInterpreter phpInterpreter = interpreters.get(0);
        PhpProjectConfigurationFacade.getInstance(project).updateSelectedInterpreterName(null, phpInterpreter.getName());
        return phpInterpreter;
    }

    @Nullable
    public static PhpLanguageLevel parse(@NotNull PhpInfo phpInfo) {
        if (phpInfo == null) {
            PhpInterpreterConfigurationActivity.$$$reportNull$$$0(4);
        }
        return PhpLanguageLevel.parse((String)phpInfo.getVersion());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpInfo";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpInterpreterConfigurationActivity";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findAndConfigureInterpreters";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "chooseConfiguredInterpreter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "parse";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

