/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.interpreters;

import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpConfigurationOptionData;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpSdkType;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInterpreter
extends ProjectJdkImpl
implements Comparable<PhpInterpreter> {
    private String myId = PhpInterpreter.getNextId();
    private String myName = "";
    private String myHomePath = "";
    private PhpSdkAdditionalData myData;
    private boolean myAuto;
    private boolean myIsProjectLevel;

    public PhpInterpreter() {
        super("", (SdkTypeId)PhpSdkType.getInstance());
        this.setPhpSdkAdditionalData(new PhpSdkAdditionalData());
    }

    PhpInterpreter(boolean auto) {
        super("", (SdkTypeId)PhpSdkType.getInstance());
        this.setPhpSdkAdditionalData(new PhpSdkAdditionalData());
        this.myAuto = auto;
    }

    public String getCustomIni() {
        return this.getPhpSdkAdditionalData().getCustomIniPath();
    }

    public void setCustomIni(@Nullable String customIni) {
        this.getPhpSdkAdditionalData().setCustomIniPath(customIni);
    }

    public boolean isAuto() {
        return this.myAuto;
    }

    public void setAuto(boolean auto) {
        this.myAuto = auto;
    }

    @NotNull
    @NlsSafe
    public static String getNextId() {
        String string = UUID.randomUUID().toString();
        if (string == null) {
            PhpInterpreter.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getId() {
        if (this.myId == null) {
            this.setId(PhpInterpreter.getNextId());
        }
        String string = this.myId;
        if (string == null) {
            PhpInterpreter.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void setId(String id) {
        this.myId = id;
        this.getPhpSdkAdditionalData().setInterpreterId(this.myId);
    }

    @NotNull
    @NlsSafe
    public String getName() {
        String string = this.myName;
        if (string == null) {
            PhpInterpreter.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            PhpInterpreter.$$$reportNull$$$0(3);
        }
        this.myName = name;
    }

    public boolean isProjectLevel() {
        return this.myIsProjectLevel;
    }

    public void setIsProjectLevel(boolean isProjectLevel) {
        this.myIsProjectLevel = isProjectLevel;
    }

    @Nullable
    public String getHomePath() {
        return this.myHomePath;
    }

    public void setHomePath(String path) {
        this.myHomePath = path;
    }

    @NotNull
    public PhpSdkAdditionalData getPhpSdkAdditionalData() {
        PhpSdkAdditionalData phpSdkAdditionalData = this.myData;
        if (phpSdkAdditionalData == null) {
            PhpInterpreter.$$$reportNull$$$0(4);
        }
        return phpSdkAdditionalData;
    }

    public void setPhpSdkAdditionalData(@NotNull PhpSdkAdditionalData data) {
        if (data == null) {
            PhpInterpreter.$$$reportNull$$$0(5);
        }
        this.myData = data;
        this.myData.setInterpreterId(this.getId());
    }

    @Nullable
    @NlsSafe
    public String getPathToPhpExecutable() {
        String homePath = this.getHomePath();
        String exe = this.getPhpSdkAdditionalData().getPathToExecutable(homePath);
        return exe != null && !exe.isEmpty() ? exe : homePath;
    }

    @Nullable
    @NlsSafe
    public String getDebuggerId() {
        return this.getPhpSdkAdditionalData().getDebuggerId();
    }

    public void setDebuggerId(String debuggerId) {
        this.getPhpSdkAdditionalData().setDebuggerId(debuggerId);
    }

    @Nullable
    @NlsSafe
    public String getDebuggerExtension() {
        return this.getPhpSdkAdditionalData().getDebuggerExtension();
    }

    public void setDebuggerExtension(@Nullable String debuggerExtension) {
        this.getPhpSdkAdditionalData().setDebuggerExtension(debuggerExtension);
    }

    @NotNull
    public List<PhpConfigurationOptionData> getConfigurationOptions() {
        List<PhpConfigurationOptionData> list = this.getPhpSdkAdditionalData().getConfigurationOptions();
        if (list == null) {
            PhpInterpreter.$$$reportNull$$$0(6);
        }
        return list;
    }

    public void setConfigurationOptions(@NotNull List<PhpConfigurationOptionData> configurationOptions) {
        if (configurationOptions == null) {
            PhpInterpreter.$$$reportNull$$$0(7);
        }
        this.getPhpSdkAdditionalData().setConfigurationOptions(configurationOptions);
    }

    public boolean isRemote() {
        return this.getPhpSdkAdditionalData() instanceof RemoteSdkAdditionalData;
    }

    @NotNull
    public PhpInterpreter clone() {
        PhpInterpreter interpreter = new PhpInterpreter();
        interpreter.setId(this.getId());
        interpreter.setAuto(this.isAuto());
        interpreter.setIsProjectLevel(this.isProjectLevel());
        interpreter.setName(this.getName());
        interpreter.setHomePath(this.getHomePath());
        interpreter.setPhpSdkAdditionalData(this.getPhpSdkAdditionalData().copy());
        PhpInterpreter phpInterpreter = interpreter;
        if (phpInterpreter == null) {
            PhpInterpreter.$$$reportNull$$$0(8);
        }
        return phpInterpreter;
    }

    @Override
    public int compareTo(@NotNull PhpInterpreter o) {
        if (o == null) {
            PhpInterpreter.$$$reportNull$$$0(9);
        }
        return this.getName().compareTo(o.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 5, 7, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/interpreters/PhpInterpreter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationOptions";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpInterpreter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhpSdkAdditionalData";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationOptions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setPhpSdkAdditionalData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setConfigurationOptions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 5, 7, 9 -> new IllegalArgumentException(string);
        };
    }
}

