/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.interpreters;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.util.EventDispatcher;
import com.jetbrains.php.config.commandLine.PhpCommandLinePathProcessor;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.interpreters.PhpConfigurationOptionData;
import com.jetbrains.php.config.interpreters.PhpEditConfigurationOptionsDialog;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.run.PhpConfigurationOption;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class PhpConfigurationOptionsComponent
extends TextFieldWithBrowseButton
implements UserActivityProviderComponent,
Disposable {
    private final EventDispatcher<ChangeListener> myEventDispatcher = EventDispatcher.create(ChangeListener.class);
    private List<PhpConfigurationOptionData> myConfigurationOptions = new ArrayList<PhpConfigurationOptionData>();

    public PhpConfigurationOptionsComponent() {
        this.setEditable(false);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhpEditConfigurationOptionsDialog editor = PhpEditConfigurationOptionsDialog.showDialog((JComponent)((Object)PhpConfigurationOptionsComponent.this), new ArrayList<PhpConfigurationOptionData>(PhpConfigurationOptionsComponent.this.getConfigurationOptionsData()));
                if (editor.isOK()) {
                    PhpConfigurationOptionsComponent.this.setConfigurationOptions(editor.getConfigurationOptions());
                }
            }
        });
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PhpCommandSettings command = new PhpCommandSettings("", PhpCommandLinePathProcessor.LOCAL, null);
                command.addConfigurationOptions(PhpConfigurationOption.convert(PhpConfigurationOptionsComponent.this.getConfigurationOptionsData()));
                GeneralCommandLine generalCommandLine = command.createGeneralCommandLine();
                ParametersList parametersList = generalCommandLine.getParametersList();
                @NlsSafe String parametersString = parametersList.getParametersString();
                PhpConfigurationOptionsComponent.this.setText(parametersString);
            }
        });
    }

    public void addChangeListener(@NotNull ChangeListener changeListener) {
        if (changeListener == null) {
            PhpConfigurationOptionsComponent.$$$reportNull$$$0(0);
        }
        this.myEventDispatcher.addListener((EventListener)changeListener, (Disposable)this);
    }

    public void removeChangeListener(@NotNull ChangeListener changeListener) {
        if (changeListener == null) {
            PhpConfigurationOptionsComponent.$$$reportNull$$$0(1);
        }
        this.myEventDispatcher.removeListener((EventListener)changeListener);
    }

    public void dispose() {
    }

    @NotNull
    public List<PhpConfigurationOptionData> getConfigurationOptionsData() {
        List<PhpConfigurationOptionData> list = PhpSdkAdditionalData.cloneConfigurationOptions(this.myConfigurationOptions);
        if (list == null) {
            PhpConfigurationOptionsComponent.$$$reportNull$$$0(2);
        }
        return list;
    }

    public List<PhpConfigurationOption> getConfigurationOptions() {
        return PhpConfigurationOption.convert(this.getConfigurationOptionsData());
    }

    public void setConfigurationOptions(@NotNull List<PhpConfigurationOptionData> configurationOptions) {
        if (configurationOptions == null) {
            PhpConfigurationOptionsComponent.$$$reportNull$$$0(3);
        }
        this.myConfigurationOptions = PhpSdkAdditionalData.cloneConfigurationOptions(configurationOptions);
        ((ChangeListener)this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent((Object)this));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/interpreters/PhpConfigurationOptionsComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpConfigurationOptionsComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationOptionsData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeChangeListener";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setConfigurationOptions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

