/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.commandLine;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurable;
import com.jetbrains.php.config.commandLine.PhpCommandLineCommand;
import com.jetbrains.php.config.commandLine.PhpCommandLinePathProcessor;
import com.jetbrains.php.config.commandLine.PhpCommandSettingsBuilder;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.xdebug.options.XdebugConfigurationOptionsManager;
import com.jetbrains.php.debug.xdebug.options.XdebugConfigurationOptionsProvider;
import com.jetbrains.php.run.PhpCommandLineSettings;
import com.jetbrains.php.run.PhpConfigurationOption;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import java.util.List;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCommandSettings {
    private static final NotNullFunction<String, String> ESCAPER = StringUtil.escaper((boolean)true, null);
    private static final PathMappingSettings.PathMapping[] EMPTY_MAPPINGS = new PathMappingSettings.PathMapping[0];
    private final List<String> myInvalidPathArguments;
    private final PhpCommandLineCommand myCommand;
    @NotNull
    private final PhpCommandLinePathProcessor myPathProcessor;
    @Nullable
    private final PhpSdkAdditionalData myAdditionalData;
    private PathMappingSettings.PathMapping myAdditionalMappings;

    public PhpCommandSettings(@NotNull String binary, @NotNull PhpCommandLinePathProcessor pathProcessor, @Nullable PhpSdkAdditionalData additionalData) {
        if (binary == null) {
            PhpCommandSettings.$$$reportNull$$$0(0);
        }
        if (pathProcessor == null) {
            PhpCommandSettings.$$$reportNull$$$0(1);
        }
        this.myAdditionalMappings = null;
        this.myCommand = new PhpCommandLineCommand(binary);
        this.myPathProcessor = pathProcessor;
        this.myAdditionalData = additionalData;
        this.myInvalidPathArguments = new SmartList();
    }

    @NotNull
    public static PhpCommandSettings createHelperCommand(@NotNull Project project, @NotNull String pathToBinary, @NotNull PhpCommandLinePathProcessor pathProcessor, @Nullable PhpSdkAdditionalData data) {
        if (project == null) {
            PhpCommandSettings.$$$reportNull$$$0(2);
        }
        if (pathToBinary == null) {
            PhpCommandSettings.$$$reportNull$$$0(3);
        }
        if (pathProcessor == null) {
            PhpCommandSettings.$$$reportNull$$$0(4);
        }
        PhpCommandSettings command = PhpCommandSettingsBuilder.create(pathToBinary, pathProcessor, data);
        PhpCommandSettings.setDefaultWorkingDirectory(project, pathToBinary, command, data instanceof RemoteSdkAdditionalData);
        PhpCommandSettings phpCommandSettings = command;
        if (phpCommandSettings == null) {
            PhpCommandSettings.$$$reportNull$$$0(5);
        }
        return phpCommandSettings;
    }

    @NotNull
    public static PhpCommandSettings createHelperCommand(@NotNull Project project, @NotNull String pathToBinary, boolean isRemote, @Nullable PhpInterpreter interpreter) {
        if (project == null) {
            PhpCommandSettings.$$$reportNull$$$0(6);
        }
        if (pathToBinary == null) {
            PhpCommandSettings.$$$reportNull$$$0(7);
        }
        XdebugConfigurationOptionsProvider builder2 = XdebugConfigurationOptionsManager.getConfigurationOptionsProvider(project, interpreter);
        PhpCommandSettings command = new PhpCommandSettings(pathToBinary, isRemote ? PhpCommandLinePathProcessor.IDENTICAL : PhpCommandLinePathProcessor.LOCAL, null);
        List<PhpConfigurationOption> configurations = builder2.disable().createXdebugConfigurations();
        configurations.forEach(configuration -> command.addOption(configuration.getText()));
        PhpCommandSettings.setDefaultWorkingDirectory(project, pathToBinary, command, isRemote);
        PhpCommandSettings phpCommandSettings = command;
        if (phpCommandSettings == null) {
            PhpCommandSettings.$$$reportNull$$$0(8);
        }
        return phpCommandSettings;
    }

    private static void setDefaultWorkingDirectory(@NotNull Project project, @NotNull String pathToBinary, @NotNull PhpCommandSettings command, boolean isRemote) {
        if (project == null) {
            PhpCommandSettings.$$$reportNull$$$0(9);
        }
        if (pathToBinary == null) {
            PhpCommandSettings.$$$reportNull$$$0(10);
        }
        if (command == null) {
            PhpCommandSettings.$$$reportNull$$$0(11);
        }
        if (!isRemote) {
            String workingDir;
            VirtualFile file = ProjectUtil.guessProjectDir((Project)project);
            String string = workingDir = file != null ? file.getPath() : PathUtil.getParentPath((String)pathToBinary);
            if (StringUtil.isNotEmpty((String)workingDir)) {
                command.setWorkingDir(PathUtil.toSystemDependentName((String)workingDir));
            }
        }
    }

    public void setScript(@NotNull String scriptPath) {
        if (scriptPath == null) {
            PhpCommandSettings.$$$reportNull$$$0(12);
        }
        this.setScript(scriptPath, true);
    }

    public void setScript(@NotNull String scriptPath, boolean processScriptPath) {
        if (scriptPath == null) {
            PhpCommandSettings.$$$reportNull$$$0(13);
        }
        String processedPath = processScriptPath ? this.processPathParameter(scriptPath) : scriptPath;
        this.myCommand.setScript(processedPath);
    }

    @NotNull
    private String processPathParameter(@NotNull String path) {
        if (path == null) {
            PhpCommandSettings.$$$reportNull$$$0(14);
        }
        if (!this.myPathProcessor.canProcess(path)) {
            this.myInvalidPathArguments.add(path);
        }
        String string = this.myPathProcessor.process(path);
        if (string == null) {
            PhpCommandSettings.$$$reportNull$$$0(15);
        }
        return string;
    }

    public void addConfigurationOptions(@NotNull List<PhpConfigurationOption> options) {
        if (options == null) {
            PhpCommandSettings.$$$reportNull$$$0(16);
        }
        this.myCommand.addConfigurationOptions(options);
    }

    public void importCommandLineSettings(@NotNull PhpCommandLineSettings settings, @Nullable String defaultWorkingDir) {
        if (settings == null) {
            PhpCommandSettings.$$$reportNull$$$0(17);
        }
        this.myCommand.importCommandLineSettings(settings, defaultWorkingDir);
    }

    public void setWorkingDir(@Nullable String workingDirectory) {
        this.myCommand.setWorkingDirectory(workingDirectory);
    }

    public void setCustomIni(@Nullable String customIni) {
        this.myCommand.setCustomIniPath(customIni);
    }

    public void setAdditionalMapping(@NotNull PathMappingSettings.PathMapping mapping) {
        if (mapping == null) {
            PhpCommandSettings.$$$reportNull$$$0(18);
        }
        this.myAdditionalMappings = mapping;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    PathMappingSettings.PathMapping @NotNull [] getAdditionalMappings() {
        PathMappingSettings.PathMapping[] pathMappingArray;
        if (this.myAdditionalMappings == null) {
            pathMappingArray = EMPTY_MAPPINGS;
        } else {
            PathMappingSettings.PathMapping[] pathMappingArray2 = new PathMappingSettings.PathMapping[1];
            pathMappingArray = pathMappingArray2;
            pathMappingArray2[0] = this.myAdditionalMappings;
        }
        if (pathMappingArray == null) {
            PhpCommandSettings.$$$reportNull$$$0(19);
        }
        return pathMappingArray;
    }

    public void addEnvs(@NotNull Map<String, String> env) {
        if (env == null) {
            PhpCommandSettings.$$$reportNull$$$0(20);
        }
        this.myCommand.addEnvs(env);
    }

    public void addEnv(@NotNull String name, @NotNull String value) {
        if (name == null) {
            PhpCommandSettings.$$$reportNull$$$0(21);
        }
        if (value == null) {
            PhpCommandSettings.$$$reportNull$$$0(22);
        }
        this.myCommand.addEnv(name, value);
    }

    public void addArguments(@NotNull List<String> arguments) {
        if (arguments == null) {
            PhpCommandSettings.$$$reportNull$$$0(23);
        }
        this.myCommand.addArguments(arguments);
    }

    @NotNull
    public List<String> getArguments() {
        List<String> list = this.myCommand.getArgs();
        if (list == null) {
            PhpCommandSettings.$$$reportNull$$$0(24);
        }
        return list;
    }

    public void addArgument(@NotNull String arg) {
        if (arg == null) {
            PhpCommandSettings.$$$reportNull$$$0(25);
        }
        this.myCommand.addArgument(arg);
    }

    public void addClassFqnArgument(@NotNull String arg) {
        if (arg == null) {
            PhpCommandSettings.$$$reportNull$$$0(26);
        }
        this.myCommand.addArgument(this.escape(arg));
    }

    public void addPathArgument(@NotNull String arg) {
        if (arg == null) {
            PhpCommandSettings.$$$reportNull$$$0(27);
        }
        this.myCommand.addArgument(this.processPathParameter(arg));
    }

    public void addPathArgument(@NotNull String arg, @NotNull String suffix) {
        if (arg == null) {
            PhpCommandSettings.$$$reportNull$$$0(28);
        }
        if (suffix == null) {
            PhpCommandSettings.$$$reportNull$$$0(29);
        }
        this.myCommand.addArgument(this.processPathParameter(arg) + suffix);
    }

    public void addRelativePathArgument(@NotNull String arg, @NotNull String baseDir) {
        if (arg == null) {
            PhpCommandSettings.$$$reportNull$$$0(30);
        }
        if (baseDir == null) {
            PhpCommandSettings.$$$reportNull$$$0(31);
        }
        this.addRelativePathArgument(arg, baseDir, "");
    }

    public void addRelativePathArgument(@NotNull String arg, @NotNull String baseDir, @NotNull String suffix) {
        if (arg == null) {
            PhpCommandSettings.$$$reportNull$$$0(32);
        }
        if (baseDir == null) {
            PhpCommandSettings.$$$reportNull$$$0(33);
        }
        if (suffix == null) {
            PhpCommandSettings.$$$reportNull$$$0(34);
        }
        String path = this.processPathParameter(arg);
        String base = this.myPathProcessor.process(baseDir);
        if (FileUtil.isAncestor((String)base, (String)path, (boolean)false)) {
            String relative = FileUtil.getRelativePath((String)base, (String)path, (char)(path.length() > 1 && path.charAt(1) == ':' ? 92 : 47));
            if (StringUtil.isNotEmpty((String)relative)) {
                this.myCommand.addArgument(relative + suffix);
            } else {
                this.myCommand.addArgument(path + suffix);
            }
        }
    }

    public PhpCommandSettings addOption(@NotNull String option) {
        if (option == null) {
            PhpCommandSettings.$$$reportNull$$$0(35);
        }
        this.myCommand.addOption(option);
        return this;
    }

    public PhpCommandSettings addPathOption(@NotNull String option) {
        if (option == null) {
            PhpCommandSettings.$$$reportNull$$$0(36);
        }
        this.myCommand.addOption(this.processPathParameter(option));
        return this;
    }

    public boolean isRemote() {
        return this.myAdditionalData instanceof RemoteSdkAdditionalData;
    }

    @Nullable
    public PhpSdkAdditionalData getAdditionalData() {
        return this.myAdditionalData;
    }

    @NotNull
    public PhpCommandLinePathProcessor getPathProcessor() {
        PhpCommandLinePathProcessor phpCommandLinePathProcessor = this.myPathProcessor;
        if (phpCommandLinePathProcessor == null) {
            PhpCommandSettings.$$$reportNull$$$0(37);
        }
        return phpCommandLinePathProcessor;
    }

    public String getWorkingDirectory() {
        return this.myCommand.getWorkingDirectory();
    }

    public GeneralCommandLine createGeneralCommandLine() {
        return this.createGeneralCommandLine(false);
    }

    public GeneralCommandLine createGeneralCommandLine(boolean withPty) {
        GeneralCommandLine commandLine;
        if (withPty) {
            if (!SystemInfo.isWindows) {
                commandLine = new PtyCommandLine().withInitialColumns(2500).withConsoleMode(false);
            } else {
                commandLine = new GeneralCommandLine();
                commandLine.getEnvironment().putIfAbsent("TERM", "xterm");
            }
        } else {
            commandLine = new GeneralCommandLine();
        }
        commandLine.setExePath(this.myCommand.getPhpBinary());
        String workingDirectory = this.myCommand.getWorkingDirectory();
        if (workingDirectory != null) {
            commandLine.withWorkDirectory(this.myPathProcessor.process(workingDirectory));
        }
        if (this.myCommand.getCustomIniPath() != null) {
            commandLine.addParameters(new String[]{"-c", this.myCommand.getCustomIniPath()});
        }
        for (String option : this.myCommand.getOptions()) {
            commandLine.addParameter(option);
        }
        String scriptPath = this.myCommand.getScriptPath();
        if (scriptPath != null) {
            commandLine.addParameter(scriptPath);
        }
        commandLine.addParameters(this.myCommand.getArgs());
        commandLine.withEnvironment(this.myCommand.getEnvs());
        commandLine.withParentEnvironmentType(this.myCommand.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        return commandLine;
    }

    protected boolean bySsh() {
        PhpSdkAdditionalData data = this.getAdditionalData();
        PhpRemoteInterpreterManager remoteInterpreterManager = PhpRemoteInterpreterManager.getInstance();
        return data != null && remoteInterpreterManager != null && remoteInterpreterManager.producesSshSdkCredentials(data);
    }

    protected String escape(@NotNull String path) {
        if (path == null) {
            PhpCommandSettings.$$$reportNull$$$0(38);
        }
        PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
        PhpSdkAdditionalData data = this.getAdditionalData();
        if (data != null && manager != null) {
            return manager.escape(data, path);
        }
        return (String)ESCAPER.fun((Object)path);
    }

    public boolean hasInvalidPathArguments() {
        return this.isRemote() && !this.myInvalidPathArguments.isEmpty();
    }

    public void validateAndNotify(@NotNull Project project) {
        if (project == null) {
            PhpCommandSettings.$$$reportNull$$$0(39);
        }
        if (this.hasInvalidPathArguments()) {
            assert (this.myAdditionalData != null);
            PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
            StringBuilder source = new StringBuilder();
            if (manager != null) {
                source.append(manager.getPathMappingsSource(this.myAdditionalData));
            }
            String phpSection = PhpBundle.message("remote.interpreter.path.mappings.validation.php.section", new Object[0]);
            if (!source.isEmpty()) {
                source.append(" or at ");
            }
            source.append(phpSection);
            String title = PhpBundle.message("remote.interpreter.path.mappings.validation.title", new Object[0]);
            String message = PhpBundle.message("remote.interpreter.path.mappings.validation.message", source);
            PhpDebugUtil.getNotificationGroup().createNotification(title, message, NotificationType.WARNING).setListener((notification, event) -> {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && "php_mappings".equals(event.getDescription())) {
                    PhpProjectConfigurable.createFix(project).run();
                }
            }).notify(project);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8, 15, 19, 24, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binary";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathProcessor";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToBinary";
                break;
            }
            case 5: 
            case 8: 
            case 15: 
            case 19: 
            case 24: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/commandLine/PhpCommandSettings";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptPath";
                break;
            }
            case 14: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/commandLine/PhpCommandSettings";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createHelperCommand";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "processPathParameter";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalMappings";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createHelperCommand";
                break;
            }
            case 5: 
            case 8: 
            case 15: 
            case 19: 
            case 24: 
            case 37: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultWorkingDirectory";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setScript";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processPathParameter";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addConfigurationOptions";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "importCommandLineSettings";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalMapping";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addEnvs";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addEnv";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addArguments";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addArgument";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addClassFqnArgument";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addPathArgument";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addRelativePathArgument";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addOption";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addPathOption";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "escape";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "validateAndNotify";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8, 15, 19, 24, 37 -> new IllegalStateException(string);
        };
    }
}

