/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.config.PhpExtensionStatisticsManager;
import com.jetbrains.php.config.PhpExtensionUsageStatistics;
import com.jetbrains.php.config.PhpExtensionsHolder;
import com.jetbrains.php.config.library.PhpRuntimeLibraryRootsProvider;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpExtensionsManager
implements PhpExtensionStatisticsManager,
PhpExtensionsHolder {
    private static final PhpExtensionsManager INSTANCE = new PhpExtensionsManager();
    private static final MultiMap<ExtensionCategory, String> EXTENSIONS_HIGH_PRIORITY = new MultiMap();
    private static final MultiMap<ExtensionCategory, String> EXTENSIONS_LOW_PRIORITY = new MultiMap();
    private static final Collection<String> HIGH_PRIORITY_EXTENSIONS_VALUES;
    private static Map<String, PhpExtensionUsageStatistics> ourExtensionsStatistics;

    private PhpExtensionsManager() {
    }

    public static PhpExtensionsHolder getHolderInstance() {
        return INSTANCE;
    }

    public static PhpExtensionStatisticsManager getStatisticsManagerInstance() {
        return INSTANCE;
    }

    @Override
    @Nullable
    public PhpExtensionStatisticsManager.Priority getPriority(@NotNull PhpNamedElement namedElement) {
        String name;
        if (namedElement == null) {
            PhpExtensionsManager.$$$reportNull$$$0(0);
        }
        if ((name = PhpExtensionsManager.getExtensionName(namedElement)) == null) {
            return null;
        }
        return HIGH_PRIORITY_EXTENSIONS_VALUES.contains(name) ? PhpExtensionStatisticsManager.Priority.HIGH : PhpExtensionStatisticsManager.Priority.LOW;
    }

    @Override
    @Nullable
    public PhpExtensionUsageStatistics getUsageStatistics(@NotNull PhpNamedElement namedElement) {
        String name;
        if (namedElement == null) {
            PhpExtensionsManager.$$$reportNull$$$0(1);
        }
        if ((name = PhpExtensionsManager.getExtensionName(namedElement)) == null) {
            return null;
        }
        return PhpExtensionsManager.getExtensionStatistics().get(name);
    }

    @NotNull
    private static synchronized Map<String, PhpExtensionUsageStatistics> getExtensionStatistics() {
        if (ourExtensionsStatistics == null) {
            ourExtensionsStatistics = PhpExtensionUsageStatistics.loadStatistics();
        }
        Map<String, PhpExtensionUsageStatistics> map = ourExtensionsStatistics;
        if (map == null) {
            PhpExtensionsManager.$$$reportNull$$$0(2);
        }
        return map;
    }

    @Override
    @NotNull
    public Collection<String> getAllExtensionsNames(@NotNull ExtensionCategory category) {
        if (category == null) {
            PhpExtensionsManager.$$$reportNull$$$0(3);
        }
        Set set = ContainerUtil.union((Collection)EXTENSIONS_HIGH_PRIORITY.get((Object)category), (Collection)EXTENSIONS_LOW_PRIORITY.get((Object)category));
        if (set == null) {
            PhpExtensionsManager.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Nullable
    static String getExtensionName(@NotNull PhpNamedElement namedElement) {
        PsiFile containingFile;
        if (namedElement == null) {
            PhpExtensionsManager.$$$reportNull$$$0(5);
        }
        if ((containingFile = namedElement.getContainingFile()) == null) {
            return null;
        }
        VirtualFile file = containingFile.getVirtualFile();
        if (file == null) {
            return null;
        }
        Project project = namedElement.getProject();
        return (String)CachedValuesManager.getCachedValue((PsiElement)namedElement, () -> {
            Set<VirtualFile> roots = PhpRuntimeLibraryRootsProvider.getLibraryRoots(project);
            VirtualFile containingRoot = (VirtualFile)ContainerUtil.find(roots, r -> r != null && VfsUtilCore.isAncestor((VirtualFile)r, (VirtualFile)file, (boolean)false));
            Set dependencies = ContainerUtil.union(roots, Collections.singleton(VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS));
            String name = containingRoot != null ? containingRoot.getName() : null;
            return PhpRuntimeLibraryRootsProvider.createCacheResult(name, project, dependencies.toArray());
        });
    }

    static {
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.CORE, (Object)"Core");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.CORE, (Object)"date");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.CORE, (Object)"regex");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.CORE, (Object)"filter");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.CORE, (Object)"hash");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.CORE, (Object)"Phar");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.CORE, (Object)"pcre");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.CORE, (Object)"Reflection");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.CORE, (Object)"session");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.CORE, (Object)"SPL");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.CORE, (Object)"standard");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.CORE, (Object)"superglobals");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.CORE, (Object)"tokenizer");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.CORE, (Object)"meta");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.CORE, (Object)"fpm");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.CORE, (Object)"random");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.BUNDLED, (Object)"apache");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.BUNDLED, (Object)"bcmath");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.BUNDLED, (Object)"calendar");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.BUNDLED, (Object)"ctype");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.BUNDLED, (Object)"dba");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.BUNDLED, (Object)"exif");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.BUNDLED, (Object)"fileinfo");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.BUNDLED, (Object)"ftp");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.BUNDLED, (Object)"gd");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.BUNDLED, (Object)"iconv");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.BUNDLED, (Object)"intl");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.BUNDLED, (Object)"json");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.BUNDLED, (Object)"mbstring");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.BUNDLED, (Object)"pcntl");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.BUNDLED, (Object)"PDO");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.BUNDLED, (Object)"posix");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.BUNDLED, (Object)"shmop");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.BUNDLED, (Object)"sysvmsg");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.BUNDLED, (Object)"sysvsem");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.BUNDLED, (Object)"sysvshm");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.BUNDLED, (Object)"sockets");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.BUNDLED, (Object)"sqlite3");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.BUNDLED, (Object)"xmlrpc");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.BUNDLED, (Object)"zlib");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"aerospike");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"bz2");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"curl");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"dom");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"enchant");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"gettext");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"gmp");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"imap");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"ldap");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"libxml");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"mcrypt");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"mssql");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"mysql");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"mysqli");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"oci8");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"odbc");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"Zend OPcache");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"openssl");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"pdo_ibm");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"pdo_mysql");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"pdo_pgsql");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"pdo_sqlite");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"pgsql");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"pspell");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"readline");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"recode");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"SimpleXML");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"snmp");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"soap");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"sodium");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"sybase");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"tidy");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"wddx");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"xml");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"xmlreader");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"xmlwriter");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"xsl");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.EXTERNAL, (Object)"zip");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"apcu");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"ast");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"ds");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"cubrid");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"crypto");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"decimal");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"eio");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"event");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"expect");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"gearman");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"geoip");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"gmagick");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"http");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"ibm_db2");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"imagick");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"inotify");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"interbase");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"libevent");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"leveldb");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"LuaSandbox");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"lzf");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"mailparse");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"memcache");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"memcached");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"ming");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"mongo");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"mongodb");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"mosquitto");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"msgpack");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"mysql_xdevapi");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"ncurses");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"oauth");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"pam");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"Parle");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"parallel");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"pcov");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"pdflib");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"pthreads");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"pq");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"radius");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"rdkafka");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"rpminfo");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"simple_kafka_client");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"SplType");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"SQLite");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"sqlsrv");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"ssh2");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"solr");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"stats");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"stomp");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"svm");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"svn");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"swoole");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"sync");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"uopz");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"uploadprogress");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"uuid");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"uv");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"winbinder");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"wincache");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"xhprof");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"yaml");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"yaf");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"yar");
        EXTENSIONS_HIGH_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"zookeeper");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"zstd");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"xdiff");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"xxtea");
        EXTENSIONS_LOW_PRIORITY.putValue((Object)ExtensionCategory.PECL, (Object)"simdjson");
        HIGH_PRIORITY_EXTENSIONS_VALUES = new HashSet<String>(EXTENSIONS_HIGH_PRIORITY.values());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/PhpExtensionsManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/PhpExtensionsManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionStatistics";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllExtensionsNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPriority";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getUsageStatistics";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAllExtensionsNames";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }

    public static enum ExtensionCategory {
        CORE("Core"),
        BUNDLED("Bundled"),
        EXTERNAL("External"),
        PECL("PECL"),
        OTHERS("Others");

        private final String myName;

        private ExtensionCategory(String name) {
            if (name == null) {
                ExtensionCategory.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                ExtensionCategory.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/config/PhpExtensionsManager$ExtensionCategory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/config/PhpExtensionsManager$ExtensionCategory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

