/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.config.PhpCustomFormatFunction;
import com.jetbrains.php.config.PhpCustomFormatFunctionsChooserForm;
import com.jetbrains.php.lang.PhpLangUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCustomFormatFunctionsChooserDialog
extends DialogWrapper {
    private final PhpIndex myIndex;
    private final PhpCustomFormatFunctionsChooserForm myForm;

    protected PhpCustomFormatFunctionsChooserDialog(@NotNull Project project, @Nls String title) {
        if (project == null) {
            PhpCustomFormatFunctionsChooserDialog.$$$reportNull$$$0(0);
        }
        super(project);
        this.myForm = new PhpCustomFormatFunctionsChooserForm(project, this.getDisposable());
        this.myIndex = PhpIndex.getInstance((Project)project);
        this.init();
        this.setTitle(title);
    }

    public PhpCustomFormatFunctionsChooserDialog(Project project, @Nls String title, PhpCustomFormatFunction format) {
        this(project, title);
        this.fillFormatFunctionValues(format);
    }

    private void fillFormatFunctionValues(PhpCustomFormatFunction format) {
        Object namespaceName;
        Object object = namespaceName = StringUtil.endsWith((CharSequence)format.getNamespaceName(), (CharSequence)"\\") ? format.getNamespaceName() : format.getNamespaceName() + "\\";
        if (format.getClassName() != null) {
            this.myForm.setClassFqn((String)namespaceName + format.getClassName());
            this.myForm.setFunctionFqn(format.getFunctionName());
        } else {
            this.myForm.setFunctionFqn((String)namespaceName + format.getFunctionName());
        }
        this.myForm.setFormatParameterIndex(format.getFormatParameterIndex());
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myForm.getPanel();
    }

    public PhpCustomFormatFunction getSelected() {
        String classFqn = StringUtil.nullize((String)this.myForm.getClassFqn());
        String functionText = this.myForm.getFunctionText();
        String functionName = classFqn != null ? functionText : PhpLangUtil.toShortName(functionText);
        String namespaceName = PhpLangUtil.getParentNamespaceFQN(classFqn != null ? classFqn : PhpLangUtil.toFQN(functionText));
        String className = classFqn != null ? PhpLangUtil.toShortName(classFqn) : null;
        try {
            return new PhpCustomFormatFunction(namespaceName, className, functionName, Integer.parseInt(this.myForm.getFormatIndexText()));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.myForm.validate(this.myIndex);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/config/PhpCustomFormatFunctionsChooserDialog", "<init>"));
    }
}

