/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.lib;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.php.composer.ComposerConfigListener;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.configData.ComposerConfigManager;
import com.jetbrains.php.composer.lib.ComposerFileListener;
import com.jetbrains.php.composer.lib.ComposerLibraryService;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MainComposerLibraryService
extends ComposerLibraryService {
    @Nullable
    private final ComposerFileListener myComposerFileListener;
    private final ExecutorService myPathExecutor;

    private MainComposerLibraryService(@NotNull Project project) {
        if (project == null) {
            MainComposerLibraryService.$$$reportNull$$$0(0);
        }
        super(project, null);
        this.myPathExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Composer Path", (Executor)AppExecutorUtil.getAppExecutorService(), (int)1, (Disposable)this);
        this.myComposerFileListener = new ComposerFileListener(this.myProject, this);
        ComposerConfigListener composerConfigListener2 = new ComposerConfigListener(){

            @Override
            public void configPathOrLibraryStatusChanged(boolean oldStatus, boolean newStatus) {
                MainComposerLibraryService.this.reloadLibraries(false, Collections.emptySet(), oldStatus, newStatus);
            }
        };
        ComposerDataService.getInstance(this.myProject).addConfigListener(composerConfigListener2);
    }

    @Override
    protected void reloadMainFiles() {
        VirtualFile oldConfig = this.myConfig;
        this.myConfig = null;
        String configPath = ComposerConfigManager.getInstance(this.myProject).getMainConfigPath();
        if (!StringUtil.isEmpty((String)configPath)) {
            this.myConfig = LocalFileSystem.getInstance().refreshAndFindFileByPath(configPath);
        }
        super.reloadMainFiles();
        if (oldConfig != null && this.myConfig == null && this.myComposerFileListener != null) {
            this.myComposerFileListener.stop();
        } else if (oldConfig == null && this.myConfig != null && this.myComposerFileListener != null) {
            this.myComposerFileListener.start();
        }
    }

    @Override
    public void dispose() {
        if (this.myComposerFileListener != null) {
            this.myComposerFileListener.stop();
        }
        super.dispose();
    }

    ExecutorService getPathExecutor() {
        return this.myPathExecutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/composer/lib/MainComposerLibraryService", "<init>"));
    }
}

