/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.lib;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.actions.log.ComposerLogService;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0002\u0016\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\fH\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\fJ\b\u0010\u0015\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/php/composer/lib/ComposerLibraryNotificationService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "notificationAlarm", "Lcom/intellij/util/Alarm;", "notifications", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/jetbrains/php/composer/lib/ComposerLibraryNotificationService$Notification;", "notifyWithPopupAndLinks", "", "content", "", "settings", "Lcom/jetbrains/php/composer/actions/log/ComposerLogMessageBuilder$Settings;", "showNotifications", "isDisposed", "", "cancelAllRequests", "dispose", "Notification", "Companion", "intellij.php.impl"})
public final class ComposerLibraryNotificationService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Alarm notificationAlarm;
    @NotNull
    private final ConcurrentLinkedQueue<Notification> notifications;

    public ComposerLibraryNotificationService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.notificationAlarm = new Alarm((Disposable)this);
        this.notifications = new ConcurrentLinkedQueue();
    }

    public final void notifyWithPopupAndLinks(@NotNull String content, @NotNull ComposerLogMessageBuilder.Settings settings) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.notifications.add(new Notification(content, settings));
        this.notificationAlarm.cancelAllRequests();
        this.notificationAlarm.addRequest(() -> ComposerLibraryNotificationService.notifyWithPopupAndLinks$lambda$0(this), 3000);
    }

    private final void showNotifications() {
        while (!((Collection)this.notifications).isEmpty()) {
            Notification notification;
            if (this.notifications.poll() == null) continue;
            ComposerLogService.getInstance(this.project).report(notification.getContent(), notification.getSettings());
        }
    }

    public final boolean isDisposed() {
        return this.notificationAlarm.isDisposed();
    }

    public final void cancelAllRequests() {
        this.notificationAlarm.cancelAllRequests();
    }

    public void dispose() {
        this.notifications.clear();
    }

    private static final void notifyWithPopupAndLinks$lambda$0(ComposerLibraryNotificationService this$0) {
        this$0.showNotifications();
    }

    @JvmStatic
    @NotNull
    public static final ComposerLibraryNotificationService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/php/composer/lib/ComposerLibraryNotificationService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/php/composer/lib/ComposerLibraryNotificationService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.php.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ComposerLibraryNotificationService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(ComposerLibraryNotificationService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (ComposerLibraryNotificationService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/php/composer/lib/ComposerLibraryNotificationService$Notification;", "", "content", "", "settings", "Lcom/jetbrains/php/composer/actions/log/ComposerLogMessageBuilder$Settings;", "<init>", "(Ljava/lang/String;Lcom/jetbrains/php/composer/actions/log/ComposerLogMessageBuilder$Settings;)V", "getContent", "()Ljava/lang/String;", "getSettings", "()Lcom/jetbrains/php/composer/actions/log/ComposerLogMessageBuilder$Settings;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.php.impl"})
    public static final class Notification {
        @NotNull
        private final String content;
        @Nullable
        private final ComposerLogMessageBuilder.Settings settings;

        public Notification(@NotNull String content, @Nullable ComposerLogMessageBuilder.Settings settings) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            this.content = content;
            this.settings = settings;
        }

        @NotNull
        public final String getContent() {
            return this.content;
        }

        @Nullable
        public final ComposerLogMessageBuilder.Settings getSettings() {
            return this.settings;
        }

        @NotNull
        public final String component1() {
            return this.content;
        }

        @Nullable
        public final ComposerLogMessageBuilder.Settings component2() {
            return this.settings;
        }

        @NotNull
        public final Notification copy(@NotNull String content, @Nullable ComposerLogMessageBuilder.Settings settings) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            return new Notification(content, settings);
        }

        public static /* synthetic */ Notification copy$default(Notification notification, String string, ComposerLogMessageBuilder.Settings settings, int n, Object object) {
            if ((n & 1) != 0) {
                string = notification.content;
            }
            if ((n & 2) != 0) {
                settings = notification.settings;
            }
            return notification.copy(string, settings);
        }

        @NotNull
        public String toString() {
            return "Notification(content=" + this.content + ", settings=" + this.settings + ")";
        }

        public int hashCode() {
            int result = this.content.hashCode();
            result = result * 31 + (this.settings == null ? 0 : this.settings.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Notification)) {
                return false;
            }
            Notification notification = (Notification)other;
            if (!Intrinsics.areEqual((Object)this.content, (Object)notification.content)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.settings, (Object)notification.settings);
        }
    }
}

