/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.json;

import com.intellij.json.JsonDialectUtil;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpComposerJsonUtils {
    @NonNls
    private static final List<String> PACKAGES_SECTIONS = List.of("require", "require-dev", "suggest", "replace", "conflict", "provide");
    @NonNls
    private static final List<String> PSR_SECTIONS = List.of("psr-0", "psr-4");
    @NonNls
    private static final List<String> AUTOLOAD_SECTIONS = List.of("autoload", "autoload-dev");
    @NonNls
    private static final List<String> FILE_SUPPORTED_SECTIONS = ContainerUtil.concat(AUTOLOAD_SECTIONS, List.of("scripts", "readme", "include-path", "bin", "vendor-dir", "bin-dir", "data-dir", "cache-dir", "cache-files-dir", "cache-repo-dir", "target-dir", "cache-vcs-dir", "archive-dir", "archive", "capath", "cafile"));

    public static boolean insideComposerJson(@NotNull PsiElement element) {
        if (element == null) {
            PhpComposerJsonUtils.$$$reportNull$$$0(0);
        }
        PsiFile file = element.getContainingFile();
        return JsonDialectUtil.isStandardJson((PsiElement)element) && file != null && "composer.json".equals(file.getName());
    }

    public static boolean insidePackagesSection(@Nullable PsiElement element) {
        JsonProperty packageEntry = PhpPsiUtil.getParentOfClass(element, false, JsonProperty.class);
        JsonProperty section = PhpPsiUtil.getParentOfClass((PsiElement)packageEntry, JsonProperty.class);
        return section != null && PACKAGES_SECTIONS.contains(section.getName());
    }

    public static boolean insideAutoLoadSection(@Nullable PsiElement element) {
        return PhpComposerJsonUtils.insideSection(element, AUTOLOAD_SECTIONS);
    }

    public static boolean insidePsrSection(@Nullable PsiElement element) {
        return PhpComposerJsonUtils.insideSection(element, PSR_SECTIONS);
    }

    public static boolean insideLicenseSection(@Nullable PsiElement element) {
        return PhpComposerJsonUtils.insideSection(element, "license");
    }

    public static boolean insideStabilitySection(@Nullable PsiElement element) {
        return PhpComposerJsonUtils.insideSection(element, "minimum-stability");
    }

    public static boolean insideScriptsSection(@Nullable PsiElement element) {
        return PhpComposerJsonUtils.insideSection(element, "scripts");
    }

    public static boolean insideSection(@Nullable PsiElement element, @NonNls @NotNull String name) {
        if (name == null) {
            PhpComposerJsonUtils.$$$reportNull$$$0(1);
        }
        element = PhpPsiUtil.getParentOfClass(element, JsonProperty.class);
        while (element != null) {
            if (name.equals(((JsonProperty)element).getName())) {
                return true;
            }
            element = PhpPsiUtil.getParentOfClass(element, JsonProperty.class);
        }
        return false;
    }

    public static boolean insideSectionWithSuffix(@Nullable PsiElement element, @NonNls @NotNull String suffix) {
        if (suffix == null) {
            PhpComposerJsonUtils.$$$reportNull$$$0(2);
        }
        element = PhpPsiUtil.getParentOfClass(element, JsonProperty.class);
        while (element != null) {
            if (StringUtil.endsWith((CharSequence)((JsonProperty)element).getName(), (CharSequence)suffix)) {
                return true;
            }
            element = PhpPsiUtil.getParentOfClass(element, JsonProperty.class);
        }
        return false;
    }

    private static boolean insideSection(@Nullable PsiElement element, @NotNull List<String> names) {
        if (names == null) {
            PhpComposerJsonUtils.$$$reportNull$$$0(3);
        }
        element = PhpPsiUtil.getParentOfClass(element, JsonProperty.class);
        while (element != null) {
            if (names.contains(((JsonProperty)element).getName())) {
                return true;
            }
            element = PhpPsiUtil.getParentOfClass(element, JsonProperty.class);
        }
        return false;
    }

    public static boolean allowFiles(@Nullable PsiElement element) {
        if (PhpComposerJsonUtils.insideAutoLoadSection(element)) {
            return !PhpComposerJsonUtils.insidePsrSection(element);
        }
        return true;
    }

    public static boolean insideFilesSupportedSections(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        return PhpComposerJsonUtils.insideSection(element, FILE_SUPPORTED_SECTIONS) && !PhpComposerJsonUtils.insidePropertyKey(element);
    }

    static boolean isValueLiteral(@NotNull JsonStringLiteral literal) {
        PsiElement parent;
        if (literal == null) {
            PhpComposerJsonUtils.$$$reportNull$$$0(4);
        }
        return (parent = literal.getParent()) instanceof JsonProperty ? literal.equals((Object)((JsonProperty)parent).getValue()) : parent instanceof JsonArray;
    }

    public static boolean isKeyLiteral(@Nullable JsonStringLiteral literal) {
        if (literal == null) {
            return false;
        }
        PsiElement parent = literal.getParent();
        return parent instanceof JsonProperty ? literal.equals((Object)((JsonProperty)parent).getNameElement()) : !(parent instanceof JsonArray);
    }

    public static boolean insidePropertyKey(@Nullable PsiElement element) {
        PsiElement parent;
        if (element == null) {
            return false;
        }
        JsonStringLiteral literal = PhpPsiUtil.getParentOfClass(element, false, JsonStringLiteral.class);
        PsiElement psiElement = parent = literal != null ? literal.getParent() : null;
        return parent instanceof JsonProperty ? literal.equals((Object)((JsonProperty)parent).getNameElement()) : !(parent instanceof JsonArray);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/composer/json/PhpComposerJsonUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "insideComposerJson";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "insideSection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "insideSectionWithSuffix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isValueLiteral";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

