/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.json;

import com.intellij.json.JsonElementTypes;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.composer.json.PhpComposerJsonUtils;
import com.jetbrains.php.composer.lib.ComposerLibraryService;
import com.jetbrains.php.composer.lib.ComposerLibraryServiceFactory;
import com.jetbrains.php.lang.PhpCallbackReferenceBase;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComposerJsonReferenceContributor
extends PsiReferenceContributor {
    @NotNull
    private static PsiElementPattern.Capture<JsonStringLiteral> createUrlPattern() {
        PsiElementPattern.Capture capture = (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonStringLiteral.class).with((PatternCondition)new PatternCondition<JsonStringLiteral>("composer.json url"){

            public boolean accepts(@NotNull JsonStringLiteral literal, ProcessingContext context) {
                if (literal == null) {
                    1.$$$reportNull$$$0(0);
                }
                return PhpComposerJsonUtils.isValueLiteral(literal) && PhpComposerJsonUtils.insideComposerJson((PsiElement)literal) && ComposerJsonReferenceContributor.matchesUrl((PsiElement)literal);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/jetbrains/php/composer/json/ComposerJsonReferenceContributor$1", "accepts"));
            }
        });
        if (capture == null) {
            ComposerJsonReferenceContributor.$$$reportNull$$$0(0);
        }
        return capture;
    }

    @NotNull
    private static PsiElementPattern.Capture<JsonStringLiteral> createPhpReferencePattern() {
        PsiElementPattern.Capture capture = (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonStringLiteral.class).with((PatternCondition)new PatternCondition<JsonStringLiteral>("composer.json PHP class/method"){

            public boolean accepts(@NotNull JsonStringLiteral literal, ProcessingContext context) {
                if (literal == null) {
                    2.$$$reportNull$$$0(0);
                }
                return PhpComposerJsonUtils.isValueLiteral(literal) && PhpComposerJsonUtils.insideComposerJson((PsiElement)literal);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/jetbrains/php/composer/json/ComposerJsonReferenceContributor$2", "accepts"));
            }
        });
        if (capture == null) {
            ComposerJsonReferenceContributor.$$$reportNull$$$0(1);
        }
        return capture;
    }

    @NotNull
    private static PsiElementPattern.Capture<JsonStringLiteral> createComposerPackagePattern() {
        PsiElementPattern.Capture capture = (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonStringLiteral.class).with((PatternCondition)new PatternCondition<JsonStringLiteral>("composer.json package"){

            public boolean accepts(@NotNull JsonStringLiteral literal, ProcessingContext context) {
                if (literal == null) {
                    3.$$$reportNull$$$0(0);
                }
                return PhpComposerJsonUtils.insideComposerJson((PsiElement)literal) && PhpComposerJsonUtils.insidePackagesSection((PsiElement)literal) && PhpComposerJsonUtils.isKeyLiteral(literal);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/jetbrains/php/composer/json/ComposerJsonReferenceContributor$3", "accepts"));
            }
        });
        if (capture == null) {
            ComposerJsonReferenceContributor.$$$reportNull$$$0(2);
        }
        return capture;
    }

    private static boolean matchesUrl(@NotNull PsiElement literal) {
        LeafPsiElement element;
        ASTNode node;
        if (literal == null) {
            ComposerJsonReferenceContributor.$$$reportNull$$$0(3);
        }
        if ((node = literal.getNode()) != null && (element = (LeafPsiElement)ObjectUtils.tryCast((Object)node.getFirstChildNode(), LeafPsiElement.class)) != null && element.getElementType() == JsonElementTypes.DOUBLE_QUOTED_STRING) {
            return URLUtil.URL_PATTERN.matcher(StringUtil.unquoteString((String)element.getText())).matches();
        }
        return false;
    }

    @NotNull
    private static PsiElementPattern.Capture<JsonStringLiteral> createFilePathPattern() {
        PsiElementPattern.Capture capture = (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonStringLiteral.class).with((PatternCondition)new PatternCondition<JsonStringLiteral>("composer.json file path"){

            public boolean accepts(@NotNull JsonStringLiteral literal, ProcessingContext context) {
                if (literal == null) {
                    4.$$$reportNull$$$0(0);
                }
                return PhpComposerJsonUtils.isValueLiteral(literal) && PhpComposerJsonUtils.insideComposerJson((PsiElement)literal) && !PhpComposerJsonUtils.insidePackagesSection((PsiElement)literal);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/jetbrains/php/composer/json/ComposerJsonReferenceContributor$4", "accepts"));
            }
        });
        if (capture == null) {
            ComposerJsonReferenceContributor.$$$reportNull$$$0(4);
        }
        return capture;
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            ComposerJsonReferenceContributor.$$$reportNull$$$0(5);
        }
        registrar.registerReferenceProvider(ComposerJsonReferenceContributor.createUrlPattern(), new PsiReferenceProvider(this){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    5.$$$reportNull$$$0(1);
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new WebReference(element)};
                if (psiReferenceArray == null) {
                    5.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/composer/json/ComposerJsonReferenceContributor$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/composer/json/ComposerJsonReferenceContributor$5";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        });
        registrar.registerReferenceProvider(ComposerJsonReferenceContributor.createFilePathPattern(), new PsiReferenceProvider(this){

            public PsiReference @NotNull [] getReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    6.$$$reportNull$$$0(1);
                }
                if (ComposerJsonReferenceContributor.matchesUrl(element)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        6.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                String text = StringUtil.unquoteString((String)element.getText());
                PsiReference[] psiReferenceArray = (PsiReference[])StringUtil.split((String)text, (String)" ").stream().flatMap(i -> {
                    FileReferenceSet set = new FileReferenceSet(this, (String)i, element, StringUtil.indexOf((CharSequence)text, (CharSequence)i) + 1, this, true, true){

                        protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                            if (!PhpComposerJsonUtils.insideFilesSupportedSections(element)) {
                                return Conditions.alwaysFalse();
                            }
                            return !PhpComposerJsonUtils.allowFiles(element) ? DIRECTORY_FILTER : Conditions.alwaysTrue();
                        }

                        public boolean supportsExtendedCompletion() {
                            return false;
                        }
                    };
                    set.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, file -> {
                        PsiDirectory directory;
                        VirtualFile vendorDir;
                        PsiDirectory containingDirectory = file.getContainingDirectory();
                        SmartList fileSystemItems = new SmartList();
                        ContainerUtil.addIfNotNull((Collection)fileSystemItems, (Object)containingDirectory);
                        if (PhpComposerJsonUtils.insideScriptsSection(element) && (vendorDir = ComposerLibraryServiceFactory.getInstance(file.getProject(), element).refreshVendorDir(false, null)) != null && (directory = element.getManager().findDirectory(vendorDir)) != null) {
                            ContainerUtil.addIfNotNull((Collection)fileSystemItems, (Object)directory.findSubdirectory("bin"));
                        }
                        return fileSystemItems;
                    });
                    return Arrays.stream(set.getAllReferences());
                }).toArray(PsiReference[]::new);
                if (psiReferenceArray == null) {
                    6.$$$reportNull$$$0(3);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/composer/json/ComposerJsonReferenceContributor$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/composer/json/ComposerJsonReferenceContributor$6";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3 -> new IllegalStateException(string);
                };
            }
        });
        registrar.registerReferenceProvider(ComposerJsonReferenceContributor.createPhpReferencePattern(), new PsiReferenceProvider(this){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    7.$$$reportNull$$$0(1);
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new PhpScriptsComposerReference(element)};
                if (psiReferenceArray == null) {
                    7.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/composer/json/ComposerJsonReferenceContributor$7";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/composer/json/ComposerJsonReferenceContributor$7";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        });
        registrar.registerReferenceProvider(ComposerJsonReferenceContributor.createPhpReferencePattern(), new PsiReferenceProvider(this){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                String text;
                if (element == null) {
                    8.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    8.$$$reportNull$$$0(1);
                }
                int endOffset = (text = element.getText()).contains(" ") ? text.indexOf(" ") : text.length() - 1;
                PsiReference[] psiReferenceArray = new PsiReference[]{new PhpScriptsAliasesComposerReference(element, endOffset > 0 ? TextRange.create((int)1, (int)endOffset) : TextRange.EMPTY_RANGE)};
                if (psiReferenceArray == null) {
                    8.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/composer/json/ComposerJsonReferenceContributor$8";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/composer/json/ComposerJsonReferenceContributor$8";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        });
        registrar.registerReferenceProvider(ComposerJsonReferenceContributor.createComposerPackagePattern(), new PsiReferenceProvider(this){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                ComposerLibraryService instance;
                if (element == null) {
                    9.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    9.$$$reportNull$$$0(1);
                }
                if ((instance = ComposerLibraryServiceFactory.getInstance(element.getProject(), element)).vendorDirExists()) {
                    FileReferenceSet set = new FileReferenceSet(this, element){

                        protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                            return Conditions.alwaysFalse();
                        }

                        protected boolean isSoft() {
                            return true;
                        }

                        public boolean couldBeConvertedTo(boolean relative) {
                            return false;
                        }
                    };
                    set.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, file -> {
                        VirtualFile vendorDir = instance.refreshVendorDir(false, null);
                        if (vendorDir == null || !vendorDir.isValid()) {
                            return Collections.emptyList();
                        }
                        return Collections.singleton(element.getManager().findDirectory(vendorDir));
                    });
                    FileReference[] fileReferenceArray = set.getAllReferences();
                    if (fileReferenceArray == null) {
                        9.$$$reportNull$$$0(2);
                    }
                    return fileReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    9.$$$reportNull$$$0(3);
                }
                return PsiReference.EMPTY_ARRAY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/composer/json/ComposerJsonReferenceContributor$9";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/composer/json/ComposerJsonReferenceContributor$9";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3 -> new IllegalStateException(string);
                };
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/json/ComposerJsonReferenceContributor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createUrlPattern";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createPhpReferencePattern";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createComposerPackagePattern";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/json/ComposerJsonReferenceContributor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilePathPattern";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "matchesUrl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerReferenceProviders";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 5 -> new IllegalArgumentException(string);
        };
    }

    public static class PhpScriptsAliasesComposerReference
    extends PsiReferenceBase<PsiElement> {
        public PhpScriptsAliasesComposerReference(@NotNull PsiElement element, TextRange rangeInElement) {
            if (element == null) {
                PhpScriptsAliasesComposerReference.$$$reportNull$$$0(0);
            }
            super(element, rangeInElement);
        }

        @Nullable
        public PsiElement resolve() {
            String referenceText;
            JsonStringLiteral literal = (JsonStringLiteral)ObjectUtils.tryCast((Object)this.myElement, JsonStringLiteral.class);
            String string = referenceText = literal != null ? literal.getValue() : null;
            if (StringUtil.isEmpty((String)referenceText)) {
                return null;
            }
            if (StringUtil.unquoteString((String)referenceText).startsWith("@")) {
                JsonObject object;
                JsonProperty property;
                String refName = StringUtil.trimStart((String)referenceText, (String)"@");
                if (refName.contains(" ")) {
                    refName = refName.split(" ")[0];
                }
                if ((property = PhpPsiUtil.getParentOfClass((PsiElement)literal, JsonProperty.class)) != null && (object = (JsonObject)ObjectUtils.tryCast((Object)property.getParent(), JsonObject.class)) != null) {
                    for (JsonProperty jsonProperty : object.getPropertyList()) {
                        if (jsonProperty == property || !refName.equals(jsonProperty.getName())) continue;
                        return jsonProperty;
                    }
                }
            }
            return null;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                PhpScriptsAliasesComposerReference.$$$reportNull$$$0(1);
            }
            return super.handleElementRename("@" + newElementName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/composer/json/ComposerJsonReferenceContributor$PhpScriptsAliasesComposerReference";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleElementRename";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PhpScriptsComposerReference
    extends PhpCallbackReferenceBase {
        public static final String SEPARATOR = "::";

        public PhpScriptsComposerReference(@NotNull PsiElement element) {
            if (element == null) {
                PhpScriptsComposerReference.$$$reportNull$$$0(0);
            }
            super(element);
        }

        public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
            String referenceText;
            JsonStringLiteral literal = (JsonStringLiteral)ObjectUtils.tryCast((Object)this.myElement, JsonStringLiteral.class);
            String string = referenceText = literal != null ? literal.getValue() : null;
            if (StringUtil.isEmpty((String)referenceText)) {
                if (ResolveResult.EMPTY_ARRAY == null) {
                    PhpScriptsComposerReference.$$$reportNull$$$0(1);
                }
                return ResolveResult.EMPTY_ARRAY;
            }
            PhpIndex index = PhpIndex.getInstance((Project)this.myElement.getProject());
            if (referenceText.contains(SEPARATOR)) {
                HashSet<PsiElementResolveResult> results = new HashSet<PsiElementResolveResult>();
                int indexOfSeparator = referenceText.indexOf(SEPARATOR);
                for (PhpClass aClass : index.getAnyByFQN(PhpLangUtil.toFQN(referenceText.substring(0, indexOfSeparator)))) {
                    Method method = aClass.findMethodByName((CharSequence)referenceText.substring(indexOfSeparator + 2));
                    if (method == null) continue;
                    results.add(new PsiElementResolveResult((PsiElement)method));
                }
                ResolveResult[] resolveResultArray = results.toArray(ResolveResult.EMPTY_ARRAY);
                if (resolveResultArray == null) {
                    PhpScriptsComposerReference.$$$reportNull$$$0(2);
                }
                return resolveResultArray;
            }
            Collection classes = index.getAnyByFQN(PhpLangUtil.toFQN(referenceText));
            if (!classes.isEmpty()) {
                ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((Collection)classes);
                if (resolveResultArray == null) {
                    PhpScriptsComposerReference.$$$reportNull$$$0(3);
                }
                return resolveResultArray;
            }
            if (ResolveResult.EMPTY_ARRAY == null) {
                PhpScriptsComposerReference.$$$reportNull$$$0(4);
            }
            return ResolveResult.EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/composer/json/ComposerJsonReferenceContributor$PhpScriptsComposerReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/composer/json/ComposerJsonReferenceContributor$PhpScriptsComposerReference";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "multiResolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

