/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.execution.phar;

import com.intellij.DynamicBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.composer.ComposerPathForm;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.execution.ComposerExecution;
import com.jetbrains.php.composer.execution.ComposerExecutionProvider;
import com.jetbrains.php.composer.execution.phar.ComposerPhpInterpretersCombo;
import com.jetbrains.php.composer.execution.phar.PharComposerExecution;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerPharForm
implements ComposerExecutionProvider.Form {
    private final Project myProject;
    private ComposerPhpInterpretersCombo myPhpInterpreterComboBox;
    private JBCheckBox myDownloadCheckBox;
    private TextFieldWithBrowseButton myPathTextField;
    private JPanel myMainPanel;
    private String myInterpreterName;

    public ComposerPharForm(@NotNull Project project) {
        if (project == null) {
            ComposerPharForm.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myPathTextField.addActionListener(ComposerUtils.createPharBrowserListener(this.myPathTextField, this.myMainPanel));
        this.myDownloadCheckBox.addActionListener(e -> {
            boolean enabled = !this.myDownloadCheckBox.isSelected();
            this.myPathTextField.setEnabled(enabled);
            if (!enabled) {
                this.myPathTextField.setText("");
            }
        });
    }

    private void createUIComponents() {
        this.myPhpInterpreterComboBox = new ComposerPhpInterpretersCombo(this.myProject);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            ComposerPharForm.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @Override
    public boolean isModified(@NotNull ComposerExecution execution) {
        if (execution == null) {
            ComposerPharForm.$$$reportNull$$$0(2);
        }
        if (!(execution instanceof PharComposerExecution)) {
            return true;
        }
        if (this.myPhpInterpreterComboBox.isModified(this.myInterpreterName)) {
            return true;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)((PharComposerExecution)execution).getPharPath()), (CharSequence)StringUtil.nullize((String)this.myPathTextField.getText()))) {
            return true;
        }
        return this.myDownloadCheckBox.isSelected() != ((PharComposerExecution)execution).isShouldDownload();
    }

    @Override
    public boolean reset(@NotNull ComposerExecution execution) {
        if (execution == null) {
            ComposerPharForm.$$$reportNull$$$0(3);
        }
        this.myDownloadCheckBox.setSelected(false);
        if (execution instanceof PharComposerExecution) {
            this.myPhpInterpreterComboBox.setInterpreterId(execution.getInterpreterId());
            this.myInterpreterName = this.myPhpInterpreterComboBox.getSelectedItemName();
            @NlsSafe String text = StringUtil.notNullize((String)((PharComposerExecution)execution).getPharPath());
            this.myPathTextField.setText(text);
            return true;
        }
        this.myPhpInterpreterComboBox.setInterpreterId(null);
        this.myInterpreterName = null;
        this.myPathTextField.setText("");
        return false;
    }

    @Override
    public void apply() {
    }

    @Override
    @NotNull
    public ComposerExecution getExecution() {
        return new PharComposerExecution(this.myPhpInterpreterComboBox.getInterpreterId(), this.myPathTextField.getText(), this.myDownloadCheckBox.isSelected());
    }

    @Override
    @Nullable
    public ValidationInfo validate() {
        ValidationInfo info = this.myPhpInterpreterComboBox.validateInterpreter();
        if (info != null) {
            return info;
        }
        if (!this.myDownloadCheckBox.isSelected()) {
            return ComposerPathForm.validateComposerPharPath(this.myPathTextField);
        }
        return null;
    }

    public void hideDownload() {
        this.myDownloadCheckBox.setVisible(false);
        this.myDownloadCheckBox.setSelected(false);
    }

    public void selectDownload() {
        this.myDownloadCheckBox.setSelected(true);
    }

    public boolean isDownloadPhar() {
        return this.myDownloadCheckBox.isSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/execution/phar/ComposerPharForm";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execution";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/execution/phar/ComposerPharForm";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        ComposerPhpInterpretersCombo composerPhpInterpretersCombo = this.myPhpInterpreterComboBox;
        jPanel.add((Component)((Object)composerPhpInterpretersCombo), new GridConstraints(2, 1, 1, 1, 0, 1, 7, 0, new Dimension(50, -1), new Dimension(50, -1), null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", ComposerPharForm.class).getString("framework.composer.add.dependency.settings.interpreter.label"));
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myDownloadCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setSelected(false);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", ComposerPharForm.class).getString("composer.checkbox.download.composer.phar.from.getcomposer.org"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null, 1));
        this.myPathTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setText("");
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, new Dimension(50, -1), new Dimension(50, -1), null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", ComposerPharForm.class).getString("composer.label.phar"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

