/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.configData;

import com.google.gson.JsonElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.composer.configData.ComposerConfigClient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ComposerConfigListener<T> {
    private static final Logger LOG = Logger.getInstance(ComposerConfigListener.class);
    @NotNull
    private final ComposerConfigClient<T> myClient;
    private final Map<VirtualFile, List<ComposerConfigElement>> myConfigElements;
    private final Map<VirtualFile, T> myOldDataMap;

    ComposerConfigListener(@NotNull ComposerConfigClient<T> client) {
        if (client == null) {
            ComposerConfigListener.$$$reportNull$$$0(0);
        }
        this.myConfigElements = new ConcurrentHashMap<VirtualFile, List<ComposerConfigElement>>();
        this.myOldDataMap = new ConcurrentHashMap<VirtualFile, T>();
        this.myClient = client;
    }

    @NotNull
    public ComposerConfigClient<T> getClient() {
        ComposerConfigClient<T> composerConfigClient = this.myClient;
        if (composerConfigClient == null) {
            ComposerConfigListener.$$$reportNull$$$0(1);
        }
        return composerConfigClient;
    }

    public boolean wasUpdated(@Nullable JsonElement fileElement, @NotNull VirtualFile config, @NotNull Project project) {
        if (config == null) {
            ComposerConfigListener.$$$reportNull$$$0(2);
        }
        if (project == null) {
            ComposerConfigListener.$$$reportNull$$$0(3);
        }
        return this.getNewData(fileElement, config, project, false) != null;
    }

    @Nullable
    private T getNewData(@Nullable JsonElement fileElement, @NotNull VirtualFile config, @NotNull Project project, boolean initialized) {
        if (config == null) {
            ComposerConfigListener.$$$reportNull$$$0(4);
        }
        if (project == null) {
            ComposerConfigListener.$$$reportNull$$$0(5);
        }
        if (!this.myClient.isAccept(project, config)) {
            return null;
        }
        this.myConfigElements.putIfAbsent(config, ContainerUtil.map(this.myClient.getPath(), p -> new ComposerConfigElement((String)p)));
        boolean wasUpdated = false;
        HashMap<String, JsonElement> updated = new HashMap<String, JsonElement>();
        for (ComposerConfigElement element : this.myConfigElements.get(config)) {
            JsonElement newElement;
            wasUpdated = element.update(newElement = ComposerConfigListener.findElement(fileElement, element.path, 0)) || wasUpdated;
            updated.put(element.getName(), newElement);
        }
        if (!initialized && !wasUpdated) {
            return null;
        }
        T newData = this.myClient.parse(project, updated, config);
        T oldData = this.myOldDataMap.get(config);
        if (newData == null ? oldData == null : newData.equals(oldData) && !initialized) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("inform(), no changed with initialized=" + initialized + "\nold " + String.valueOf(oldData == null ? "<null>" : oldData) + "\nnew " + String.valueOf(newData == null ? "<null>" : newData));
            }
            return null;
        }
        if (newData != null) {
            this.myOldDataMap.put(config, newData);
        } else {
            this.myOldDataMap.remove(config);
        }
        return newData;
    }

    public void inform(@Nullable JsonElement fileElement, @NotNull VirtualFile config, @NotNull Project project, boolean initialized) {
        T newData;
        if (config == null) {
            ComposerConfigListener.$$$reportNull$$$0(6);
        }
        if (project == null) {
            ComposerConfigListener.$$$reportNull$$$0(7);
        }
        if ((newData = this.getNewData(fileElement, config, project, initialized)) == null) {
            return;
        }
        this.myClient.consume(newData, project, config);
    }

    public boolean usesConfigClient(ComposerConfigClient<?> configClient) {
        return this.myClient == configClient;
    }

    public void reset(@Nullable String configPath) {
        if (configPath != null) {
            VirtualFile toRemove = (VirtualFile)ContainerUtil.find(this.myConfigElements.keySet(), elements -> configPath.equals(elements.getPath()));
            if (toRemove != null) {
                this.myConfigElements.remove(toRemove);
                this.myOldDataMap.remove(toRemove);
            }
        } else {
            this.myConfigElements.clear();
            this.myOldDataMap.clear();
        }
    }

    public boolean isClientInstanceOf(Class<?> ... classes) {
        return ContainerUtil.exists((Object[])classes, c -> c.isInstance(this.myClient));
    }

    @Nullable
    private static JsonElement findElement(@Nullable JsonElement element, @NotNull List<String> path, int index) {
        if (path == null) {
            ComposerConfigListener.$$$reportNull$$$0(8);
        }
        if (element == null) {
            return null;
        }
        if (index == path.size()) {
            return element;
        }
        if (element.isJsonObject()) {
            JsonElement childElement = element.getAsJsonObject().get(path.get(index));
            return ComposerConfigListener.findElement(childElement, path, index + 1);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/configData/ComposerConfigListener";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/configData/ComposerConfigListener";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getClient";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "wasUpdated";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNewData";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "inform";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class ComposerConfigElement {
        private final List<String> path;
        private JsonElement oldElement;

        private ComposerConfigElement(@NotNull String path) {
            if (path == null) {
                ComposerConfigElement.$$$reportNull$$$0(0);
            }
            this.path = StringUtil.split((String)path, (String)"/");
        }

        @NotNull
        public String getName() {
            String string = this.path.isEmpty() ? "" : this.path.get(this.path.size() - 1);
            if (string == null) {
                ComposerConfigElement.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean update(@Nullable JsonElement newElement) {
            boolean updated;
            boolean bl = updated = !Objects.equals(newElement, this.oldElement);
            if (updated) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("update() and found change:\nold " + (this.oldElement == null ? "<null>" : this.oldElement.toString()) + "\nnew " + (newElement == null ? "<null>" : newElement.toString()));
                }
                this.oldElement = newElement;
            }
            return updated;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/composer/configData/ComposerConfigListener$ComposerConfigElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/composer/configData/ComposerConfigListener$ComposerConfigElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

