/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions.update;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class ComposerUpdateOutputParser {
    private static final Pattern UPDATE_REGEXP_V1 = Pattern.compile("Updating\\s(?<initialPackage>.+)\\s\\((?<initialVersion>.+)\\)\\sto\\s(?<targetPackage>.+)\\s\\((?<targetVersion>.+)\\)");
    private static final Pattern UPDATE_REGEXP_V2 = Pattern.compile("Upgrading\\s(?<initialPackage>.+)\\s\\((?<initialVersion>.+)\\s=>\\s(?<targetVersion>.+)\\)");

    public static @NotNull Map<@NlsSafe String, @NlsSafe String> parseReadyToUpdatePackages(@NotNull String text) {
        if (text == null) {
            ComposerUpdateOutputParser.$$$reportNull$$$0(0);
        }
        String[] lines = StringUtil.splitByLines((String)text);
        HashMap<String, String> packageToAvailableUpdateVersion = new HashMap<String, String>();
        for (String line : lines) {
            Matcher matcher_v1 = UPDATE_REGEXP_V1.matcher(StringUtil.newBombedCharSequence((CharSequence)line, (long)1000L));
            if (matcher_v1.find()) {
                String packageName = matcher_v1.group("initialPackage");
                String version = matcher_v1.group("targetVersion");
                packageToAvailableUpdateVersion.put(packageName, version);
                continue;
            }
            Matcher matcher_v2 = UPDATE_REGEXP_V2.matcher(StringUtil.newBombedCharSequence((CharSequence)line, (long)1000L));
            if (!matcher_v2.find()) continue;
            String packageName = matcher_v2.group("initialPackage");
            String version = matcher_v2.group("targetVersion");
            packageToAvailableUpdateVersion.put(packageName, version);
        }
        HashMap<String, String> hashMap = packageToAvailableUpdateVersion;
        if (hashMap == null) {
            ComposerUpdateOutputParser.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/actions/update/ComposerUpdateOutputParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/actions/update/ComposerUpdateOutputParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseReadyToUpdatePackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseReadyToUpdatePackages";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

