/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions.update;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.composer.ComposerConfigListener;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.actions.update.ComposerAvailablePackageVersionsService;
import com.jetbrains.php.composer.actions.update.ComposerConfigFileListener;
import com.jetbrains.php.composer.actions.update.ComposerInstalledPackagesService;
import com.jetbrains.php.composer.configData.ComposerConfigManager;
import com.jetbrains.php.composer.json.ComposerInstallNotifier;
import com.jetbrains.php.composer.lib.ComposerLibraryStartupActivityKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComposerConfigFileChangesTracker
implements Disposable {
    private final VirtualFileListener myComposerJsonListener;
    private final VirtualFileListener myComposerLockListener;
    private final AtomicBoolean myIsActive;
    private final BidirectionalMap<VirtualFile, VirtualFile> myComposerLocks;

    public ComposerConfigFileChangesTracker(final @NotNull Project project) {
        if (project == null) {
            ComposerConfigFileChangesTracker.$$$reportNull$$$0(0);
        }
        this.myIsActive = new AtomicBoolean(false);
        this.myComposerLocks = new BidirectionalMap();
        this.myComposerJsonListener = new VirtualFileListener(){

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.handleChange(event, null);
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.handleChange(event, event.getFile());
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (event.getFileName().equals("composer.lock") && !ComposerConfigFileChangesTracker.this.myComposerLocks.containsValue((Object)event.getFile())) {
                    VirtualFile config = ComposerConfigManager.getInstance(project).getConfig(event.getFile());
                    if (config != null) {
                        ComposerConfigFileChangesTracker.this.myComposerLocks.put((Object)config, (Object)event.getFile());
                    }
                    ComposerConfigFileChangesTracker.getConfigListeners(project, config).forEach(l -> l.composerLockChanged(false));
                }
            }

            private void handleChange(@NotNull VirtualFileEvent event, @Nullable VirtualFile newConfig) {
                if (event == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (ComposerConfigManager.getInstance(project).getAllConfigs().contains(event.getFile())) {
                    if (newConfig == null) {
                        ComposerConfigFileChangesTracker.this.updateFileListeners(project);
                    }
                    ComposerConfigFileChangesTracker.getConfigListeners(project, event.getFile()).forEach(ComposerConfigFileListener::composerJsonChanged);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/jetbrains/php/composer/actions/update/ComposerConfigFileChangesTracker$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileDeleted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentsChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileCreated";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleChange";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myComposerLockListener = new VirtualFileListener(){

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                List configs;
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((configs = ComposerConfigFileChangesTracker.this.myComposerLocks.getKeysByValue((Object)event.getFile())) == null) {
                    return;
                }
                for (VirtualFile config : configs) {
                    ComposerConfigFileChangesTracker.getConfigListeners(project, config).forEach(l -> l.composerLockChanged(false));
                    ComposerConfigFileChangesTracker.this.myComposerLocks.remove((Object)config);
                    if (!ComposerConfigFileChangesTracker.this.myComposerLocks.isEmpty()) continue;
                    LocalFileSystem.getInstance().removeVirtualFileListener(ComposerConfigFileChangesTracker.this.myComposerLockListener);
                }
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                List configs;
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((configs = ComposerConfigFileChangesTracker.this.myComposerLocks.getKeysByValue((Object)event.getFile())) == null) {
                    return;
                }
                for (VirtualFile config : configs) {
                    ComposerConfigFileChangesTracker.getConfigListeners(project, config).forEach(l -> l.composerLockChanged(false));
                }
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                List configs;
                if (event == null) {
                    2.$$$reportNull$$$0(2);
                }
                if ((configs = ComposerConfigFileChangesTracker.this.myComposerLocks.getKeysByValue((Object)event.getFile())) == null) {
                    return;
                }
                for (VirtualFile config : configs) {
                    ComposerConfigFileChangesTracker.getConfigListeners(project, config).forEach(l -> l.composerLockChanged(false));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/jetbrains/php/composer/actions/update/ComposerConfigFileChangesTracker$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileDeleted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentsChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileCreated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ComposerDataService dataService = ComposerDataService.getInstance(project);
        dataService.addSynchronizationInitListener(newSyncState -> {
            if (newSyncState == ComposerDataService.SynchronizationState.SYNCHRONIZE) {
                this.updateFileListeners(project);
                for (ComposerConfigFileListener listener : ComposerConfigFileChangesTracker.getAllConfigListeners(project)) {
                    listener.composerConfigInitialized();
                }
            }
        });
        dataService.addConfigListener(new ComposerConfigListener(){

            @Override
            public void configPathChanged(@Nullable String oldPath, @Nullable String newPath, boolean isWellConfigured) {
                VirtualFile newConfig;
                VirtualFile virtualFile = newConfig = newPath != null ? LocalFileSystem.getInstance().findFileByPath(newPath) : null;
                if (newConfig != null) {
                    for (ComposerConfigFileListener listener : ComposerConfigFileChangesTracker.getConfigListeners(project, newConfig)) {
                        listener.composerConfigInitialized();
                    }
                }
                ComposerConfigFileChangesTracker.this.updateFileListeners(project);
            }
        });
        StartupManager.getInstance((Project)project).runAfterOpened((Runnable)((DumbAwareRunnable)() -> {
            this.initComposerLocks(project);
            for (VirtualFile config : ComposerConfigManager.getInstance(project).getAllConfigs()) {
                this.myComposerLocks.put((Object)config, (Object)ComposerConfigUtils.findLockFile(config));
                for (ComposerConfigFileListener listener : ComposerConfigFileChangesTracker.getConfigListeners(project, config)) {
                    listener.composerLockChanged(true);
                }
            }
            this.updateFileListeners(project);
        }));
    }

    private void updateFileListeners(@NotNull Project project) {
        List<VirtualFile> allConfigs;
        if (project == null) {
            ComposerConfigFileChangesTracker.$$$reportNull$$$0(1);
        }
        if (!(allConfigs = ComposerConfigManager.getInstance(project).getAllConfigs()).isEmpty() && this.myIsActive.compareAndSet(false, true)) {
            LocalFileSystem.getInstance().addVirtualFileListener(this.myComposerJsonListener);
            LocalFileSystem.getInstance().addVirtualFileListener(this.myComposerLockListener);
        } else if (allConfigs.isEmpty() && this.myIsActive.compareAndSet(true, false)) {
            LocalFileSystem.getInstance().removeVirtualFileListener(this.myComposerJsonListener);
            LocalFileSystem.getInstance().removeVirtualFileListener(this.myComposerLockListener);
        }
    }

    private void initComposerLocks(@NotNull Project project) {
        if (project == null) {
            ComposerConfigFileChangesTracker.$$$reportNull$$$0(2);
        }
        for (VirtualFile config : ComposerConfigManager.getInstance(project).getAllConfigs()) {
            this.myComposerLocks.put((Object)config, (Object)ComposerConfigUtils.findLockFile(config));
        }
    }

    private static Collection<ComposerConfigFileListener> getConfigListeners(@NotNull Project project, @Nullable VirtualFile context) {
        if (project == null) {
            ComposerConfigFileChangesTracker.$$$reportNull$$$0(3);
        }
        return (Collection)ReadAction.compute(() -> ComposerLibraryStartupActivityKt.getConfigListeners(project, context));
    }

    private static Collection<ComposerConfigFileListener> getAllConfigListeners(@NotNull Project project) {
        if (project == null) {
            ComposerConfigFileChangesTracker.$$$reportNull$$$0(4);
        }
        ArrayList<ComposerConfigFileListener> result = new ArrayList<ComposerConfigFileListener>();
        ReadAction.run(() -> {
            if (project.isOpen()) {
                ContainerUtil.addAllNotNull((Collection)result, ComposerInstalledPackagesService.getAllInstances(project));
                ContainerUtil.addAllNotNull((Collection)result, ComposerAvailablePackageVersionsService.getAllInstances(project));
                ContainerUtil.addIfNotNull((Collection)result, (Object)ComposerInstallNotifier.getInstance(project));
            }
        });
        return result;
    }

    public void dispose() {
        LocalFileSystem.getInstance().removeVirtualFileListener(this.myComposerLockListener);
        LocalFileSystem.getInstance().removeVirtualFileListener(this.myComposerJsonListener);
    }

    public static ComposerConfigFileChangesTracker getInstance(@NotNull Project project) {
        if (project == null) {
            ComposerConfigFileChangesTracker.$$$reportNull$$$0(5);
        }
        return (ComposerConfigFileChangesTracker)project.getService(ComposerConfigFileChangesTracker.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/jetbrains/php/composer/actions/update/ComposerConfigFileChangesTracker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateFileListeners";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "initComposerLocks";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getConfigListeners";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllConfigListeners";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

