/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.trustedProjects.TrustedProjectsDialog;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.util.MinimizeButton;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.EDT;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.ComposerConfigurable;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerStability;
import com.jetbrains.php.composer.addDependency.ComposerPackage;
import com.jetbrains.php.ui.PhpUiUtil;
import com.jetbrains.php.util.PhpConfigurationUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComposerUtils {
    @NonNls
    public static final String COMPOSER_PHAR_NAME = "composer.phar";
    @NonNls
    public static final String COMPOSER_LINUX_NAME = "composer";
    @NonNls
    public static final String DOWNLOAD_URL = "https://getcomposer.org/composer-stable.phar";
    @NonNls
    public static final String CONFIG_DEFAULT_FILENAME = "composer.json";
    @NonNls
    public static final String LOCK_FILE_NAME = "composer.lock";
    @NonNls
    public static final String VENDOR_DIR_DEFAULT_NAME = "vendor";
    @NonNls
    public static final String AUTOLOAD = "autoload";
    @NonNls
    public static final String AUTOLOAD_DEV = "autoload-dev";
    @NonNls
    private static final String[] STABILITY_VERSIONS = new String[]{"dev", "alpha", "beta", "RC", "stable"};
    public static final ExecutorService COMPOSER_CONFIG_EXECUTOR = ComposerUtils.createExecutorService("Composer Json Listener", "php.composer.config.listener.max.threads");
    private static final Logger LOG = Logger.getInstance(ComposerUtils.class);
    private static final Comparator<VirtualFile> PATH_LENGTH_COMPARATOR = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        int size1 = StringUtil.split((String)o1.getPath(), (String)"/").size();
        int size2 = StringUtil.split((String)o2.getPath(), (String)"/").size();
        return size1 - size2;
    };

    private ComposerUtils() {
    }

    public static ComponentWithBrowseButton.BrowseFolderActionListener<JTextField> createPharBrowserListener(final TextFieldWithBrowseButton field, final @Nullable Component component) {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withTitle(PhpBundle.message("framework.composer.path.dialog.path.to.composer", new Object[0])).withDescription(PhpBundle.message("framework.composer.path.dialog.specify.composer.phar", new Object[0]));
        return new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>((ComponentWithBrowseButton)field, null, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            @Nullable
            protected VirtualFile getInitialFile() {
                VirtualFile file;
                String text = field.getText();
                if (StringUtil.isEmpty((String)text) && (file = ComposerUtils.findFileInProject(component, ComposerUtils.COMPOSER_PHAR_NAME)) != null) {
                    return file;
                }
                return super.getInitialFile();
            }
        };
    }

    @Nullable
    public static VirtualFile findFileInProject(@Nullable Component component, String fileName) {
        Project project;
        if (component == null) {
            project = null;
        } else {
            DataContext context = DataManager.getInstance().getDataContext(component);
            project = (Project)CommonDataKeys.PROJECT.getData(context);
        }
        return ComposerUtils.findFileInProject(project, fileName);
    }

    public static VirtualFile findFileInProject(@Nullable Project project, String fileName) {
        if (project != null) {
            GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
            Collection files = FilenameIndex.getVirtualFilesByName((String)fileName, (GlobalSearchScope)scope);
            if (files.isEmpty()) {
                return null;
            }
            return Collections.min(files, PATH_LENGTH_COMPARATOR);
        }
        return null;
    }

    @Nullable
    public static VirtualFile downloadPhar(@Nullable Project project, JComponent component, @Nullable String toDir) {
        return PhpConfigurationUtil.downloadFile(project, component, toDir, DOWNLOAD_URL, COMPOSER_PHAR_NAME);
    }

    public static void initConfig(VirtualFile parentDirForConfig, Project project, Object requestor) {
        VirtualFile virtualFile;
        PsiFile file;
        FileTemplate template = FileTemplateManager.getInstance((Project)project).getInternalTemplate(CONFIG_DEFAULT_FILENAME);
        Map<String, String> defaultValues = Map.of("package_name", parentDirForConfig.getName(), "stability", "stable", "license", "proprietary", "email", "email@example.com", "author", SystemProperties.getUserName());
        template.setLiveTemplateEnabled(true);
        PsiDirectory directory = PsiManager.getInstance((Project)project).findDirectory(parentDirForConfig);
        if (directory != null && (file = CreateFileFromTemplateAction.createFileFromTemplate((String)CONFIG_DEFAULT_FILENAME, (FileTemplate)template, (PsiDirectory)directory, null, (boolean)true, defaultValues)) != null && (virtualFile = file.getVirtualFile()) != null) {
            FileEditorManager.getInstance((Project)file.getProject()).openFile(virtualFile, true);
            if (StringUtil.isEmpty((String)ComposerDataService.getInstance(project).getConfigPath())) {
                ComposerDataService.getInstance(project).setConfigPathAndLibraryUpdateStatus(virtualFile.getPath(), true);
            }
        }
    }

    @NonNls
    public static List<String> getInstallationCommand(@NotNull String packageName, String version) {
        if (packageName == null) {
            ComposerUtils.$$$reportNull$$$0(0);
        }
        Object installationTarget = StringUtil.isEmpty((String)version) ? packageName : packageName + ":" + version;
        return Arrays.asList("require", installationTarget);
    }

    @NonNls
    public static List<String> getCreateProjectCommand(@NotNull ComposerPackage aPackage, String version, String newProjectPath) {
        ComposerStability stability;
        if (aPackage == null) {
            ComposerUtils.$$$reportNull$$$0(1);
        }
        @NonNls ArrayList<String> commands = new ArrayList<String>();
        commands.add("create-project");
        commands.add(aPackage.getName());
        commands.add(newProjectPath);
        if (version != null) {
            commands.add(version);
        }
        if (version != null) {
            stability = ComposerStability.getStability(version);
        } else {
            ComposerStability maxStability = null;
            for (String currentVersion : aPackage.getVersions()) {
                ComposerStability currentStability = ComposerStability.getStability(currentVersion);
                if (maxStability == null || currentStability.isMoreStableThan(maxStability)) {
                    maxStability = currentStability;
                }
                if (ComposerStability.getMostStable() != maxStability) continue;
                break;
            }
            stability = maxStability;
        }
        if (stability != null && stability.needsToBeSpecified()) {
            commands.add("-s" + stability.getId());
        }
        return commands;
    }

    @NonNls
    public static List<String> getUpdatePackageCommand(@NotNull String packageName) {
        if (packageName == null) {
            ComposerUtils.$$$reportNull$$$0(2);
        }
        return Arrays.asList("update", packageName, "--no-progress");
    }

    public static List<String> getUpdateSimulationCommand() {
        return Arrays.asList("update", "--dry-run");
    }

    @NonNls
    public static List<String> getRemovePackageCommand(@NotNull String packageName) {
        if (packageName == null) {
            ComposerUtils.$$$reportNull$$$0(3);
        }
        return Arrays.asList("remove", packageName, "--no-progress");
    }

    @NotNull
    public static JBPopup createOutputPopup(String output, @NotNull @Nls String message, @Nls(capitalization=Nls.Capitalization.Title) String title, Project project) {
        if (message == null) {
            ComposerUtils.$$$reportNull$$$0(4);
        }
        JPanel mainPanel = new JPanel(new BorderLayout());
        JBLabel label = new JBLabel(message);
        mainPanel.add((Component)label, "North");
        JTextArea textArea = new JTextArea();
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setBackground((Color)JBColor.WHITE);
        textArea.setText(output);
        JBScrollPane scrollPane = new JBScrollPane((Component)textArea);
        mainPanel.add((Component)scrollPane, "Center");
        JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)mainPanel, (JComponent)mainPanel).setTitle(title).setMovable(true).setResizable(true).setDimensionServiceKey(project, "ComposerAddDependencyOutputPopupDimensionServiceKey", true).setMinSize(new Dimension(JBUIScale.scale((int)600), JBUIScale.scale((int)300))).setCancelButton((IconButton)new MinimizeButton(PhpBundle.message("framework.composer.add.dependency.hide.tooltip", new Object[0]))).createPopup();
        if (jBPopup == null) {
            ComposerUtils.$$$reportNull$$$0(5);
        }
        return jBPopup;
    }

    @Nullable
    public static VirtualFile findVendorDir(@Nullable VirtualFile composerJson, @Nullable String relativePath) {
        if (composerJson == null || relativePath == null) {
            return null;
        }
        VirtualFile parent = composerJson.getParent();
        if (parent == null) {
            return null;
        }
        File file = new File(parent.getPath());
        File target = new File(file, relativePath);
        return ComposerUtils.refreshAndFindFileByPath(target.getAbsolutePath());
    }

    @Nullable
    public static VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        VirtualFile refreshedFile;
        VirtualFile localFile;
        if (path == null) {
            ComposerUtils.$$$reportNull$$$0(6);
        }
        if ((localFile = LocalFileSystem.getInstance().findFileByPath(path)) != null) {
            return localFile;
        }
        Application application = ApplicationManager.getApplication();
        if ((EDT.isCurrentThreadEdt() || !application.isReadAccessAllowed()) && (refreshedFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(path)) != null) {
            return refreshedFile;
        }
        if (application.isUnitTestMode()) {
            return TempFileSystem.getInstance().refreshAndFindFileByPath(path);
        }
        return null;
    }

    public static void refreshVendorDirectory(@Nullable VirtualFile vendorDirectory, boolean asynchronous, @Nullable Runnable postRefresh) {
        if (vendorDirectory == null) {
            return;
        }
        vendorDirectory.refresh(asynchronous, true, postRefresh);
    }

    public static void refreshVendorDir(@NotNull VirtualFile configFile) {
        Pair<String, String> dirs;
        if (configFile == null) {
            ComposerUtils.$$$reportNull$$$0(7);
        }
        if ((dirs = ComposerConfigUtils.getVendorAndBinDirs(configFile)) == null) {
            return;
        }
        VirtualFile vendorDir = ComposerUtils.findVendorDir(configFile, (String)dirs.getFirst());
        ComposerUtils.refreshVendorDirectory(vendorDir, true, null);
    }

    @Nullable
    public static String getPresentablePath(VirtualFile composerJson, @NotNull Project project) {
        if (project == null) {
            ComposerUtils.$$$reportNull$$$0(8);
        }
        if (composerJson == null || project.isDisposed()) {
            return null;
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        VirtualFile[] roots = projectRootManager.getContentRoots();
        String path = (String)ApplicationManager.getApplication().runReadAction(() -> {
            ProjectFileIndex fileIndex;
            VirtualFile contentRoot;
            if (!DumbService.isDumb((Project)project) && (contentRoot = (fileIndex = projectRootManager.getFileIndex()).getContentRootForFile(composerJson)) != null) {
                return ComposerUtils.getPresentablePath(composerJson, contentRoot, roots);
            }
            return null;
        });
        if (path != null) {
            return path;
        }
        for (VirtualFile root : roots) {
            if (!composerJson.getUrl().startsWith(root.getUrl())) continue;
            return ComposerUtils.getPresentablePath(composerJson, root, roots);
        }
        return composerJson.getCanonicalPath();
    }

    @NotNull
    private static String getPresentablePath(@NotNull VirtualFile composerJson, @NotNull VirtualFile contentRoot, VirtualFile @NotNull [] roots) {
        if (composerJson == null) {
            ComposerUtils.$$$reportNull$$$0(9);
        }
        if (contentRoot == null) {
            ComposerUtils.$$$reportNull$$$0(10);
        }
        if (roots == null) {
            ComposerUtils.$$$reportNull$$$0(11);
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)composerJson, (VirtualFile)contentRoot, (char)'/');
        StringBuilder pathPresentationBuilder = new StringBuilder();
        pathPresentationBuilder.append(".").append("/");
        if (roots.length > 1) {
            pathPresentationBuilder.append(contentRoot.getName()).append("/");
        }
        pathPresentationBuilder.append(relativePath);
        String string = pathPresentationBuilder.toString();
        if (string == null) {
            ComposerUtils.$$$reportNull$$$0(12);
        }
        return string;
    }

    public static void writeAttribute(@NotNull Element element, @NotNull String name, @Nullable String value) {
        if (element == null) {
            ComposerUtils.$$$reportNull$$$0(13);
        }
        if (name == null) {
            ComposerUtils.$$$reportNull$$$0(14);
        }
        if (!StringUtil.isEmptyOrSpaces((String)value)) {
            element.setAttribute(new Attribute(name, value));
        }
    }

    @NotNull
    public static ArrayList<Pair<String, ? extends HyperlinkInfo>> createUnmappedMessage(String path, String parameterName) {
        ArrayList<Pair<String, ? extends HyperlinkInfo>> message = new ArrayList<Pair<String, ? extends HyperlinkInfo>>();
        message.add(Pair.create((Object)(parameterName + " \"" + path + "\" is not mapped to a path for interpreter. Configure mappings in "), null));
        message.add(Pair.create((Object)"settings", (Object)new HyperlinkInfo(){

            public void navigate(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                PhpUiUtil.editConfigurable(project, (Configurable)new ComposerConfigurable(project, true, false));
            }

            public boolean includeInOccurenceNavigation() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/composer/ComposerUtils$2", "navigate"));
            }
        }));
        ArrayList<Pair<String, ? extends HyperlinkInfo>> arrayList = message;
        if (arrayList == null) {
            ComposerUtils.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public static List<String> getRunScriptCommand(@NotNull String scriptName, List<String> commandLineOptions) {
        if (scriptName == null) {
            ComposerUtils.$$$reportNull$$$0(16);
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add("run-script");
        command.add(scriptName);
        command.addAll(commandLineOptions);
        ArrayList<String> arrayList = command;
        if (arrayList == null) {
            ComposerUtils.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public static List<String> getShowAllPackagesCommand() {
        List<String> list = Arrays.asList("show", "--format=json", "-a", "--name-only");
        if (list == null) {
            ComposerUtils.$$$reportNull$$$0(18);
        }
        return list;
    }

    @Contract(pure=true)
    @NotNull
    public static List<String> getShowPackageDetailsCommand(String packageName) {
        List<String> list = Arrays.asList("show", packageName, "-a");
        if (list == null) {
            ComposerUtils.$$$reportNull$$$0(19);
        }
        return list;
    }

    @Contract(pure=true)
    @NotNull
    public static List<String> getValidateCommand() {
        List<String> list = Arrays.asList("validate", "--no-check-publish", "--no-check-lock");
        if (list == null) {
            ComposerUtils.$$$reportNull$$$0(20);
        }
        return list;
    }

    public static String getComposerGroupDisplayId() {
        return NotificationGroup.createIdWithTitle((String)"Composer", (String)PhpBundle.message("framework.composer", new Object[0]));
    }

    public static boolean isProjectUntrusted(Project project) {
        return !TrustedProjectsDialog.confirmLoadingUntrustedProject((Project)project, (String)IdeBundle.message((String)"untrusted.project.general.dialog.title", (Object[])new Object[0]), (String)PhpBundle.message("untrusted.composer.dialog.text", new Object[0]), (String)IdeBundle.message((String)"untrusted.project.dialog.trust.button", (Object[])new Object[0]), (String)IdeBundle.message((String)"untrusted.project.dialog.distrust.button", (Object[])new Object[0]));
    }

    @NotNull
    public static ExecutorService createExecutorService(@NotNull String name, @Nullable String registryKey) {
        if (name == null) {
            ComposerUtils.$$$reportNull$$$0(21);
        }
        int userValue = registryKey != null ? Registry.intValue((String)registryKey, (int)0) : 0;
        int maxThreads = userValue > 0 ? userValue : Math.max(Runtime.getRuntime().availableProcessors() - 2, 1);
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)name, (int)maxThreads);
        if (executorService == null) {
            ComposerUtils.$$$reportNull$$$0(22);
        }
        return executorService;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 12, 15, 17, 18, 19, 20, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/ComposerUtils";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composerJson";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/ComposerUtils";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createOutputPopup";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentablePath";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnmappedMessage";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunScriptCommand";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getShowAllPackagesCommand";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getShowPackageDetailsCommand";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidateCommand";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutorService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstallationCommand";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCreateProjectCommand";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUpdatePackageCommand";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRemovePackageCommand";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createOutputPopup";
                break;
            }
            case 5: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "refreshVendorDir";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPresentablePath";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "writeAttribute";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getRunScriptCommand";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createExecutorService";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 12, 15, 17, 18, 19, 20, 22 -> new IllegalStateException(string);
        };
    }
}

