/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion.weigher;

import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.proximity.ProximityWeigher;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import org.jetbrains.annotations.NotNull;

public final class PhpNamespaceWeigher
extends ProximityWeigher {
    private static final NotNullLazyKey<String, ProximityLocation> PLACE_PHP_NAMESPACE_NAME = NotNullLazyKey.createLazyKey((String)"placePhpNamespaceName", location -> {
        PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder(location.getPosition());
        if (scopeHolder instanceof Function) {
            return ((PhpNamedElement)scopeHolder).getNamespaceName();
        }
        if (scopeHolder instanceof PhpNamespace) {
            return PhpLangUtil.concat(((PhpNamedElement)scopeHolder).getFQN(), "\\");
        }
        return "\\";
    });

    public Integer weigh(@NotNull PsiElement element, @NotNull ProximityLocation location) {
        PsiElement position;
        if (element == null) {
            PhpNamespaceWeigher.$$$reportNull$$$0(0);
        }
        if (location == null) {
            PhpNamespaceWeigher.$$$reportNull$$$0(1);
        }
        if ((position = location.getPosition()) != null) {
            if (element instanceof PhpNamedElement) {
                String positionNamespace;
                String elementNamespace = ((PhpNamedElement)element).getNamespaceName();
                if (PhpLangUtil.equalsNamespaceNames(elementNamespace, positionNamespace = (String)PLACE_PHP_NAMESPACE_NAME.getValue((UserDataHolder)location))) {
                    return elementNamespace.length() * 10;
                }
                String commonPrefix = StringUtil.commonPrefix((String)StringUtil.toLowerCase((String)elementNamespace), (String)StringUtil.toLowerCase((String)positionNamespace));
                return PhpLangUtil.getParentNamespaceFQN(commonPrefix).length();
            }
            return 0;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "location";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/completion/weigher/PhpNamespaceWeigher";
        objectArray[2] = "weigh";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

