/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.completion.PhpLookupElement;
import com.jetbrains.php.completion.PhpVariantsUtil;
import com.jetbrains.php.completion.insert.PhpReferenceInsertHandler;
import com.jetbrains.php.completion.statistics.PhpCompletionUsageCollector;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpFqnLookupElement
extends PhpLookupElement {
    private final String myBareFqn;

    public PhpFqnLookupElement(@NotNull PhpNamedElement namedElement) {
        if (namedElement == null) {
            PhpFqnLookupElement.$$$reportNull$$$0(0);
        }
        super(namedElement);
        this.myBareFqn = this.myFQN.replaceAll("\\\\", "");
    }

    @NotNull
    public Set<String> getAllLookupStrings() {
        ImmutableSet immutableSet = ImmutableSet.of((Object)this.getLookupString(), (Object)this.getBareFqn());
        if (immutableSet == null) {
            PhpFqnLookupElement.$$$reportNull$$$0(1);
        }
        return immutableSet;
    }

    protected String getBareFqn() {
        return this.myBareFqn;
    }

    @Override
    public void handleInsert(@NotNull InsertionContext context) {
        if (context == null) {
            PhpFqnLookupElement.$$$reportNull$$$0(2);
        }
        if (PhpVariantsUtil.fqcnCompletionEnabled()) {
            this.triggerFqcnUsage(context);
        }
        super.handleInsert(context);
    }

    @Override
    @NotNull
    public PhpLookupElement createClassElement() {
        PhpNamedElement element = this.getNamedElement();
        if (element == null) {
            PhpFqnLookupElement phpFqnLookupElement = this;
            if (phpFqnLookupElement == null) {
                PhpFqnLookupElement.$$$reportNull$$$0(3);
            }
            return phpFqnLookupElement;
        }
        PhpFqnLookupElement result = new PhpFqnLookupElement(element){

            @Override
            @NotNull
            public String getLookupString() {
                String string = super.getLookupString() + "class";
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            protected void doRender(LookupElementPresentation presentation, @Nullable PhpType myPhpType, boolean deprecated) {
                super.doRender(presentation, myPhpType, deprecated);
                presentation.setItemText(presentation.getItemText() + "::class");
            }

            @Override
            public void handleInsert(@NotNull InsertionContext context) {
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                context.getDocument().insertString(context.getTailOffset() - "class".length(), (CharSequence)"::");
                PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getDocument());
                super.handleInsert(context);
            }

            @Override
            protected String getBareFqn() {
                return super.getBareFqn() + "class";
            }

            @Override
            protected void updatePresentation(PhpNamedElement myNamedElement) {
                super.updatePresentation(myNamedElement);
                this.icon = PhpIcons.CONSTANT;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/completion/PhpFqnLookupElement$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLookupString";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/completion/PhpFqnLookupElement$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "handleInsert";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        };
        result.myIsClassElement = true;
        result.handler = PhpReferenceInsertHandler.getInstance();
        PhpFqnLookupElement phpFqnLookupElement = result;
        if (phpFqnLookupElement == null) {
            PhpFqnLookupElement.$$$reportNull$$$0(4);
        }
        return phpFqnLookupElement;
    }

    private void triggerFqcnUsage(@NotNull InsertionContext context) {
        ClassReference classReference;
        if (context == null) {
            PhpFqnLookupElement.$$$reportNull$$$0(5);
        }
        if ((classReference = (ClassReference)PhpPsiUtil.getParentByCondition(context.getFile().findElementAt(context.getStartOffset()), false, (Condition<? super PsiElement>)ClassReference.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF)) == null || !classReference.getImmediateNamespaceName().isEmpty()) {
            return;
        }
        PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)classReference);
        if (scope != null && PhpLangUtil.isFqn(PhpCodeInsightUtil.createQualifiedName(scope, this.myFQN))) {
            PhpCompletionUsageCollector.triggerInsertFqcn(this.getProject());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/completion/PhpFqnLookupElement";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/completion/PhpFqnLookupElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLookupStrings";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "triggerFqcnUsage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4 -> new IllegalStateException(string);
        };
    }
}

