/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.completion.expectedArguments.PhpExpectedFunctionScalarArgumentLookupElement;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpParameterBasedTypeProvider;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgumentsIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpMetaRegisteredArgumentsSetCollector;
import org.jetbrains.annotations.NotNull;

final class PhpArgumentSetCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final String PHPSTORM_META_NAMESPACE_NAME = PhpLangUtil.toName("\\PHPSTORM_META\\");

    PhpArgumentSetCompletionProvider() {
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            PhpArgumentSetCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpArgumentSetCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            PhpArgumentSetCompletionProvider.$$$reportNull$$$0(2);
        }
        PsiElement element = parameters.getPosition().getOriginalElement();
        PsiFile file = parameters.getOriginalFile();
        if (file instanceof PhpFile && PhpArgumentSetCompletionProvider.isApplicable(element, file)) {
            PhpMetaRegisteredArgumentsSetCollector registeredArgumentsSetCollector = new PhpMetaRegisteredArgumentsSetCollector();
            PhpControlFlowUtil.processFile((PhpFile)file, registeredArgumentsSetCollector);
            for (String argumentSetName : registeredArgumentsSetCollector.getRegisteredArguments().keySet()) {
                result.addElement(PhpArgumentSetCompletionProvider.createLookupElement(element, (String)StringUtil.QUOTER.apply(argumentSetName)));
            }
        }
    }

    @NotNull
    private static LookupElement createLookupElement(@NotNull PsiElement element, @NotNull String argumentSetName) {
        if (element == null) {
            PhpArgumentSetCompletionProvider.$$$reportNull$$$0(3);
        }
        if (argumentSetName == null) {
            PhpArgumentSetCompletionProvider.$$$reportNull$$$0(4);
        }
        String lookupString = PhpExpectedFunctionScalarArgumentLookupElement.processStringLiteral(argumentSetName, element.getParent() instanceof StringLiteralExpression, true);
        LookupElementBuilder lookupElement = LookupElementBuilder.create((String)lookupString).bold();
        LookupElement lookupElement2 = PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)1.0);
        if (lookupElement2 == null) {
            PhpArgumentSetCompletionProvider.$$$reportNull$$$0(5);
        }
        return lookupElement2;
    }

    private static boolean isApplicable(@NotNull PsiElement element, @NotNull PsiFile file) {
        if (element == null) {
            PhpArgumentSetCompletionProvider.$$$reportNull$$$0(6);
        }
        if (file == null) {
            PhpArgumentSetCompletionProvider.$$$reportNull$$$0(7);
        }
        if (!(file instanceof PhpFile) || !PhpParameterBasedTypeProvider.isMeta(file)) {
            return false;
        }
        PhpNamespace namespace = (PhpNamespace)PsiTreeUtil.getTopmostParentOfType((PsiElement)element, PhpNamespace.class);
        if (namespace == null || !namespace.getName().equals(PHPSTORM_META_NAMESPACE_NAME)) {
            return false;
        }
        FunctionReference functionReference = PhpPsiUtil.getParentOfClass(element, FunctionReference.class);
        return functionReference != null && PhpExpectedFunctionArgumentsIndex.metaFunctionWithName(functionReference, "argumentsSet");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentSetName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/completion/PhpArgumentSetCompletionProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/completion/PhpArgumentSetCompletionProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

