/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.typeInference;

import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldInObjectContextInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConditionInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpFieldReferenceByVariableTypeDFAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpTypeAnalyzerProcessor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.resolve.types.PhpUnaryInfixPostfixTP;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpFieldReferenceByVariableTypeAnalyzer
extends PhpTypeAnalyzerProcessor {
    private final PhpAccessFieldByVariableInstruction myOriginalReadInstruction;
    @NotNull
    private final CharSequence myFieldName;
    @Nullable
    private final CharSequence myVariableName;
    private boolean myAmbiguousResult;

    public PhpFieldReferenceByVariableTypeAnalyzer(PhpAccessFieldByVariableInstruction originalReadInstruction, @NotNull CharSequence fieldName, @Nullable CharSequence variableName) {
        if (fieldName == null) {
            PhpFieldReferenceByVariableTypeAnalyzer.$$$reportNull$$$0(0);
        }
        this.myOriginalReadInstruction = originalReadInstruction;
        this.myFieldName = fieldName;
        this.myVariableName = variableName;
    }

    public boolean processAccessFieldInObjectContextInstruction(PhpAccessFieldInObjectContextInstruction curInstruction) {
        if (PhpLangUtil.equalsFieldNames(this.myFieldName, curInstruction.getFieldName())) {
            return this.processAccessInstruction((PhpAccessInstruction)curInstruction);
        }
        return true;
    }

    public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction curInstruction) {
        if (this.myOriginalReadInstruction.isSameFieldReference(curInstruction) && (curInstruction.getAccess().isWrite() || curInstruction.getAccess().isWriteRef())) {
            FieldReference fieldReference = curInstruction.getFieldReference();
            if (fieldReference == null) {
                return true;
            }
            PsiElement parent = fieldReference.getParent();
            if (parent instanceof UnaryExpression && PhpPsiUtil.isOfType(parent, PhpElementTypes.POSTFIX_EXPRESSION)) {
                this.setType(PhpUnaryInfixPostfixTP.getType((UnaryExpression)parent));
            } else {
                PhpTypeAnalyserVisitor processor2 = new PhpTypeAnalyserVisitor();
                processor2.addInferredType(fieldReference);
                this.setType(processor2.getType());
            }
            return false;
        }
        return true;
    }

    public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
        if (this.myVariableName != null) {
            Variable classReferenceVariable;
            MethodReference methodReference = (MethodReference)ObjectUtils.tryCast((Object)instruction.getFunctionReference(), MethodReference.class);
            Variable variable = classReferenceVariable = methodReference != null ? (Variable)ObjectUtils.tryCast((Object)methodReference.getClassReference(), Variable.class) : null;
            if (classReferenceVariable != null && PhpLangUtil.equalsVariableNames(this.myVariableName, classReferenceVariable.getName())) {
                this.myAmbiguousResult = true;
            }
        }
        return super.processPhpCallInstruction(instruction);
    }

    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
        PhpAccessInstruction.Access access;
        if (PhpLangUtil.equalsVariableNames(this.myVariableName, instruction.getVariableName()) && (access = instruction.getAccess()).isWrite()) {
            return false;
        }
        return super.processAccessVariableInstruction(instruction);
    }

    public boolean processConditionInstruction(PhpConditionInstruction instruction) {
        PhpFieldReferenceByVariableTypeDFAnalyzer analyzer = new PhpFieldReferenceByVariableTypeDFAnalyzer(this.myFieldName, this.myVariableName);
        PhpType type = (PhpType)analyzer.performDFA(instruction.getCondition(), instruction.getResult());
        if (!type.isEmpty()) {
            this.setType(type);
            return !analyzer.completeTypeComputed();
        }
        return true;
    }

    public boolean shouldSkipAmbiguousPredecessors() {
        return true;
    }

    public boolean isAmbiguousResult() {
        return this.myAmbiguousResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/jetbrains/php/codeInsight/typeInference/PhpFieldReferenceByVariableTypeAnalyzer", "<init>"));
    }
}

