/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.controlFlow;

import com.intellij.openapi.util.Key;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpInstructionImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public final class PhpControlFlowCacheUtil {
    public static <P, V> void updateCache(PhpInstruction instruction, P param, V res, Key<Map<P, V>> key) {
        if (instruction instanceof PhpInstructionImpl) {
            ConcurrentHashMap<P, V> data = (ConcurrentHashMap<P, V>)((PhpInstructionImpl)instruction).getUserData(key);
            if (data == null) {
                data = new ConcurrentHashMap<P, V>();
                ((PhpInstructionImpl)instruction).putUserData(key, data);
            }
            data.put(param, res);
        }
    }

    @Nullable
    public static <P, V> V tryFetchPreviouslyComputedResultFromCache(PhpInstruction instruction, P param, Key<Map<P, V>> key) {
        if (instruction instanceof PhpInstructionImpl) {
            Map data = (Map)((PhpInstructionImpl)instruction).getUserData(key);
            return data != null ? (V)data.get(param) : null;
        }
        return null;
    }
}

