/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpDocTagNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFlatCollectionIndexBase;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;

public final class PhpPluginSuggestionsActivity
implements StartupActivity {
    private static final Map<@NlsSafe String, PluginId> PLUGIN_NAMES_TO_IDS = Map.of("Psalm", PluginId.getId((String)"com.intellij.php.psalm"), "PHPStan", PluginId.getId((String)"com.intellij.php.tools.quality.phpstan"));

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            PhpPluginSuggestionsActivity.$$$reportNull$$$0(0);
        }
        HashSet<String> dependencies = new HashSet<String>();
        for (Map.Entry<String, PluginId> e : PLUGIN_NAMES_TO_IDS.entrySet()) {
            if (!PluginManagerCore.isDisabled((PluginId)e.getValue())) continue;
            String key = e.getKey();
            dependencies.add(key);
        }
        if (!dependencies.isEmpty()) {
            ReadAction.nonBlocking(() -> PhpPluginSuggestionsActivity.getPluginNamesToEnable(project, dependencies)).inSmartMode(project).finishOnUiThread(ModalityState.nonModal(), names -> names.forEach(name -> PhpPluginSuggestionsActivity.notify(project, name))).submit((Executor)AppExecutorUtil.getAppExecutorService());
        }
    }

    private static void notify(@NotNull Project project, final @NotNull String name) {
        if (project == null) {
            PhpPluginSuggestionsActivity.$$$reportNull$$$0(1);
        }
        if (name == null) {
            PhpPluginSuggestionsActivity.$$$reportNull$$$0(2);
        }
        final Notification notification = new Notification("PHP Plugin Suggestion", PhpBundle.message("notification.content.usage.found.in.project", name), NotificationType.INFORMATION);
        notification.setSuggestionType(true).addAction(new AnAction(PhpBundle.message("action.enable.plugin.text", name)){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                notification.expire();
                PluginId id = PLUGIN_NAMES_TO_IDS.get(name);
                PluginManagerCore.enablePlugin((PluginId)id);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/PhpPluginSuggestionsActivity$1", "actionPerformed"));
            }
        }).notify(project);
    }

    private static @NotNull Collection<@NlsSafe String> getPluginNamesToEnable(@NotNull Project project, Collection<String> dependencies) {
        if (project == null) {
            PhpPluginSuggestionsActivity.$$$reportNull$$$0(3);
        }
        if (dependencies.isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PhpPluginSuggestionsActivity.$$$reportNull$$$0(4);
            }
            return set;
        }
        HashSet<@NlsSafe String> res = new HashSet<String>();
        PhpFlatCollectionIndexBase.processValues(PhpDocTagNameIndex.KEY, (file, value) -> {
            for (String customTag : value) {
                for (String dependency : dependencies) {
                    if (!StringUtil.startsWithIgnoreCase((String)customTag, (String)("@" + dependency + "-"))) continue;
                    res.add(dependency);
                }
            }
            return res.size() < 2;
        }, GlobalSearchScope.allScope((Project)project));
        HashSet<String> hashSet = res;
        if (hashSet == null) {
            PhpPluginSuggestionsActivity.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/PhpPluginSuggestionsActivity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/PhpPluginSuggestionsActivity";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginNamesToEnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "notify";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPluginNamesToEnable";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

