/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php;

import com.intellij.ide.IconProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class PhpClassMemberIconProvider
extends IconProvider {
    private static final RowIcon PRIVATE_CONSTANT = IconManager.getInstance().createRowIcon(2);
    private static final RowIcon PROTECTED_CONSTANT = IconManager.getInstance().createRowIcon(2);
    private static final RowIcon PUBLIC_CONSTANT = IconManager.getInstance().createRowIcon(2);
    private static final RowIcon PRIVATE_FINAL_CONSTANT = IconManager.getInstance().createRowIcon(2);
    private static final RowIcon PROTECTED_FINAL_CONSTANT = IconManager.getInstance().createRowIcon(2);
    private static final RowIcon PUBLIC_FINAL_CONSTANT = IconManager.getInstance().createRowIcon(2);
    private static final RowIcon PRIVATE_FIELD = IconManager.getInstance().createRowIcon(2);
    private static final RowIcon PROTECTED_FIELD = IconManager.getInstance().createRowIcon(2);
    private static final RowIcon PUBLIC_FIELD = IconManager.getInstance().createRowIcon(2);
    private static final RowIcon PRIVATE_STATIC_FIELD = IconManager.getInstance().createRowIcon(2);
    private static final RowIcon PROTECTED_STATIC_FIELD = IconManager.getInstance().createRowIcon(2);
    private static final RowIcon PUBLIC_STATIC_FIELD = IconManager.getInstance().createRowIcon(2);
    private static final RowIcon PRIVATE_READONLY_FIELD = IconManager.getInstance().createRowIcon(2);
    private static final RowIcon PROTECTED_READONLY_FIELD = IconManager.getInstance().createRowIcon(2);
    private static final RowIcon PUBLIC_READONLY_FIELD = IconManager.getInstance().createRowIcon(2);
    private static final RowIcon PRIVATE_METHOD;
    private static final RowIcon PROTECTED_METHOD;
    private static final RowIcon PUBLIC_METHOD;
    private static final RowIcon PRIVATE_TEST_METHOD;
    private static final RowIcon PROTECTED_TEST_METHOD;
    private static final RowIcon PUBLIC_TEST_METHOD;
    private static final RowIcon PRIVATE_ABSTRACT_METHOD;
    private static final RowIcon PROTECTED_ABSTRACT_METHOD;
    private static final RowIcon PUBLIC_ABSTRACT_METHOD;
    private static final RowIcon PRIVATE_STATIC_METHOD;
    private static final RowIcon PROTECTED_STATIC_METHOD;
    private static final RowIcon PUBLIC_STATIC_METHOD;
    private static final RowIcon PRIVATE_FINAL_METHOD;
    private static final RowIcon PROTECTED_FINAL_METHOD;
    private static final RowIcon PUBLIC_FINAL_METHOD;
    private static final RowIcon PRIVATE_ABSTRACT_STATIC_METHOD;
    private static final RowIcon PROTECTED_ABSTRACT_STATIC_METHOD;
    private static final RowIcon PUBLIC_ABSTRACT_STATIC_METHOD;
    private static final RowIcon PRIVATE_FINAL_STATIC_METHOD;
    private static final RowIcon PROTECTED_FINAL_STATIC_METHOD;
    private static final RowIcon PUBLIC_FINAL_STATIC_METHOD;

    public Icon getIcon(@NotNull PsiElement element, @Iconable.IconFlags int flags) {
        if (element == null) {
            PhpClassMemberIconProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof Field) {
            return PhpClassMemberIconProvider.getFieldIcon((Field)element);
        }
        if (element instanceof Method) {
            return PhpClassMemberIconProvider.getMethodIcon((Method)element);
        }
        return null;
    }

    public static Icon getFieldIcon(@NotNull Field field) {
        if (field == null) {
            PhpClassMemberIconProvider.$$$reportNull$$$0(1);
        }
        PhpModifier modifier = field.getModifier();
        if (field.isConstant()) {
            if (field.getModifier().isFinal()) {
                return switch (modifier.getAccess()) {
                    default -> throw new MatchException(null, null);
                    case PhpModifier.Access.PRIVATE -> PRIVATE_FINAL_CONSTANT;
                    case PhpModifier.Access.PROTECTED -> PROTECTED_FINAL_CONSTANT;
                    case PhpModifier.Access.PUBLIC -> PUBLIC_FINAL_CONSTANT;
                };
            }
            return switch (modifier.getAccess()) {
                default -> throw new MatchException(null, null);
                case PhpModifier.Access.PRIVATE -> PRIVATE_CONSTANT;
                case PhpModifier.Access.PROTECTED -> PROTECTED_CONSTANT;
                case PhpModifier.Access.PUBLIC -> PUBLIC_CONSTANT;
            };
        }
        if (modifier.isStatic()) {
            return switch (modifier.getAccess()) {
                default -> throw new MatchException(null, null);
                case PhpModifier.Access.PRIVATE -> PRIVATE_STATIC_FIELD;
                case PhpModifier.Access.PROTECTED -> PROTECTED_STATIC_FIELD;
                case PhpModifier.Access.PUBLIC -> PUBLIC_STATIC_FIELD;
            };
        }
        if (field.isReadonly()) {
            return switch (modifier.getAccess()) {
                default -> throw new MatchException(null, null);
                case PhpModifier.Access.PRIVATE -> PRIVATE_READONLY_FIELD;
                case PhpModifier.Access.PROTECTED -> PROTECTED_READONLY_FIELD;
                case PhpModifier.Access.PUBLIC -> PUBLIC_READONLY_FIELD;
            };
        }
        return switch (modifier.getAccess()) {
            default -> throw new MatchException(null, null);
            case PhpModifier.Access.PRIVATE -> PRIVATE_FIELD;
            case PhpModifier.Access.PROTECTED -> PROTECTED_FIELD;
            case PhpModifier.Access.PUBLIC -> PUBLIC_FIELD;
        };
    }

    public static Icon getMethodIcon(@NotNull Method method) {
        if (method == null) {
            PhpClassMemberIconProvider.$$$reportNull$$$0(2);
        }
        PhpModifier.Access access = method.getAccess();
        if (method.isAbstract()) {
            if (method.isStatic()) {
                return switch (access) {
                    default -> throw new MatchException(null, null);
                    case PhpModifier.Access.PRIVATE -> PRIVATE_ABSTRACT_STATIC_METHOD;
                    case PhpModifier.Access.PROTECTED -> PROTECTED_ABSTRACT_STATIC_METHOD;
                    case PhpModifier.Access.PUBLIC -> PUBLIC_ABSTRACT_STATIC_METHOD;
                };
            }
            return switch (access) {
                default -> throw new MatchException(null, null);
                case PhpModifier.Access.PRIVATE -> PRIVATE_ABSTRACT_METHOD;
                case PhpModifier.Access.PROTECTED -> PROTECTED_ABSTRACT_METHOD;
                case PhpModifier.Access.PUBLIC -> PUBLIC_ABSTRACT_METHOD;
            };
        }
        if (method.isFinal() || !DumbService.isDumb((Project)method.getProject()) && PhpDocUtil.getFinalDocTag((PhpNamedElement)method) != null) {
            if (method.isStatic()) {
                return switch (access) {
                    default -> throw new MatchException(null, null);
                    case PhpModifier.Access.PRIVATE -> PRIVATE_FINAL_STATIC_METHOD;
                    case PhpModifier.Access.PROTECTED -> PROTECTED_FINAL_STATIC_METHOD;
                    case PhpModifier.Access.PUBLIC -> PUBLIC_FINAL_STATIC_METHOD;
                };
            }
            return switch (access) {
                default -> throw new MatchException(null, null);
                case PhpModifier.Access.PRIVATE -> PRIVATE_FINAL_METHOD;
                case PhpModifier.Access.PROTECTED -> PROTECTED_FINAL_METHOD;
                case PhpModifier.Access.PUBLIC -> PUBLIC_FINAL_METHOD;
            };
        }
        if (method.isStatic()) {
            return switch (access) {
                default -> throw new MatchException(null, null);
                case PhpModifier.Access.PRIVATE -> PRIVATE_STATIC_METHOD;
                case PhpModifier.Access.PROTECTED -> PROTECTED_STATIC_METHOD;
                case PhpModifier.Access.PUBLIC -> PUBLIC_STATIC_METHOD;
            };
        }
        if (PhpUnitUtil.hasTestMethodSignature(method) && !DumbService.getInstance((Project)method.getProject()).isDumb() && method.isValid() && PhpUnitUtil.isTestMethod(method)) {
            return switch (access) {
                default -> throw new MatchException(null, null);
                case PhpModifier.Access.PRIVATE -> PRIVATE_TEST_METHOD;
                case PhpModifier.Access.PROTECTED -> PROTECTED_TEST_METHOD;
                case PhpModifier.Access.PUBLIC -> PUBLIC_TEST_METHOD;
            };
        }
        return switch (access) {
            default -> throw new MatchException(null, null);
            case PhpModifier.Access.PRIVATE -> PRIVATE_METHOD;
            case PhpModifier.Access.PROTECTED -> PROTECTED_METHOD;
            case PhpModifier.Access.PUBLIC -> PUBLIC_METHOD;
        };
    }

    private static void wrapIcon(@NotNull RowIcon icon, @NotNull Icon baseIcon, @NotNull PhpModifier.Access access) {
        if (icon == null) {
            PhpClassMemberIconProvider.$$$reportNull$$$0(3);
        }
        if (baseIcon == null) {
            PhpClassMemberIconProvider.$$$reportNull$$$0(4);
        }
        if (access == null) {
            PhpClassMemberIconProvider.$$$reportNull$$$0(5);
        }
        icon.setIcon(baseIcon, 0);
        icon.setIcon(PhpPresentationUtil.getAccessIcon(access), 1);
    }

    static {
        PhpClassMemberIconProvider.wrapIcon(PRIVATE_CONSTANT, PhpIcons.CONSTANT, PhpModifier.Access.PRIVATE);
        PhpClassMemberIconProvider.wrapIcon(PROTECTED_CONSTANT, PhpIcons.CONSTANT, PhpModifier.Access.PROTECTED);
        PhpClassMemberIconProvider.wrapIcon(PUBLIC_CONSTANT, PhpIcons.CONSTANT, PhpModifier.Access.PUBLIC);
        PhpClassMemberIconProvider.wrapIcon(PRIVATE_FINAL_CONSTANT, PhpIcons.FINAL_CONSTANT, PhpModifier.Access.PRIVATE);
        PhpClassMemberIconProvider.wrapIcon(PROTECTED_FINAL_CONSTANT, PhpIcons.FINAL_CONSTANT, PhpModifier.Access.PROTECTED);
        PhpClassMemberIconProvider.wrapIcon(PUBLIC_FINAL_CONSTANT, PhpIcons.FINAL_CONSTANT, PhpModifier.Access.PUBLIC);
        PhpClassMemberIconProvider.wrapIcon(PRIVATE_FIELD, PhpIcons.FIELD, PhpModifier.Access.PRIVATE);
        PhpClassMemberIconProvider.wrapIcon(PROTECTED_FIELD, PhpIcons.FIELD, PhpModifier.Access.PROTECTED);
        PhpClassMemberIconProvider.wrapIcon(PUBLIC_FIELD, PhpIcons.FIELD, PhpModifier.Access.PUBLIC);
        PhpClassMemberIconProvider.wrapIcon(PRIVATE_STATIC_FIELD, PhpIcons.STATIC_FIELD, PhpModifier.Access.PRIVATE);
        PhpClassMemberIconProvider.wrapIcon(PROTECTED_STATIC_FIELD, PhpIcons.STATIC_FIELD, PhpModifier.Access.PROTECTED);
        PhpClassMemberIconProvider.wrapIcon(PUBLIC_STATIC_FIELD, PhpIcons.STATIC_FIELD, PhpModifier.Access.PUBLIC);
        PhpClassMemberIconProvider.wrapIcon(PRIVATE_READONLY_FIELD, PhpIcons.READONLY_FIELD, PhpModifier.Access.PRIVATE);
        PhpClassMemberIconProvider.wrapIcon(PROTECTED_READONLY_FIELD, PhpIcons.READONLY_FIELD, PhpModifier.Access.PROTECTED);
        PhpClassMemberIconProvider.wrapIcon(PUBLIC_READONLY_FIELD, PhpIcons.READONLY_FIELD, PhpModifier.Access.PUBLIC);
        PRIVATE_METHOD = IconManager.getInstance().createRowIcon(2);
        PROTECTED_METHOD = IconManager.getInstance().createRowIcon(2);
        PUBLIC_METHOD = IconManager.getInstance().createRowIcon(2);
        PRIVATE_TEST_METHOD = IconManager.getInstance().createRowIcon(2);
        PROTECTED_TEST_METHOD = IconManager.getInstance().createRowIcon(2);
        PUBLIC_TEST_METHOD = IconManager.getInstance().createRowIcon(2);
        PRIVATE_ABSTRACT_METHOD = IconManager.getInstance().createRowIcon(2);
        PROTECTED_ABSTRACT_METHOD = IconManager.getInstance().createRowIcon(2);
        PUBLIC_ABSTRACT_METHOD = IconManager.getInstance().createRowIcon(2);
        PRIVATE_STATIC_METHOD = IconManager.getInstance().createRowIcon(2);
        PROTECTED_STATIC_METHOD = IconManager.getInstance().createRowIcon(2);
        PUBLIC_STATIC_METHOD = IconManager.getInstance().createRowIcon(2);
        PRIVATE_FINAL_METHOD = IconManager.getInstance().createRowIcon(2);
        PROTECTED_FINAL_METHOD = IconManager.getInstance().createRowIcon(2);
        PUBLIC_FINAL_METHOD = IconManager.getInstance().createRowIcon(2);
        PRIVATE_ABSTRACT_STATIC_METHOD = IconManager.getInstance().createRowIcon(2);
        PROTECTED_ABSTRACT_STATIC_METHOD = IconManager.getInstance().createRowIcon(2);
        PUBLIC_ABSTRACT_STATIC_METHOD = IconManager.getInstance().createRowIcon(2);
        PRIVATE_FINAL_STATIC_METHOD = IconManager.getInstance().createRowIcon(2);
        PROTECTED_FINAL_STATIC_METHOD = IconManager.getInstance().createRowIcon(2);
        PUBLIC_FINAL_STATIC_METHOD = IconManager.getInstance().createRowIcon(2);
        PhpClassMemberIconProvider.wrapIcon(PRIVATE_METHOD, PhpIcons.METHOD, PhpModifier.Access.PRIVATE);
        PhpClassMemberIconProvider.wrapIcon(PROTECTED_METHOD, PhpIcons.METHOD, PhpModifier.Access.PROTECTED);
        PhpClassMemberIconProvider.wrapIcon(PUBLIC_METHOD, PhpIcons.METHOD, PhpModifier.Access.PUBLIC);
        PhpClassMemberIconProvider.wrapIcon(PRIVATE_TEST_METHOD, PhpIcons.PHP_TEST_METHOD, PhpModifier.Access.PRIVATE);
        PhpClassMemberIconProvider.wrapIcon(PROTECTED_TEST_METHOD, PhpIcons.PHP_TEST_METHOD, PhpModifier.Access.PROTECTED);
        PhpClassMemberIconProvider.wrapIcon(PUBLIC_TEST_METHOD, PhpIcons.PHP_TEST_METHOD, PhpModifier.Access.PUBLIC);
        PhpClassMemberIconProvider.wrapIcon(PRIVATE_ABSTRACT_METHOD, PhpIcons.ABSTRACT_METHOD, PhpModifier.Access.PRIVATE);
        PhpClassMemberIconProvider.wrapIcon(PROTECTED_ABSTRACT_METHOD, PhpIcons.ABSTRACT_METHOD, PhpModifier.Access.PROTECTED);
        PhpClassMemberIconProvider.wrapIcon(PUBLIC_ABSTRACT_METHOD, PhpIcons.ABSTRACT_METHOD, PhpModifier.Access.PUBLIC);
        PhpClassMemberIconProvider.wrapIcon(PRIVATE_STATIC_METHOD, PhpIcons.STATIC_METHOD, PhpModifier.Access.PRIVATE);
        PhpClassMemberIconProvider.wrapIcon(PROTECTED_STATIC_METHOD, PhpIcons.STATIC_METHOD, PhpModifier.Access.PROTECTED);
        PhpClassMemberIconProvider.wrapIcon(PUBLIC_STATIC_METHOD, PhpIcons.STATIC_METHOD, PhpModifier.Access.PUBLIC);
        PhpClassMemberIconProvider.wrapIcon(PRIVATE_FINAL_METHOD, (Icon)PhpIcons.FINAL_METHOD, PhpModifier.Access.PRIVATE);
        PhpClassMemberIconProvider.wrapIcon(PROTECTED_FINAL_METHOD, (Icon)PhpIcons.FINAL_METHOD, PhpModifier.Access.PROTECTED);
        PhpClassMemberIconProvider.wrapIcon(PUBLIC_FINAL_METHOD, (Icon)PhpIcons.FINAL_METHOD, PhpModifier.Access.PUBLIC);
        PhpClassMemberIconProvider.wrapIcon(PRIVATE_ABSTRACT_STATIC_METHOD, (Icon)PhpIcons.ABSTRACT_STATIC_METHOD, PhpModifier.Access.PRIVATE);
        PhpClassMemberIconProvider.wrapIcon(PROTECTED_ABSTRACT_STATIC_METHOD, (Icon)PhpIcons.ABSTRACT_STATIC_METHOD, PhpModifier.Access.PROTECTED);
        PhpClassMemberIconProvider.wrapIcon(PUBLIC_ABSTRACT_STATIC_METHOD, (Icon)PhpIcons.ABSTRACT_STATIC_METHOD, PhpModifier.Access.PUBLIC);
        PhpClassMemberIconProvider.wrapIcon(PRIVATE_FINAL_STATIC_METHOD, (Icon)PhpIcons.FINAL_STATIC_METHOD, PhpModifier.Access.PRIVATE);
        PhpClassMemberIconProvider.wrapIcon(PROTECTED_FINAL_STATIC_METHOD, (Icon)PhpIcons.FINAL_STATIC_METHOD, PhpModifier.Access.PROTECTED);
        PhpClassMemberIconProvider.wrapIcon(PUBLIC_FINAL_STATIC_METHOD, (Icon)PhpIcons.FINAL_STATIC_METHOD, PhpModifier.Access.PUBLIC);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseIcon";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "access";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/PhpClassMemberIconProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getFieldIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getMethodIcon";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "wrapIcon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

