/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpLanguageLevelChangeUsageCollector;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.PhpProjectSharedConfiguration;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpMaxLanguageLevelIndex;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;

public final class PhpChangeDefaultLanguageLevelPostStartupActivity
implements StartupActivity {
    private static final NotificationGroup NOTIFICATION_GROUP = (NotificationGroup)Cancellation.forceNonCancellableSectionInClassInitializer(() -> NotificationGroupManager.getInstance().getNotificationGroup("PHP"));

    public void runActivity(@NotNull Project project) {
        Application app;
        if (project == null) {
            PhpChangeDefaultLanguageLevelPostStartupActivity.$$$reportNull$$$0(0);
        }
        if ((app = ApplicationManager.getApplication()).isUnitTestMode() || app.isHeadlessEnvironment()) {
            return;
        }
        if (ComposerDataService.getInstance(project).syncLanguageLevel()) {
            return;
        }
        ReadAction.nonBlocking(() -> {
            PhpProjectSharedConfiguration.State configuration = PhpProjectConfigurationFacade.getInstance(project).getProjectSharedConfiguration();
            if (!configuration.isSuggestChangeDefaultLanguageLevel()) {
                return null;
            }
            return PhpMaxLanguageLevelIndex.getMaxUsedLanguageLevel(project);
        }).inSmartMode(project).finishOnUiThread(ModalityState.nonModal(), maxUsedLanguageLevel -> {
            if (maxUsedLanguageLevel == null) {
                return;
            }
            PhpProjectSharedConfiguration.State configuration = PhpProjectConfigurationFacade.getInstance(project).getProjectSharedConfiguration();
            PhpLanguageLevel currentLevel = configuration.getLanguageLevel();
            if (currentLevel.compareTo((Enum)maxUsedLanguageLevel) < 0) {
                PhpLanguageLevelChangeUsageCollector.triggerLanguageLevelChanged(project, currentLevel, maxUsedLanguageLevel);
                WriteAction.run(() -> {
                    configuration.setSuggestChangeDefaultLanguageLevel(false);
                    configuration.setLanguageLevel(maxUsedLanguageLevel);
                });
                PhpChangeDefaultLanguageLevelPostStartupActivity.notifyAboutChangedLanguageLevel(project, configuration, currentLevel, maxUsedLanguageLevel);
            }
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private static void notifyAboutChangedLanguageLevel(final @NotNull Project project, final PhpProjectSharedConfiguration.State configuration, final PhpLanguageLevel currentLevel, final PhpLanguageLevel maxUsedLanguageLevel) {
        if (project == null) {
            PhpChangeDefaultLanguageLevelPostStartupActivity.$$$reportNull$$$0(1);
        }
        final Notification notification = NOTIFICATION_GROUP.createNotification(PhpBundle.message("notification.content.language.level.was.changed.to.based.on.project.usage", maxUsedLanguageLevel.getPresentableName()), NotificationType.INFORMATION);
        notification.addAction(new AnAction(PhpBundle.message("action.revert.back.to.text", currentLevel.getPresentableName())){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                PhpLanguageLevelChangeUsageCollector.triggerLanguageLevelChangeReverted(project, currentLevel, maxUsedLanguageLevel);
                configuration.setLanguageLevel(currentLevel);
                notification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/PhpChangeDefaultLanguageLevelPostStartupActivity$1", "actionPerformed"));
            }
        });
        Notifications.Bus.notify((Notification)notification, (Project)project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/jetbrains/php/PhpChangeDefaultLanguageLevelPostStartupActivity";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyAboutChangedLanguageLevel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

