/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.php.caches.CostAdaptiveCache;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassAlias;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpShapeEntriesIndex;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.Map;

@Service(value={Service.Level.PROJECT})
public final class PhpCaches
implements Disposable {
    public static final int TYPE_CACHE_SIZE = 7000;
    private final LowMemoryWatcher myLowMemoryWatcher;
    private static final int BASE_SIZE = Math.toIntExact(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax() >> 21);
    public volatile CostAdaptiveCache<PhpType> TYPE_COMPLETION_CACHE = new CostAdaptiveCache(32 * BASE_SIZE);
    public volatile CostAdaptiveCache<Collection<? extends PhpNamedElement>> SIGNATURES_CACHE = new CostAdaptiveCache(64 * BASE_SIZE);
    public volatile CostAdaptiveCache<Collection<PhpClass>> subclassCache = new CostAdaptiveCache(4 * BASE_SIZE, true);
    public volatile CostAdaptiveCache<Collection<PhpClass>> directSubclassesCache = new CostAdaptiveCache(4 * BASE_SIZE, true);
    public volatile CostAdaptiveCache<Collection<PhpClass>> classCache = new CostAdaptiveCache(16 * BASE_SIZE, true);
    public volatile CostAdaptiveCache<Collection<PhpClass>> interfaceCache = new CostAdaptiveCache(BASE_SIZE, true);
    public volatile CostAdaptiveCache<Collection<PhpClass>> traitCache = new CostAdaptiveCache(BASE_SIZE, true);
    public volatile CostAdaptiveCache<Collection<Variable>> globalVariablesCache = new CostAdaptiveCache(2 * BASE_SIZE, true);
    public volatile CostAdaptiveCache<Collection<PhpClassAlias>> aliasesClassCache = new CostAdaptiveCache(BASE_SIZE, true);
    public volatile CostAdaptiveCache<Collection<PhpClassAlias>> aliasesInterfaceCache = new CostAdaptiveCache(BASE_SIZE, true);
    public volatile CostAdaptiveCache<Collection<PhpClassAlias>> aliasesTraitCache = new CostAdaptiveCache(BASE_SIZE, true);
    public volatile CostAdaptiveCache<Collection<PhpClassAlias>> allAliasesCache = new CostAdaptiveCache(BASE_SIZE, true);
    public volatile CostAdaptiveCache<Collection<Constant>> caseSensitiveConstantsCache = new CostAdaptiveCache(BASE_SIZE, true);
    public volatile CostAdaptiveCache<Collection<Constant>> caseInsensitiveConstantsCache = new CostAdaptiveCache(BASE_SIZE, true);
    public volatile CostAdaptiveCache<Collection<Function>> functionsCache = new CostAdaptiveCache(8 * BASE_SIZE, true);
    public volatile CostAdaptiveCache<Collection<String>> SUBCLASSES_CACHE = new CostAdaptiveCache(4 * BASE_SIZE, true);
    public volatile Map<PsiElement, PhpType> TYPE_CACHE = CollectionFactory.createConcurrentWeakMap();
    public volatile Map<PsiElement, PhpType> TYPE_WITHOUT_BACKEDGES_CACHE = CollectionFactory.createConcurrentWeakMap();
    public volatile CostAdaptiveCache<Collection<PhpShapeEntriesIndex.PhpShapeEntry>> shapesTypeCache = new CostAdaptiveCache(4 * BASE_SIZE, true);

    public PhpCaches(Project project) {
        this.myLowMemoryWatcher = LowMemoryWatcher.register(() -> this.clearCaches(true));
        PsiModificationTracker.Listener modificationHandler = () -> this.clearCaches(false);
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(PsiModificationTracker.TOPIC, (Object)modificationHandler);
    }

    public void clearCaches(boolean onLowMem) {
        Map<PsiElement, PhpType> previousMap;
        this.TYPE_COMPLETION_CACHE.clear(onLowMem);
        this.SIGNATURES_CACHE.clear(onLowMem);
        this.subclassCache.clear(onLowMem);
        this.directSubclassesCache.clear(onLowMem);
        this.classCache.clear(onLowMem);
        this.interfaceCache.clear(onLowMem);
        this.traitCache.clear(onLowMem);
        this.globalVariablesCache.clear(onLowMem);
        this.aliasesClassCache.clear(onLowMem);
        this.aliasesInterfaceCache.clear(onLowMem);
        this.aliasesTraitCache.clear(onLowMem);
        this.allAliasesCache.clear(onLowMem);
        this.caseSensitiveConstantsCache.clear(onLowMem);
        this.caseInsensitiveConstantsCache.clear(onLowMem);
        this.functionsCache.clear(onLowMem);
        this.SUBCLASSES_CACHE.clear(onLowMem);
        this.shapesTypeCache.clear(onLowMem);
        if (!this.TYPE_CACHE.isEmpty()) {
            previousMap = this.TYPE_CACHE;
            this.TYPE_CACHE = CollectionFactory.createConcurrentWeakMap();
            previousMap.clear();
        }
        if (!this.TYPE_WITHOUT_BACKEDGES_CACHE.isEmpty()) {
            previousMap = this.TYPE_WITHOUT_BACKEDGES_CACHE;
            this.TYPE_WITHOUT_BACKEDGES_CACHE = CollectionFactory.createConcurrentWeakMap();
            previousMap.clear();
        }
    }

    public void dispose() {
        this.myLowMemoryWatcher.stop();
        this.clearCaches(true);
    }

    public static PhpCaches getInstance(Project project) {
        return (PhpCaches)project.getService(PhpCaches.class);
    }
}

