/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.quickfix;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.psi.XsltParameter;
import org.intellij.lang.xpath.xslt.quickfix.AbstractFix;
import org.intellij.lang.xpath.xslt.refactoring.RefactoringUtil;
import org.intellij.plugins.xpathView.XPathBundle;
import org.jetbrains.annotations.NotNull;

public class AddWithParamFix
extends AbstractFix {
    protected XmlTag myTag;
    private final String myName;

    protected AddWithParamFix() {
        this.myName = null;
    }

    public AddWithParamFix(XsltParameter parameter, XmlTag tag) {
        this.myTag = tag;
        this.myName = parameter.getName();
    }

    @NotNull
    public String getText() {
        String string = XPathBundle.message("intention.name.add.argument.for.x", this.myName);
        if (string == null) {
            AddWithParamFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = XPathBundle.message("intention.family.name.add.argument", new Object[0]);
        if (string == null) {
            AddWithParamFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isAvailableImpl(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            AddWithParamFix.$$$reportNull$$$0(2);
        }
        return this.myTag.isValid();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected boolean requiresEditor() {
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            AddWithParamFix.$$$reportNull$$$0(3);
        }
        SmartPsiElementPointer result = (SmartPsiElementPointer)WriteAction.compute(() -> {
            XmlTag withParamTag = RefactoringUtil.addWithParam(this.myTag);
            withParamTag.setAttribute("name", this.myName != null ? this.myName : "dummy");
            withParamTag.setAttribute("select", "dummy");
            return SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)withParamTag);
        });
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        Document doc = psiDocumentManager.getDocument(psiFile);
        assert (doc != null);
        psiDocumentManager.doPostponedOperationsAndUnblockDocument(doc);
        XmlTag withParamTag = (XmlTag)result.getElement();
        assert (withParamTag != null);
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)withParamTag);
        XmlAttribute selectAttr = withParamTag.getAttribute("select", null);
        assert (selectAttr != null);
        PsiElement dummy = XsltSupport.getAttValueToken(selectAttr);
        builder.replaceElement(dummy, (Expression)new MacroCallNode((Macro)new CompleteMacro()));
        if (this.myName == null) {
            XmlAttribute nameAttr = withParamTag.getAttribute("name", null);
            assert (nameAttr != null);
            dummy = XsltSupport.getAttValueToken(nameAttr);
            builder.replaceElement(dummy, (Expression)new MacroCallNode((Macro)new CompleteMacro()));
        }
        AddWithParamFix.moveTo(editor, withParamTag);
        WriteAction.run(() -> {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            TemplateManager mgr = TemplateManager.getInstance((Project)this.myTag.getProject());
            mgr.startTemplate(editor, builder.buildInlineTemplate());
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/quickfix/AddWithParamFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/quickfix/AddWithParamFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableImpl";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

